/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.resolution.typesolvers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import me.tomassetti.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import me.tomassetti.symbolsolver.javassistmodel.JavassistFactory;
import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;

public class JarTypeSolver
implements TypeSolver {
    private TypeSolver parent;
    private Map<String, ClasspathElement> classpathElements = new HashMap<String, ClasspathElement>();
    private ClassPool classPool = new ClassPool(false);

    public JarTypeSolver(String pathToJar) throws IOException {
        try {
            this.classPool.appendClassPath(pathToJar);
            this.classPool.appendSystemPath();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        JarFile jarFile = new JarFile(pathToJar);
        ZipEntry entry = null;
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            if (entry != null && !entry.isDirectory() && entry.getName().endsWith(".class")) {
                String name = this.entryPathToClassName(entry.getName());
                this.classpathElements.put(name, new ClasspathElement(jarFile, (JarEntry)entry, name));
            }
            entry = e.nextElement();
        }
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }

    private String entryPathToClassName(String entryPath) {
        if (!entryPath.endsWith(".class")) {
            throw new IllegalStateException();
        }
        String className = entryPath.substring(0, entryPath.length() - ".class".length());
        className = className.replaceAll("/", ".");
        className = className.replaceAll("\\$", ".");
        return className;
    }

    public SymbolReference<TypeDeclaration> tryToSolveType(String name) {
        try {
            if (this.classpathElements.containsKey(name)) {
                return SymbolReference.solved((Declaration)JavassistFactory.toTypeDeclaration(this.classpathElements.get(name).toCtClass(), this.getRoot()));
            }
            return SymbolReference.unsolved(TypeDeclaration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeDeclaration solveType(String name) throws UnsolvedSymbolException {
        SymbolReference<TypeDeclaration> ref = this.tryToSolveType(name);
        if (ref.isSolved()) {
            return (TypeDeclaration)ref.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }

    private class ClasspathElement {
        private JarFile jarFile;
        private JarEntry entry;
        private String path;

        public ClasspathElement(JarFile jarFile, JarEntry entry, String path) {
            this.jarFile = jarFile;
            this.entry = entry;
            this.path = path;
        }

        CtClass toCtClass() throws IOException {
            InputStream is = this.jarFile.getInputStream(this.entry);
            CtClass ctClass = JarTypeSolver.this.classPool.makeClass(is);
            return ctClass;
        }
    }
}

