/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.resolution.typesolvers;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import me.tomassetti.symbolsolver.javaparser.Navigator;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFacade;
import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;

public class JavaParserTypeSolver
implements TypeSolver {
    private File srcDir;
    private TypeSolver parent;

    public JavaParserTypeSolver(File srcDir) {
        this.srcDir = srcDir;
    }

    public String toString() {
        return "JavaParserTypeSolver{srcDir=" + this.srcDir + ", parent=" + this.parent + '}';
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }

    private String simpleName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    public SymbolReference<me.tomassetti.symbolsolver.model.declarations.TypeDeclaration> tryToSolveType(String name) {
        File srcFile = new File(this.srcDir.getAbsolutePath() + "/" + name.replaceAll("\\.", "/") + ".java");
        if (srcFile.exists()) {
            try {
                CompilationUnit compilationUnit = JavaParser.parse((File)srcFile);
                Optional<TypeDeclaration> astTypeDeclaration = Navigator.findType(compilationUnit, this.simpleName(name));
                if (!astTypeDeclaration.isPresent()) {
                    return SymbolReference.unsolved(me.tomassetti.symbolsolver.model.declarations.TypeDeclaration.class);
                }
                me.tomassetti.symbolsolver.model.declarations.TypeDeclaration typeDeclaration = JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration.get());
                return SymbolReference.solved((Declaration)typeDeclaration);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return SymbolReference.unsolved(me.tomassetti.symbolsolver.model.declarations.TypeDeclaration.class);
    }
}

