/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.resolution.typesolvers;

import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;

public class JreTypeSolver
implements TypeSolver {
    private TypeSolver parent;

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }

    public SymbolReference<TypeDeclaration> tryToSolveType(String name) {
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            try {
                Class<?> clazz = JreTypeSolver.class.getClassLoader().loadClass(name);
                if (clazz.isInterface()) {
                    return SymbolReference.solved((Declaration)new ReflectionInterfaceDeclaration(clazz, this.getRoot()));
                }
                return SymbolReference.solved((Declaration)new ReflectionClassDeclaration(clazz, this.getRoot()));
            }
            catch (ClassNotFoundException e) {
                return SymbolReference.unsolved(TypeDeclaration.class);
            }
        }
        return SymbolReference.unsolved(TypeDeclaration.class);
    }
}

