/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.core.type.EventType;
import com.zing.zalo.zalosdk.oauth.FeedData;
import com.zing.zalo.zalosdk.oauth.OauthStorage;
import com.zing.zalo.zalosdk.oauth.OpenAPIActivity;
import com.zing.zalo.zalosdk.oauth.ShareVia;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.WebDialog;
import com.zing.zalo.zalosdk.oauth.ZaloOpenAPICallback;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenAPIService {
    private OauthStorage d = null;
    private boolean e = true;
    protected WeakReference<ZaloPluginCallback> a;
    protected WeakReference<Context> b;
    protected FeedData c;
    public String _shareTo = "";
    public boolean _autoBack = false;
    private String f = "";
    private BroadcastReceiver g;
    private boolean h = false;
    private WeakReference<ZaloPluginCallback> i;
    private ShareVia j = ShareVia.AppThenWeb;
    private boolean k = false;
    private static OpenAPIService l;

    public OpenAPIService() {
        this.d = ZaloSDK.Instance.getOauthStorage();
    }

    @Deprecated
    public static OpenAPIService getInstance() {
        if (l == null) {
            l = new OpenAPIService();
        }
        return l;
    }

    private String a(String[] fields) {
        if (fields != null && fields.length > 0) {
            StringBuffer param = new StringBuffer();
            for (int i = 0; i < fields.length - 1; ++i) {
                param.append(fields[i]).append(",");
            }
            param.append(fields[fields.length - 1]);
            return param.toString();
        }
        return "";
    }

    public void getProfile(Context ctx, String access_token, ZaloOpenAPICallback callback, String[] fields) {
        this.a(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me"));
        request.addParams("fields", this.a(fields));
        request.addHeader("access_token", access_token);
        new RequestAPITask(ctx, callback, EventType.GET_PROFILE).execute(new HttpClientRequest[]{request});
    }

    public void getFriendListUsedApp(Context ctx, String access_token, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        this.a(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/friends"));
        request.addParams("fields", this.a(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        request.addHeader("access_token", access_token);
        new RequestAPITask(ctx, callback, EventType.GET_FRIEND).execute(new HttpClientRequest[]{request});
    }

    public void getFriendListInvitable(Context ctx, String access_token, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        this.a(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/invitable_friends"));
        request.addParams("fields", this.a(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        request.addHeader("access_token", access_token);
        new RequestAPITask(ctx, callback, EventType.GET_INVITABLE_FRIEND).execute(new HttpClientRequest[]{request});
    }

    public void setShareZaloUsing(ShareVia _shareVia) {
        this.j = _shareVia;
    }

    public void setShareZaloChatOnly(boolean chatOnly) {
        this.k = chatOnly;
    }

    public ShareVia getShareZaloUsing() {
        return this.j;
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.c(context, feedOb, callback, "feed", false);
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.c(context, feedOb, callback, "message", false);
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.c(context, feedOb, callback, null, false);
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        this.c(context, feedOb, callback, "feed", autoBack);
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        this.c(context, feedOb, callback, "message", autoBack);
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        this.c(context, feedOb, callback, null, autoBack);
    }

    private void a(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final boolean autoBack) {
        CharSequence[] colors = new CharSequence[]{"G\u1eedi tin nh\u1eafn Zalo", "\u0110\u0103ng l\u00ean Zalo"};
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)"Ch\u1ecdn");
        builder.setItems(colors, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == 0) {
                    OpenAPIService.this.a(context, feedOb, callback, "message", autoBack);
                } else {
                    OpenAPIService.this.a(context, feedOb, callback, "feed", autoBack);
                }
            }
        });
        builder.show();
    }

    private void b(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final String shareTo, final boolean autoBack) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("msg=").append(URLEncoder.encode(feedOb.getMsg(), "UTF-8")).append("&");
            sb.append("link=").append(URLEncoder.encode(feedOb.getLink(), "UTF-8")).append("&");
            sb.append("app_name=").append(URLEncoder.encode(feedOb.getAppName(), "UTF-8")).append("&");
            sb.append("app_id=").append(String.valueOf(ZaloSDK.Instance.getAppID())).append("&");
            if (!TextUtils.isEmpty((CharSequence)shareTo)) {
                sb.append("share_to=").append(shareTo).append("&");
            }
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String version = pInfo.versionName;
            sb.append("app_version=").append(version).append("&");
            sb.append("sdk_version=").append(String.valueOf(ZaloSDK.Instance.getVersion())).append("&");
            sb.append("device_id=").append(ZaloSDK.Instance.getDeviceId()).append("&");
            StringBuffer extraBody = new StringBuffer();
            extraBody.append("link_title=").append(URLEncoder.encode(feedOb.getLinkTitle(), "UTF-8")).append("&");
            extraBody.append("link_desc=").append(URLEncoder.encode(feedOb.getLinkDesc(), "UTF-8")).append("&");
            extraBody.append("link_source=").append(URLEncoder.encode(feedOb.getLinkSource(), "UTF-8")).append("&");
            if (feedOb.getLinkThumb() != null) {
                int length = feedOb.getLinkThumb().length;
                for (int i = 0; i < length; ++i) {
                    extraBody.append("link_thumb=").append(URLEncoder.encode(feedOb.getLinkThumb()[i], "UTF-8")).append("&");
                }
            }
            if (feedOb.getParams() != null) {
                for (Map.Entry<String, String> entry : feedOb.getParams().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    sb.append(key + "=").append(URLEncoder.encode(value, "UTF-8")).append("&");
                }
            }
            Bundle bundle = new Bundle();
            bundle.putString("querystring", sb.toString());
            bundle.putString("bodyrequest", extraBody.toString());
            final WebDialog feedDialog = new WebDialog.FeedDialogBuilder(context, bundle).build();
            feedDialog.setFeedCallBackListener(new ZaloPluginCallback(){

                public void onResult(boolean arg0, int errorCode, String arg2, String arg3) {
                    feedDialog.dismiss();
                    if (errorCode == -10) {
                        OpenAPIService.this.e = true;
                        OpenAPIService.this.a(context, feedOb, callback, shareTo, autoBack);
                    } else if (errorCode == -1) {
                        OpenAPIService.this.e(context, feedOb, callback, shareTo, autoBack);
                    } else {
                        OpenAPIService.this.e = false;
                        if (callback != null) {
                            callback.onResult(arg0, errorCode, arg2, arg3);
                        }
                    }
                }
            });
            feedDialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void c(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        this.a(context, feedOb, callback, shareTo, autoBack);
    }

    protected void a(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        this.c = feedOb;
        this._shareTo = shareTo;
        this._autoBack = autoBack;
        if (this.e) {
            this.d(context, feedOb, callback, shareTo, autoBack);
            return;
        }
        if (this.j == ShareVia.AppThenWeb) {
            if (Utilities.isZaloInstalled((Context)context)) {
                this.d(context, feedOb, callback, shareTo, autoBack);
            } else {
                this.b(context, feedOb, callback, shareTo, autoBack);
            }
        } else {
            this.b(context, feedOb, callback, shareTo, autoBack);
        }
    }

    private void d(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        if (TextUtils.isEmpty((CharSequence)shareTo)) {
            this.a(context, feedOb, callback, autoBack);
        } else {
            boolean ableCalled;
            Intent intent = this.a(context, feedOb, shareTo, autoBack);
            boolean bl = ableCalled = intent.resolveActivityInfo(context.getPackageManager(), 0) != null;
            if (ableCalled) {
                this.b(context);
                this.i = new WeakReference<ZaloPluginCallback>(callback);
                context.startActivity(intent);
            } else {
                Utilities.invokeMarketApp((Context)context, (String)"com.zing.zalo");
            }
        }
    }

    private Intent a(Context context) {
        return new Intent(context, OpenAPIActivity.class);
    }

    private Intent a(Context context, String shareTo, boolean _autoBack) {
        Intent intent = this.a(context);
        intent.addFlags(0x10000000);
        intent.putExtra("login_from_share_feed", true);
        intent.putExtra("share_to", shareTo);
        intent.putExtra("autoBack", _autoBack);
        return intent;
    }

    private void e(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean _autoBack) {
        this.c = feedOb;
        this.a = new WeakReference<ZaloPluginCallback>(callback);
        this.b = new WeakReference<Context>(context);
        Intent intent = this.a(context, shareTo, _autoBack);
        context.startActivity(intent);
    }

    private Intent a(Context context, FeedData feedOb, String shareTo, boolean autoBack) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        intent.putExtra("android.intent.extra.SUBJECT", feedOb.getMsg());
        intent.putExtra("android.intent.extra.TEXT", feedOb.getLink());
        this.f = String.valueOf(System.currentTimeMillis());
        intent.putExtra("token", this.f);
        if (!TextUtils.isEmpty((CharSequence)shareTo)) {
            if (shareTo.equals("feed")) {
                intent.putExtra("postFeed", true);
            } else if (shareTo.equals("message") && this.k) {
                intent.putExtra("hidePostFeed", true);
            }
        }
        if (autoBack) {
            intent.putExtra("autoBack2S", true);
        }
        intent.putExtra("backToSource", true);
        return intent;
    }

    private void b(Context mContext) {
        ZaloPluginCallback callback;
        if (Utilities.isZaloSupportCallBack((Context)mContext)) {
            if (!this.h) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("com.zing.zalo.shareFeedResultInfo");
                this.g = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        String json = intent.getExtras().getString("result");
                        JSONObject jOb = null;
                        try {
                            String token;
                            jOb = new JSONObject(json);
                            int errorCode = 0;
                            boolean isSucc = false;
                            if (jOb.has("token") && (token = jOb.getString("token")).equals(OpenAPIService.this.f)) {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("type", OpenAPIService.this._shareTo);
                                params.put("url", OpenAPIService.this.c.getLink());
                                params.put("message", OpenAPIService.this.c.getMsg());
                                params.put("appName", OpenAPIService.this.c.getAppName());
                                params.put("sent", String.valueOf(jOb.getInt("send_action")));
                                errorCode = jOb.getInt("error_code");
                                params.put("error_code", String.valueOf(errorCode));
                                Utils.addEventZingAnalytics((EventType)EventType.SHARE, params);
                                OpenAPIService.this.c(context);
                                if (OpenAPIService.this.i != null) {
                                    ZaloPluginCallback callback = (ZaloPluginCallback)OpenAPIService.this.i.get();
                                    if (errorCode == 0) {
                                        isSucc = true;
                                    }
                                    if (callback != null) {
                                        callback.onResult(isSucc, jOb.getInt("error_code"), null, null);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                mContext.registerReceiver(this.g, filter);
                this.h = true;
            }
        } else if (this.i != null && (callback = (ZaloPluginCallback)this.i.get()) != null) {
            callback.onResult(true, 0, null, null);
        }
    }

    private void c(Context mContext) {
        if (this.g != null) {
            mContext.unregisterReceiver(this.g);
            this.h = false;
        }
    }

    public void inviteFriendUseApp(Context ctx, String access_token, String[] friendId, String message, ZaloOpenAPICallback callback) {
        this.a(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/apprequests"));
        request.addParams("to", this.a(friendId));
        request.addParams("message", message);
        request.addHeader("access_token", access_token);
        new RequestAPITask(ctx, callback, EventType.SEND_APP_REQUEST).execute(new HttpClientRequest[]{request});
    }

    public void postToWall(Context context, String access_token, String link, String msg, ZaloOpenAPICallback callback) {
        this.a(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/feed"));
        request.addParams("link", link);
        request.addParams("message", msg);
        request.addHeader("access_token", access_token);
        new RequestAPITask(context, callback, EventType.POST_FEED).execute(new HttpClientRequest[]{request});
    }

    public void sendMsgToFriend(Context context, String access_token, String friendId, String msg, String link, ZaloOpenAPICallback callback) {
        this.a(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/message"));
        request.addParams("to", friendId);
        request.addParams("message", msg);
        request.addParams("link", link);
        request.addHeader("access_token", access_token);
        new RequestAPITask(context, callback, EventType.SEND_MSG).execute(new HttpClientRequest[]{request});
    }

    public void broadcastViaOfficalAccount(Context context, String access_token, String templateid, String templatedata, ZaloOpenAPICallback callback) {
        this.a(access_token, "access_token must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/oa/message"));
        request.addParams("templateid", templateid);
        request.addParams("templatedata", templatedata);
        request.addHeader("access_token", access_token);
        new RequestAPITask(context, callback, EventType.SEND_OA_MSG).execute(new HttpClientRequest[]{request});
    }

    public void getAccessTokenByOAuthCode(Context context, String oauthCode, String codeVerifier, ZaloOpenAPICallback callback) {
        this.a(oauthCode, "oauthCode must be set.");
        this.a(codeVerifier, "codeVerifier must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v4/access_token"));
        request.addParams("code", oauthCode);
        request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
        request.addParams("grant_type", ZaloSDK.Instance.getGrantType(true));
        request.addParams("code_verifier", codeVerifier);
        new GetTokenTask(context, new WeakReference<ZaloOpenAPICallback>(callback)).execute(new HttpClientRequest[]{request});
    }

    public void getAccessTokenByRefreshToken(Context context, String refresh_token, ZaloOpenAPICallback callback) {
        this.a(refresh_token, "refresh_token must be set.");
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v4/access_token"));
        request.addParams("refresh_token", refresh_token);
        request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
        request.addParams("grant_type", ZaloSDK.Instance.getGrantType(false));
        new GetTokenTask(context, new WeakReference<ZaloOpenAPICallback>(callback)).execute(new HttpClientRequest[]{request});
    }

    private void a(String value, String msg) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException(msg);
        }
    }

    private class RequestAPITask
    extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        ZaloOpenAPICallback a;
        EventType b;

        RequestAPITask(Context ctx, ZaloOpenAPICallback _mOpenAPICallbackNewAPI, EventType eventType) {
            this.a = _mOpenAPICallbackNewAPI;
            this.b = eventType;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected JSONObject a(HttpClientRequest ... requests) {
            HttpClientRequest request = requests[0];
            return request.getJSON();
        }

        protected void a(JSONObject object) {
            int result = 1;
            try {
                if (object == null) {
                    result = 0;
                    object = new JSONObject("{\"error\":-8000}");
                }
                this.a.onResult(object);
            }
            catch (Exception ex) {
                result = 0;
                this.a.onResult(new JSONObject());
            }
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("result", result + "");
                Utils.addEventZingAnalytics((EventType)this.b, params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((JSONObject)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((HttpClientRequest[])objectArray);
        }
    }

    private class GetTokenTask
    extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context a;
        WeakReference<ZaloOpenAPICallback> b;

        GetTokenTask(Context ctx, WeakReference<ZaloOpenAPICallback> _mOpenAPICallbackAsync) {
            this.a = ctx;
            this.b = _mOpenAPICallbackAsync;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected JSONObject a(HttpClientRequest ... requests) {
            HttpClientRequest request = requests[0];
            JSONObject accessToken = request.getJSON();
            if (accessToken == null) {
                try {
                    return new JSONObject("{\"error\":-7001}");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return accessToken;
        }

        protected void a(JSONObject object) {
            try {
                if (object != null) {
                    if (this.b != null && this.b.get() != null) {
                        ((ZaloOpenAPICallback)this.b.get()).onResult(object);
                    }
                } else if (this.b != null && this.b.get() != null) {
                    ((ZaloOpenAPICallback)this.b.get()).onResult(new JSONObject("{\"error\":-8000}"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((JSONObject)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((HttpClientRequest[])objectArray);
        }
    }
}

