/*
 * Decompiled with CFR 0.152.
 */
package moe.tlaster.twitter.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import moe.tlaster.twitter.parser.CashTagToken;
import moe.tlaster.twitter.parser.HashTagToken;
import moe.tlaster.twitter.parser.StringToken;
import moe.tlaster.twitter.parser.Token;
import moe.tlaster.twitter.parser.UrlToken;
import moe.tlaster.twitter.parser.UserNameToken;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\f\u001a\u00020\r26\u0010\u000e\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u00100\u000fj\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u0010`\u0014H\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\u0006\u0010\u0017\u001a\u00020\u0018J@\u0010\u0019\u001a\u00020\r26\u0010\u000e\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u00100\u000fj\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u0010`\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lmoe/tlaster/twitter/parser/TwitterParser;", "", "()V", "digits", "Lkotlin/ranges/CharRange;", "letters", "", "", "urlEscapeChars", "urlRegex", "Lkotlin/text/Regex;", "userNameCharList", "accept", "Lmoe/tlaster/twitter/parser/TwitterParser$State;", "contentBuilder", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lmoe/tlaster/twitter/parser/TwitterParser$Type;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lkotlin/collections/ArrayList;", "parse", "Lmoe/tlaster/twitter/parser/Token;", "value", "", "reject", "State", "Type", "twitter-parser"})
public final class TwitterParser {
    @NotNull
    private final List<Character> urlEscapeChars;
    @NotNull
    private final Regex urlRegex;
    @NotNull
    private final CharRange digits;
    @NotNull
    private final List<Character> letters;
    @NotNull
    private final List<Character> userNameCharList;

    public TwitterParser() {
        Object[] objectArray = new Character[]{Character.valueOf('!'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('%'), Character.valueOf('['), Character.valueOf(']')};
        this.urlEscapeChars = CollectionsKt.listOf((Object[])objectArray);
        this.urlRegex = new Regex("https?:\\/\\/(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_\\+.~#?&//=]*)");
        this.digits = new CharRange('0', '9');
        this.letters = CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z')));
        this.userNameCharList = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.letters, (Iterable)((Iterable)this.digits)), (Object)Character.valueOf('_'));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Token> parse(@NotNull String value) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)((Object)Type.Content), (Object)new StringBuilder())};
        ArrayList contentBuilder = CollectionsKt.arrayListOf((Object[])objectArray);
        State state = State.AccSpace;
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = c = value.charAt(i);
            if (UserNameToken.Companion.getTags$twitter_parser().contains(Character.valueOf(c2))) {
                State state2;
                if (state == State.AccSpace) {
                    contentBuilder.add(TuplesKt.to((Object)((Object)Type.UserName), (Object)new StringBuilder()));
                    state2 = State.InUserName;
                } else {
                    state2 = state != State.Content && state != State.InUrl ? this.accept(contentBuilder) : state;
                }
                state = state2;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if (HashTagToken.Companion.getTags$twitter_parser().contains(Character.valueOf(c2))) {
                State state3;
                if (state == State.AccSpace) {
                    contentBuilder.add(TuplesKt.to((Object)((Object)Type.HashTag), (Object)new StringBuilder()));
                    state3 = State.InHashTag;
                } else {
                    state3 = state != State.Content && state != State.InUrl ? this.accept(contentBuilder) : state;
                }
                state = state3;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if (CashTagToken.Companion.getTags$twitter_parser().contains(Character.valueOf(c2))) {
                State state4;
                if (state == State.AccSpace) {
                    contentBuilder.add(TuplesKt.to((Object)((Object)Type.CashTag), (Object)new StringBuilder()));
                    state4 = State.InCashTag;
                } else {
                    state4 = state != State.Content && state != State.InUrl ? this.accept(contentBuilder) : state;
                }
                state = state4;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if (c2 == 'h' ? true : c2 == 'H') {
                if (state == State.Content || state == State.AccSpace) {
                    state = State.MightUrlH;
                    contentBuilder.add(TuplesKt.to((Object)((Object)Type.Url), (Object)new StringBuilder()));
                }
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if (c2 == 't' ? true : c2 == 'T') {
                State state5;
                switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 1: {
                        state5 = State.MightUrlT1;
                        break;
                    }
                    case 2: {
                        state5 = State.MightUrlT2;
                        break;
                    }
                    default: {
                        state5 = state;
                    }
                }
                state = state5;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if (c2 == 'p' ? true : c2 == 'P') {
                state = WhenMappings.$EnumSwitchMapping$0[state.ordinal()] == 3 ? State.MightUrlP : state;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if (c2 == 's' ? true : c2 == 'S') {
                state = WhenMappings.$EnumSwitchMapping$0[state.ordinal()] == 4 ? State.MightUrlS : state;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if (c2 == ':') {
                State state6;
                switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 4: {
                        state6 = State.MightUrlDot;
                        break;
                    }
                    case 5: {
                        state6 = State.MightUrlDot;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        state6 = this.accept(contentBuilder);
                        break;
                    }
                    default: {
                        state6 = state;
                    }
                }
                state = state6;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if (c2 == '/') {
                State state7;
                switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 9: {
                        state7 = State.MightUrlSlash1;
                        break;
                    }
                    case 10: {
                        state7 = State.InUrl;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        state7 = this.accept(contentBuilder);
                        break;
                    }
                    default: {
                        state7 = state;
                    }
                }
                state = state7;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            if ((c2 == ' ' ? true : c2 == '\n') ? true : c2 == '\u3000') {
                State state8;
                switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 11: {
                        state8 = State.AccSpace;
                        break;
                    }
                    case 12: {
                        state8 = State.AccSpace;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 13: {
                        this.accept(contentBuilder);
                        state8 = State.AccSpace;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: 
                    case 10: {
                        state8 = this.reject(contentBuilder);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                state = state8;
                ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
                continue;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 6: {
                    if (this.userNameCharList.contains(Character.valueOf(c))) break;
                    state = UserNameToken.Companion.getTags$twitter_parser().contains(Character.valueOf(StringsKt.last((CharSequence)((CharSequence)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond())))) ? this.reject(contentBuilder) : this.accept(contentBuilder);
                    break;
                }
                case 8: {
                    if (Character.isLetterOrDigit(c)) break;
                    state = HashTagToken.Companion.getTags$twitter_parser().contains(Character.valueOf(StringsKt.last((CharSequence)((CharSequence)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond())))) ? this.reject(contentBuilder) : this.accept(contentBuilder);
                    break;
                }
                case 7: {
                    if (this.letters.contains(Character.valueOf(c))) break;
                    state = CashTagToken.Companion.getTags$twitter_parser().contains(Character.valueOf(StringsKt.last((CharSequence)((CharSequence)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond())))) ? this.reject(contentBuilder) : this.accept(contentBuilder);
                    break;
                }
                case 13: {
                    if (!this.urlEscapeChars.contains(Character.valueOf(c))) break;
                    state = this.accept(contentBuilder);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: {
                    state = this.reject(contentBuilder);
                    break;
                }
            }
            ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append(c);
        }
        Iterable $this$filter$iv = contentBuilder;
        boolean $i$f$filter = false;
        Iterable c = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it.getSecond()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Token token;
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$1[((Type)((Object)it.getFirst())).ordinal()]) {
                case 1: {
                    String string = ((StringBuilder)it.getSecond()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.second.toString()");
                    token = new StringToken(string);
                    break;
                }
                case 2: {
                    String string = ((StringBuilder)it.getSecond()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.second.toString()");
                    token = new HashTagToken(string);
                    break;
                }
                case 3: {
                    String string = ((StringBuilder)it.getSecond()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.second.toString()");
                    token = new CashTagToken(string);
                    break;
                }
                case 4: {
                    String second;
                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)it.getSecond()).toString(), (String)"it.second.toString()");
                    if (this.urlRegex.matches((CharSequence)second)) {
                        token = new UrlToken(second);
                        break;
                    }
                    token = new StringToken(second);
                    break;
                }
                case 5: {
                    String string = ((StringBuilder)it.getSecond()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.second.toString()");
                    token = new UserNameToken(string);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(token);
        }
        return (List)destination$iv$iv;
    }

    private final State reject(ArrayList<Pair<Type, StringBuilder>> contentBuilder) {
        Pair last = (Pair)CollectionsKt.removeLast((List)contentBuilder);
        ((StringBuilder)((Pair)CollectionsKt.last((List)contentBuilder)).getSecond()).append((CharSequence)last.getSecond());
        return State.Content;
    }

    private final State accept(ArrayList<Pair<Type, StringBuilder>> contentBuilder) {
        contentBuilder.add((Pair<Type, StringBuilder>)TuplesKt.to((Object)((Object)Type.Content), (Object)new StringBuilder()));
        return State.Content;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lmoe/tlaster/twitter/parser/TwitterParser$State;", "", "(Ljava/lang/String;I)V", "AccSpace", "Content", "InUserName", "InHashTag", "InCashTag", "MightUrlH", "MightUrlT1", "MightUrlT2", "MightUrlS", "MightUrlP", "MightUrlDot", "MightUrlSlash1", "InUrl", "twitter-parser"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State AccSpace = new State();
        public static final /* enum */ State Content = new State();
        public static final /* enum */ State InUserName = new State();
        public static final /* enum */ State InHashTag = new State();
        public static final /* enum */ State InCashTag = new State();
        public static final /* enum */ State MightUrlH = new State();
        public static final /* enum */ State MightUrlT1 = new State();
        public static final /* enum */ State MightUrlT2 = new State();
        public static final /* enum */ State MightUrlS = new State();
        public static final /* enum */ State MightUrlP = new State();
        public static final /* enum */ State MightUrlDot = new State();
        public static final /* enum */ State MightUrlSlash1 = new State();
        public static final /* enum */ State InUrl = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.AccSpace, State.Content, State.InUserName, State.InHashTag, State.InCashTag, State.MightUrlH, State.MightUrlT1, State.MightUrlT2, State.MightUrlS, State.MightUrlP, State.MightUrlDot, State.MightUrlSlash1, State.InUrl};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lmoe/tlaster/twitter/parser/TwitterParser$Type;", "", "(Ljava/lang/String;I)V", "Content", "UserName", "HashTag", "CashTag", "Url", "twitter-parser"})
    private static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Content = new Type();
        public static final /* enum */ Type UserName = new Type();
        public static final /* enum */ Type HashTag = new Type();
        public static final /* enum */ Type CashTag = new Type();
        public static final /* enum */ Type Url = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.Content, Type.UserName, Type.HashTag, Type.CashTag, Type.Url};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.MightUrlH.ordinal()] = 1;
            nArray[State.MightUrlT1.ordinal()] = 2;
            nArray[State.MightUrlT2.ordinal()] = 3;
            nArray[State.MightUrlP.ordinal()] = 4;
            nArray[State.MightUrlS.ordinal()] = 5;
            nArray[State.InUserName.ordinal()] = 6;
            nArray[State.InCashTag.ordinal()] = 7;
            nArray[State.InHashTag.ordinal()] = 8;
            nArray[State.MightUrlDot.ordinal()] = 9;
            nArray[State.MightUrlSlash1.ordinal()] = 10;
            nArray[State.Content.ordinal()] = 11;
            nArray[State.AccSpace.ordinal()] = 12;
            nArray[State.InUrl.ordinal()] = 13;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Type.values().length];
            nArray[Type.Content.ordinal()] = 1;
            nArray[Type.HashTag.ordinal()] = 2;
            nArray[Type.CashTag.ordinal()] = 3;
            nArray[Type.Url.ordinal()] = 4;
            nArray[Type.UserName.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

