/*
 * Decompiled with CFR 0.152.
 */
package mx.dapp.sdk.vendor.dto;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mx.dapp.sdk.core.callbacks.DappPosCodeCallback;
import mx.dapp.sdk.core.dto.AbstractDappPosCode;
import mx.dapp.sdk.core.enums.DappResult;
import mx.dapp.sdk.core.exceptions.DappException;
import mx.dapp.sdk.core.network.http.DappResponseProcess;
import mx.dapp.sdk.vendor.callbacks.DappCodePoSImageCallback;
import mx.dapp.sdk.vendor.callbacks.DappCodePosPushNotificationCallback;
import mx.dapp.sdk.vendor.callbacks.DappCodesWalletsCallback;
import mx.dapp.sdk.vendor.callbacks.DappPaymentCallback;
import mx.dapp.sdk.vendor.dto.DappWallet;
import mx.dapp.sdk.vendor.handler.PoSCodeHandler;
import mx.dapp.sdk.vendor.network.DappVendorApi;
import org.json.JSONArray;

public class DappPosCode
extends AbstractDappPosCode
implements DappPosCodeCallback {
    private int heigth;
    private int width;
    private DappCodePoSImageCallback dappCodePoSImageCallback;
    private PoSCodeHandler poSCodeHandler;
    private DappWallet wallet;

    public DappPosCode(Double amount, String description, @Nullable String reference, @Nullable DappWallet wallet) {
        super(amount, description, reference);
        this.wallet = wallet;
    }

    public DappPosCode(Double amount, String description, @Nullable String reference, @Nullable DappWallet wallet, int expirationMinutes) {
        super(amount, description, reference, expirationMinutes);
        this.wallet = wallet;
    }

    public void create() {
        this.create(this.getQrSource(), this);
    }

    public void createWithImage(int height, int width, DappCodePoSImageCallback callback) {
        this.heigth = height;
        this.width = width;
        this.dappCodePoSImageCallback = callback;
        this.create(this.getQrSource(), this);
    }

    public void onSuccess() {
        try {
            Bitmap bitmap = this.generateQRBitmap();
            this.dappCodePoSImageCallback.onSuccess(bitmap);
        }
        catch (WriterException e) {
            e.printStackTrace();
            DappException exception = new DappException(e.getMessage(), ((Object)((Object)e)).hashCode());
            this.dappCodePoSImageCallback.onError(exception);
        }
    }

    public void onError(DappException exception) {
        this.dappCodePoSImageCallback.onError(exception);
    }

    private Bitmap generateQRBitmap() throws WriterException {
        EnumMap<EncodeHintType, Object> hint = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hint.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
        hint.put(EncodeHintType.MARGIN, (Object)0);
        BitMatrix bitMatrix = new QRCodeWriter().encode(this.qrText, BarcodeFormat.QR_CODE, this.width, this.heigth, hint);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = bitMatrix.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    public void listen(DappPaymentCallback callback) {
        this.poSCodeHandler = new PoSCodeHandler(this.dappId, callback);
        this.poSCodeHandler.startRequest();
    }

    public void stopListening() {
        this.poSCodeHandler.stopRequest();
    }

    public void sendCodiPushNotification(String phoneNumber, final DappCodePosPushNotificationCallback callback) {
        if (this.dappId != null && this.isValidPhoneNumber(phoneNumber)) {
            DappVendorApi api = new DappVendorApi();
            api.sendPushNotification(this.dappId, phoneNumber, new DappResponseProcess(callback){

                public void processSuccess(Object data) {
                    callback.onSuccess();
                }
            });
        } else {
            callback.onError(new DappException(DappResult.RESULT_INVALID_DATA));
        }
    }

    public void sendPushNotification(String phoneNumber, final DappCodePosPushNotificationCallback callback) {
        if (this.wallet != null) {
            if (this.wallet.isPushNotification()) {
                if (this.wallet != null && this.wallet.isPushNotification() && this.dappId != null && this.isValidPhoneNumber(phoneNumber)) {
                    DappVendorApi api = new DappVendorApi();
                    api.dappCodePush(this.dappId, phoneNumber, this.wallet.id, new DappResponseProcess(callback){

                        public void processSuccess(Object data) {
                            callback.onSuccess();
                        }
                    });
                } else {
                    callback.onError(new DappException(DappResult.RESULT_INVALID_DATA));
                }
            } else {
                callback.onError(new DappException(DappResult.RESULT_INVALID_WALLET_PUSH));
            }
        } else {
            callback.onError(new DappException(DappResult.RESULT_INVALID_WALLET));
        }
    }

    private boolean isValidPhoneNumber(@NonNull String phoneNumber) {
        Pattern regex = Pattern.compile("^[0-9]{10}$");
        Matcher mat = regex.matcher(phoneNumber);
        return mat.matches();
    }

    public static void getWallets(final DappCodesWalletsCallback callback) {
        DappVendorApi api = new DappVendorApi();
        api.dappCodesWallets(new DappResponseProcess(callback){

            public void processSuccess(Object data) {
                JSONArray destinations = (JSONArray)data;
                ArrayList<DappWallet> result = new ArrayList<DappWallet>();
                for (int i = 0; i < destinations.length(); ++i) {
                    result.add(new DappWallet(destinations.optJSONObject(i)));
                }
                callback.onSuccess(result);
            }
        });
    }

    private int getQrSource() {
        return this.wallet != null ? this.wallet.getQrSource() : -1;
    }
}

