/*
 * Decompiled with CFR 0.152.
 */
package mx.dapp.sdk.vendor.handler;

import android.os.Handler;
import mx.dapp.sdk.core.callbacks.DappSocketStatusCallback;
import mx.dapp.sdk.core.exceptions.DappException;
import mx.dapp.sdk.core.handler.AbstractStatusHandler;
import mx.dapp.sdk.core.network.http.DappResponseProcess;
import mx.dapp.sdk.vendor.callbacks.DappPaymentCallback;
import mx.dapp.sdk.vendor.dto.DappPayment;
import mx.dapp.sdk.vendor.network.DappVendorApi;
import org.json.JSONObject;

public class PoSCodeHandler
extends AbstractStatusHandler {
    private DappPaymentCallback callback;

    public PoSCodeHandler(String code, DappPaymentCallback callback) {
        super(code);
        this.callback = callback;
    }

    public void startRequest() {
        this.isListening = true;
        DappVendorApi dappVendorApi = new DappVendorApi();
        dappVendorApi.paymentStatusBySocket(this.code, new DappSocketStatusCallback(){

            public void onMessage(JSONObject data) {
                DappPayment payment = new DappPayment(data);
                PoSCodeHandler.this.callback.onSuccess(payment);
            }

            public void onError(DappException exception) {
                if (PoSCodeHandler.this.isListening) {
                    PoSCodeHandler.this.getStatusByService();
                }
            }
        });
    }

    private void getStatusByService() {
        this.timerRunnable = new Runnable(){

            @Override
            public void run() {
                PoSCodeHandler.this.getStatusByService();
            }
        };
        DappVendorApi dappVendorApi = new DappVendorApi();
        dappVendorApi.paymentStatusByService(this.code, new DappResponseProcess(this.callback){

            public void processSuccess(Object data) {
                if (data == null) {
                    if (PoSCodeHandler.this.timerHandler == null) {
                        PoSCodeHandler.this.timerHandler = new Handler();
                    }
                    PoSCodeHandler.this.timerHandler.postDelayed(PoSCodeHandler.this.timerRunnable, 5000L);
                } else {
                    DappPayment payment = new DappPayment((JSONObject)data);
                    PoSCodeHandler.this.callback.onSuccess(payment);
                }
            }

            public void processFailed(Exception e) {
                if (PoSCodeHandler.this.scheduleErrorCount == 2) {
                    super.processFailed(e);
                    PoSCodeHandler.this.stopRequest();
                } else {
                    PoSCodeHandler.this.scheduleErrorCount = PoSCodeHandler.this.scheduleErrorCount + 1;
                }
            }
        });
    }

    static /* synthetic */ int access$800(PoSCodeHandler x0) {
        return x0.scheduleErrorCount;
    }
}

