/*
 * Decompiled with CFR 0.152.
 */
package mx.dapp.sdk.vendor.network;

import java.util.HashMap;
import mx.dapp.sdk.core.callbacks.DappSocketStatusCallback;
import mx.dapp.sdk.core.network.DappApi;
import mx.dapp.sdk.core.network.http.DappResponseProcess;
import mx.dapp.sdk.core.network.ws.DappWsClient;
import okhttp3.WebSocket;

public class DappVendorApi
extends DappApi {
    public void paymentCode(String qrCode, String amount, String description, String reference, DappResponseProcess responseHandler) {
        HashMap<String, String> postValues = new HashMap<String, String>();
        postValues.put("amount", amount);
        postValues.put("description", description);
        postValues.put("reference", reference);
        this.execute(postValues, "/payments/code/" + qrCode, responseHandler);
    }

    public void dappCode(String amount, String description, String reference, DappResponseProcess responseHandler) {
        HashMap<String, String> postValues = new HashMap<String, String>();
        postValues.put("amount", amount);
        postValues.put("description", description);
        postValues.put("reference", reference);
        this.execute(postValues, "/dapp-codes/", responseHandler);
    }

    public void paymentStatusByService(String code, DappResponseProcess responseHandler) {
        this.execute("/dapp-codes/" + code + "/payment/", responseHandler);
    }

    public void sendPushNotification(String code, String phoneNumber, DappResponseProcess responseHandler) {
        HashMap<String, String> postValues = new HashMap<String, String>();
        postValues.put("phone", phoneNumber);
        this.execute(postValues, "/dapp-codes/" + code + "/codi/push/", responseHandler);
    }

    public void dappCodePush(String code, String phoneNumber, String destinationId, DappResponseProcess responseHandler) {
        HashMap<String, String> postValues = new HashMap<String, String>();
        postValues.put("phone", phoneNumber);
        postValues.put("destination", destinationId);
        this.execute(postValues, "/dapp-codes/" + code + "/push/", responseHandler);
    }

    public void dappCodePushDestinations(DappResponseProcess responseHandler) {
        this.execute("/dapp-codes/push/destinations/", responseHandler);
    }

    public WebSocket paymentStatusBySocket(String code, DappSocketStatusCallback callback) {
        DappWsClient dappWsClient = new DappWsClient(this.getSocketUrl() + "dapp-code/" + code + "/", this.getHeader(), callback);
        return dappWsClient.createSocket();
    }

    public void dappCodesWallets(DappResponseProcess responseHandler) {
        this.execute("/dapp-codes/wallets", responseHandler);
    }

    public void getPayments(String fecha_inicio, String fecha_fin, DappResponseProcess responseHandler) {
        this.execute("/payments?start_date=" + fecha_inicio + "&end_date=" + fecha_fin, responseHandler);
    }
}

