/*
 * Decompiled with CFR 0.152.
 */
package mx.dapp.sdk.vendor.scanner;

import android.os.Bundle;
import android.os.Parcelable;
import mx.dapp.sdk.core.callbacks.DappCallback;
import mx.dapp.sdk.core.network.http.DappResponseProcess;
import mx.dapp.sdk.core.scanner.DappScannerActivity;
import mx.dapp.sdk.vendor.dto.DappPayment;
import mx.dapp.sdk.vendor.network.DappVendorApi;
import org.json.JSONObject;

public class DappVendorScannerActivity
extends DappScannerActivity {
    public static final String AMOUNT = "amount";
    public static final String DESCRIPTION = "description";
    public static final String REFERENCE = "reference";
    public static final int RESULT_INVALID_AMOUNT = -10;
    public static final String PAYMENT = "payment";
    private Double amount;
    private String description;
    private String reference;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            this.amount = extras.getDouble(AMOUNT, 0.0);
            this.description = extras.getString(DESCRIPTION, "");
            this.reference = extras.getString(REFERENCE, "");
        }
        if (this.amount == null || this.amount == 0.0) {
            this.setResult(-10);
            this.finish();
        }
    }

    public void onScan(String result) {
        DappVendorApi api = new DappVendorApi();
        api.paymentCode(result, this.amount.toString(), this.description, this.reference, new DappResponseProcess((DappCallback)this){

            public void processSuccess(Object data) {
                DappPayment payment = new DappPayment((JSONObject)data);
                DappVendorScannerActivity.this.getIntent().putExtra(DappVendorScannerActivity.PAYMENT, (Parcelable)payment);
                DappVendorScannerActivity.this.setResult(-1, DappVendorScannerActivity.this.getIntent());
                DappVendorScannerActivity.this.finish();
            }
        });
    }
}

