/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.Statement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class PreparedStatement
extends Statement {
    protected static SimpleDateFormat _TSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String _Sql = null;
    private byte[][] _TemplateStrings = null;
    protected String[] _ParameterStrings = null;
    protected InputStream[] _ParameterStreams = null;
    protected boolean[] _IsStream = null;
    protected boolean[] _IsNull = null;
    private boolean _has_limit_clause = false;
    private byte[] _bi = new byte[4096];
    private Buffer _SendPacket = null;
    private boolean _useTrueBoolean = this._conn.getIO().versionMeetsMinimum(3, 21, 23);
    private static Hashtable templateCache = new Hashtable();
    private char _firstChar;
    private static NumberFormat _DoubleFormatter = NumberFormat.getNumberInstance(Locale.US);

    public PreparedStatement(Connection connection, String string, String string2) throws SQLException {
        super(connection, string2);
        this._firstChar = Character.toUpperCase(string.charAt(0));
        this._has_limit_clause = string.toUpperCase().indexOf("LIMIT") != -1;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (cArray[n3] == '?') {
                ++n2;
            }
            ++n3;
        }
        Vector<EndPoint> vector = new Vector<EndPoint>(n2 + 1);
        boolean bl = false;
        int n4 = 0;
        this._Sql = string;
        this._conn = connection;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            int n8 = cArray[n7];
            if (n8 == 39 && n5 == 92 && n6 == 92) {
                bl = !bl;
            } else if (n8 == 39 && n5 != 92) {
                boolean bl2 = bl = !bl;
            }
            if (n8 == 63 && !bl) {
                vector.addElement(new EndPoint(n4, n7));
                n4 = n7 + 1;
            }
            n6 = n5;
            n5 = n8;
            ++n7;
        }
        vector.addElement(new EndPoint(n4, n));
        this._TemplateStrings = new byte[vector.size()][];
        String string3 = null;
        if (this._conn.useUnicode()) {
            string3 = this._conn.getEncoding();
        }
        n7 = 0;
        while (n7 < this._TemplateStrings.length) {
            Object object;
            int n9;
            int n10;
            int n11;
            EndPoint endPoint;
            if (string3 == null) {
                endPoint = (EndPoint)vector.elementAt(n7);
                n11 = endPoint.end;
                n10 = endPoint.begin;
                n9 = n11 - n10;
                object = new byte[n9];
                int n12 = 0;
                while (n12 < n9) {
                    object[n12] = (byte)cArray[n10 + n12];
                    ++n12;
                }
                this._TemplateStrings[n7] = object;
            } else {
                try {
                    endPoint = (EndPoint)vector.elementAt(n7);
                    n11 = endPoint.end;
                    n10 = endPoint.begin;
                    n9 = n11 - n10;
                    object = new String(cArray, n10, n9);
                    this._TemplateStrings[n7] = ((String)object).getBytes(string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.toString());
                }
            }
            ++n7;
        }
        this._ParameterStrings = new String[this._TemplateStrings.length - 1];
        this._ParameterStreams = new InputStream[this._TemplateStrings.length - 1];
        this._IsStream = new boolean[this._TemplateStrings.length - 1];
        this._IsNull = new boolean[this._TemplateStrings.length - 1];
        this.clearParameters();
        int n13 = 0;
        while (n13 < this._ParameterStrings.length) {
            this._IsStream[n13] = false;
            ++n13;
        }
    }

    public java.sql.ResultSet executeQuery() throws SQLException {
        if (this._SendPacket == null) {
            this._SendPacket = new Buffer(this._conn.getNetBufferLength(), this._conn.getMaxAllowedPacket());
        } else {
            this._SendPacket.clear();
        }
        this._SendPacket.writeByte((byte)3);
        String string = null;
        if (this._conn.useUnicode()) {
            string = this._conn.getEncoding();
        }
        try {
            int n = 0;
            while (n < this._ParameterStrings.length) {
                if (this._ParameterStrings[n] == null && this._ParameterStreams[n] == null) {
                    throw new SQLException("No value specified for parameter " + (n + 1), "07001");
                }
                this._SendPacket.writeBytesNoNull(this._TemplateStrings[n]);
                if (this._IsStream[n]) {
                    this._SendPacket.writeBytesNoNull(this.streamToBytes(this._ParameterStreams[n]));
                } else if (string != null) {
                    this._SendPacket.writeStringNoNull(this._ParameterStrings[n], string);
                } else {
                    this._SendPacket.writeStringNoNull(this._ParameterStrings[n]);
                }
                ++n;
            }
            this._SendPacket.writeBytesNoNull(this._TemplateStrings[this._ParameterStrings.length]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + string + "'");
        }
        if (this._results != null) {
            this._results.close();
        }
        Object object = this._conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._conn.getCatalog().equals(this._catalog)) {
                string2 = this._conn.getCatalog();
                this._conn.setCatalog(this._catalog);
            }
            if (this._conn.useMaxRows()) {
                if (this._has_limit_clause) {
                    this._results = this._conn.execSQL(null, this._maxRows, this._SendPacket);
                } else {
                    if (this._maxRows <= 0) {
                        this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                    } else {
                        this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._maxRows, -1);
                    }
                    this._results = this._conn.execSQL(null, -1, this._SendPacket);
                    if (string2 != null) {
                        this._conn.setCatalog(string2);
                    }
                }
            } else {
                this._results = this._conn.execSQL(null, -1, this._SendPacket);
            }
            if (string2 != null) {
                this._conn.setCatalog(string2);
            }
        }
        this._lastInsertId = this._results.getUpdateID();
        this._nextResults = this._results;
        this._results.setConnection(this._conn);
        this._results.setResultSetType(this._resultSetType);
        this._results.setResultSetConcurrency(this._resultSetConcurrency);
        this._results.setStatement(this);
        return (java.sql.ResultSet)((Object)this._results);
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this._ParameterStrings, this._ParameterStreams, this._IsStream, this._IsNull);
    }

    protected int executeUpdate(String[] stringArray, InputStream[] inputStreamArray, boolean[] blArray, boolean[] blArray2) throws SQLException {
        if (this._SendPacket == null) {
            this._SendPacket = new Buffer(this._conn.getNetBufferLength(), this._conn.getMaxAllowedPacket());
        } else {
            this._SendPacket.clear();
        }
        this._SendPacket.writeByte((byte)3);
        String string = null;
        if (this._conn.useUnicode()) {
            string = this._conn.getEncoding();
        }
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] == null && inputStreamArray[n] == null) {
                    throw new SQLException("No value specified for parameter " + (n + 1), "07001");
                }
                this._SendPacket.writeBytesNoNull(this._TemplateStrings[n]);
                if (blArray[n]) {
                    this._SendPacket.writeBytesNoNull(this.streamToBytes(inputStreamArray[n]));
                } else if (string != null) {
                    this._SendPacket.writeStringNoNull(stringArray[n], string);
                } else {
                    this._SendPacket.writeStringNoNull(stringArray[n]);
                }
                ++n;
            }
            this._SendPacket.writeBytesNoNull(this._TemplateStrings[stringArray.length]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + string + "'");
        }
        ResultSet resultSet = null;
        Object object = this._conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._conn.getCatalog().equals(this._catalog)) {
                string2 = this._conn.getCatalog();
                this._conn.setCatalog(this._catalog);
            }
            if (this._conn.useMaxRows()) {
                this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
            }
            resultSet = this._conn.execSQL(null, -1, this._SendPacket);
            if (string2 != null) {
                this._conn.setCatalog(string2);
            }
        }
        if (resultSet.reallyResult()) {
            throw new SQLException("Results returned for UPDATE ONLY.", "01S03");
        }
        this._updateCount = resultSet.getUpdateCount();
        int n = 0;
        n = this._updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._updateCount;
        this._lastInsertId = resultSet.getUpdateID();
        return n;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.set(n, "null");
        this._IsNull[n - 1] = true;
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this._useTrueBoolean) {
            this.set(n, bl ? "'1'" : "'0'");
        } else {
            this.set(n, bl ? "'t'" : "'f'");
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        this.set(n, String.valueOf(by));
    }

    public void setShort(int n, short s) throws SQLException {
        this.set(n, String.valueOf(s));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.set(n, String.valueOf(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.set(n, String.valueOf(l));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.set(n, PreparedStatement.fixDecimalExponent(String.valueOf(f)));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.set(n, PreparedStatement.fixDecimalExponent(String.valueOf(d)));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(n, 3);
        } else {
            this.set(n, PreparedStatement.fixDecimalExponent(bigDecimal.toString()));
        }
    }

    protected static final String fixDecimalExponent(String string) {
        char c;
        int n = string.indexOf("E");
        if (n == -1) {
            n = string.indexOf("e");
        }
        if (n != -1 && string.length() > n + 1 && (c = string.charAt(n + 1)) != '-') {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
            stringBuffer.append(string.substring(0, n + 1));
            stringBuffer.append('+');
            stringBuffer.append(string.substring(n + 1, string.length()));
            string = stringBuffer.toString();
        }
        return string;
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.set(n, "null");
        } else {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            stringBuffer.append('\'');
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (c == '\\' || c == '\'' || c == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                ++n2;
            }
            stringBuffer.append('\'');
            this.set(n, stringBuffer.toString());
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -2);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.setBinaryStream(n, byteArrayInputStream, byArray.length);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("''yyyy-MM-dd''");
            this.set(n, simpleDateFormat.format(date));
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
        } else {
            this.set(n, "'" + time.toString() + "'");
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
        } else {
            String string = null;
            SimpleDateFormat simpleDateFormat = _TSDF;
            synchronized (simpleDateFormat) {
                string = "'" + _TSDF.format(timestamp) + "'";
            }
            this.set(n, string);
        }
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 12);
        } else {
            this.setBinaryStream(n, inputStream, n2);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 12);
        } else {
            this.setBinaryStream(n, inputStream, n2);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -2);
        } else {
            if (n < 1 || n > this._TemplateStrings.length) {
                throw new SQLException("Parameter index out of range (" + n + " > " + this._TemplateStrings.length + ")", "S1009");
            }
            this._ParameterStreams[n - 1] = inputStream;
            this._IsStream[n - 1] = true;
            this._IsNull[n - 1] = false;
        }
    }

    public void clearParameters() throws SQLException {
        int n = 0;
        while (n < this._ParameterStrings.length) {
            this._ParameterStrings[n] = null;
            this._ParameterStreams[n] = null;
            this._IsStream[n] = false;
            this._IsNull[n] = false;
            ++n;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNull(n, 1111);
        } else {
            try {
                block2 : switch (n2) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        Number number;
                        if (object instanceof Boolean) {
                            number = (Boolean)object != false ? new Integer(1) : new Integer(0);
                        } else if (object instanceof String) {
                            switch (n2) {
                                case -7: {
                                    number = Boolean.getBoolean((String)object) ? new Integer("1") : new Integer("0");
                                    break;
                                }
                                case -6: 
                                case 4: 
                                case 5: {
                                    number = Integer.valueOf((String)object);
                                    break;
                                }
                                case -5: {
                                    number = Long.valueOf((String)object);
                                    break;
                                }
                                case 7: {
                                    number = Float.valueOf((String)object);
                                    break;
                                }
                                case 6: 
                                case 8: {
                                    number = Double.valueOf((String)object);
                                    break;
                                }
                                default: {
                                    number = new BigDecimal((String)object);
                                    break;
                                }
                            }
                        } else {
                            number = (Number)object;
                        }
                        switch (n2) {
                            case -7: 
                            case -6: 
                            case 4: 
                            case 5: {
                                this.setInt(n, number.intValue());
                                break block2;
                            }
                            case -5: {
                                this.setLong(n, number.longValue());
                                break block2;
                            }
                            case 7: {
                                this.setFloat(n, number.floatValue());
                                break block2;
                            }
                            case 6: 
                            case 8: {
                                this.setDouble(n, number.doubleValue());
                                break block2;
                            }
                        }
                        if (number instanceof BigDecimal) {
                            this.setBigDecimal(n, (BigDecimal)number);
                            break;
                        }
                        if (number instanceof BigInteger) {
                            this.setBigDecimal(n, new BigDecimal((BigInteger)number, n3));
                            break;
                        }
                        this.setBigDecimal(n, new BigDecimal(number.doubleValue()));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(n, object.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (object instanceof String) {
                            this.setBytes(n, ((String)object).getBytes());
                            break;
                        }
                        this.setBytes(n, (byte[])object);
                        break;
                    }
                    case 91: 
                    case 93: {
                        java.util.Date date;
                        if (object instanceof String) {
                            ParsePosition parsePosition = new ParsePosition(0);
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getDateTimePattern((String)object, false));
                            date = ((DateFormat)simpleDateFormat).parse((String)object, parsePosition);
                        } else {
                            date = (java.util.Date)object;
                        }
                        switch (n2) {
                            case 91: {
                                if (date instanceof Date) {
                                    this.setDate(n, (Date)date);
                                    break block2;
                                }
                                this.setDate(n, new Date(date.getTime()));
                                break block2;
                            }
                            case 93: {
                                if (date instanceof Timestamp) {
                                    this.setTimestamp(n, (Timestamp)date);
                                    break block2;
                                }
                                this.setTimestamp(n, new Timestamp(date.getTime()));
                            }
                        }
                        break;
                    }
                    case 92: {
                        if (object instanceof String) {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getDateTimePattern((String)object, true));
                            this.setTime(n, new Time(simpleDateFormat.parse((String)object).getTime()));
                            break;
                        }
                        this.setTime(n, (Time)object);
                        break;
                    }
                    case 1111: {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                            objectOutputStream.writeObject(object);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            byteArrayOutputStream.flush();
                            byteArrayOutputStream.close();
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                            this.setBinaryStream(n, byteArrayInputStream, -1);
                            break;
                        }
                        catch (Exception exception) {
                            throw new SQLException("Invalid argument value: " + exception.getClass().getName(), "S1009");
                        }
                    }
                    default: {
                        throw new SQLException("Unknown Types value", "S1000");
                    }
                }
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                throw new SQLException("Cannot convert " + object.getClass().toString() + " to SQL type requested", "S1000");
            }
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.setNull(n, 1111);
        } else if (object instanceof Byte) {
            this.setInt(n, ((Byte)object).intValue());
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof InputStream) {
            this.setBinaryStream(n, (InputStream)object, -1);
        } else {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                objectOutputStream.close();
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.setBinaryStream(n, byteArrayInputStream, -1);
            }
            catch (Exception exception) {
                throw new SQLException("Invalid argument value: " + exception.getClass().getName(), "S1009");
            }
        }
    }

    public boolean execute() throws SQLException {
        if (this._SendPacket == null) {
            this._SendPacket = new Buffer(this._conn.getNetBufferLength(), this._conn.getMaxAllowedPacket());
        } else {
            this._SendPacket.clear();
        }
        this._SendPacket.writeByte((byte)3);
        String string = null;
        if (this._conn.useUnicode()) {
            string = this._conn.getEncoding();
        }
        try {
            int n = 0;
            while (n < this._ParameterStrings.length) {
                if (this._ParameterStrings[n] == null && this._ParameterStreams[n] == null) {
                    throw new SQLException("No value specified for parameter " + (n + 1));
                }
                this._SendPacket.writeBytesNoNull(this._TemplateStrings[n]);
                if (this._IsStream[n]) {
                    this._SendPacket.writeBytesNoNull(this.streamToBytes(this._ParameterStreams[n]));
                } else if (string != null) {
                    this._SendPacket.writeStringNoNull(this._ParameterStrings[n], string);
                } else {
                    this._SendPacket.writeStringNoNull(this._ParameterStrings[n]);
                }
                ++n;
            }
            this._SendPacket.writeBytesNoNull(this._TemplateStrings[this._ParameterStrings.length]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + string + "'");
        }
        ResultSet resultSet = null;
        Object object = this._conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._conn.getCatalog().equals(this._catalog)) {
                string2 = this._conn.getCatalog();
                this._conn.setCatalog(this._catalog);
            }
            if (this._conn.useMaxRows()) {
                if (this._firstChar == 'S') {
                    if (this._has_limit_clause) {
                        resultSet = this._conn.execSQL(null, this._maxRows, this._SendPacket);
                    } else if (this._maxRows <= 0) {
                        this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                    } else {
                        this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._maxRows, -1);
                    }
                } else {
                    this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                }
                resultSet = this._conn.execSQL(null, -1, this._SendPacket);
            } else {
                resultSet = this._conn.execSQL(null, -1, this._SendPacket);
            }
            if (string2 != null) {
                this._conn.setCatalog(string2);
            }
        }
        this._lastInsertId = resultSet.getUpdateID();
        if (resultSet != null) {
            this._results = resultSet;
        }
        resultSet.setConnection(this._conn);
        resultSet.setResultSetType(this._resultSetType);
        resultSet.setResultSetConcurrency(this._resultSetConcurrency);
        resultSet.setStatement(this);
        return resultSet != null && resultSet.reallyResult();
    }

    public void close() throws SQLException {
        super.close();
        this._Sql = null;
        this._TemplateStrings = null;
        this._ParameterStrings = null;
        this._ParameterStreams = null;
        this._IsStream = null;
        this._IsNull = null;
        this._bi = null;
        this._SendPacket = null;
        templateCache = null;
    }

    public String toString() {
        String string = null;
        if (this._conn != null && this._conn.useUnicode()) {
            string = this._conn.getEncoding();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(": ");
        try {
            int n = 0;
            while (n < this._ParameterStrings.length) {
                if (string != null) {
                    stringBuffer.append(new String(this._TemplateStrings[n], string));
                } else {
                    stringBuffer.append(new String(this._TemplateStrings[n]));
                }
                if (this._ParameterStrings[n] == null && !this._IsStream[n]) {
                    stringBuffer.append("** NOT SPECIFIED **");
                } else if (this._IsStream[n]) {
                    stringBuffer.append("** STREAM DATA **");
                } else {
                    if (this._escapeProcessing) {
                        try {
                            this._ParameterStrings[n] = this._escaper.escapeSQL(this._ParameterStrings[n]);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (string != null) {
                        stringBuffer.append(new String(this._ParameterStrings[n].getBytes(), string));
                    } else {
                        stringBuffer.append(new String(this._ParameterStrings[n].getBytes()));
                    }
                }
                ++n;
            }
            if (string != null) {
                stringBuffer.append(new String(this._TemplateStrings[this._ParameterStrings.length], string));
            } else {
                stringBuffer.append(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            stringBuffer.append("\n\n** WARNING **\n\n Unsupported character encoding '");
            stringBuffer.append(string);
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    private final void set(int n, String string) throws SQLException {
        if (n < 1 || n > this._TemplateStrings.length) {
            throw new SQLException("Parameter index out of range (" + n + " > " + this._TemplateStrings.length + ").", "S1009");
        }
        this._IsStream[n - 1] = false;
        this._IsNull[n - 1] = false;
        this._ParameterStreams[n - 1] = null;
        this._ParameterStrings[n - 1] = string;
    }

    private final int readblock(InputStream inputStream, byte[] byArray) throws SQLException {
        try {
            return inputStream.read(byArray);
        }
        catch (Throwable throwable) {
            throw new SQLException("Error reading from InputStream " + throwable.getClass().getName(), "S1000");
        }
    }

    private final void escapeblock(byte[] byArray, ByteArrayOutputStream byteArrayOutputStream, int n) {
        byte[] byArray2 = new byte[byArray.length * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byte by = byArray[n3];
            if (by == 0) {
                byArray2[n2++] = 92;
                byArray2[n2++] = 48;
            } else {
                if (by == 92 || by == 39 || by == 34) {
                    byArray2[n2++] = 92;
                }
                byArray2[n2++] = by;
            }
            ++n3;
        }
        byteArrayOutputStream.write(byArray2, 0, n2);
    }

    protected final byte[] streamToBytes(InputStream inputStream) throws SQLException {
        return this.streamToBytes(inputStream, true);
    }

    protected final byte[] streamToBytes(InputStream inputStream, boolean bl) throws SQLException {
        byte[] byArray;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = this.readblock(inputStream, this._bi);
            if (bl) {
                byteArrayOutputStream.write(39);
            }
            while (n > 0) {
                if (bl) {
                    this.escapeblock(this._bi, byteArrayOutputStream, n);
                } else {
                    byteArrayOutputStream.write(this._bi, 0, n);
                }
                n = this.readblock(inputStream, this._bi);
            }
            if (bl) {
                byteArrayOutputStream.write(39);
            }
            byArray = byteArrayOutputStream.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inputStream = null;
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputStream = null;
        return byArray;
    }

    private final char getSuccessor(char c, int n) {
        return (char)(c == 'y' && n == 2 ? 88 : (c == 'y' && n < 4 ? 121 : (c == 'y' ? 77 : (c == 'M' && n == 2 ? 89 : (c == 'M' && n < 3 ? 77 : (c == 'M' ? 100 : (c == 'd' && n < 2 ? 100 : (c == 'd' ? 104 : (c == 'h' && n < 2 ? 104 : (c == 'h' ? 109 : (c == 'm' && n < 2 ? 109 : (c == 'm' ? 115 : (c == 's' && n < 2 ? 115 : 87)))))))))))));
    }

    private final String getDateTimePattern(String string, boolean bl) throws Exception {
        Enumeration enumeration;
        char c;
        int n;
        Object[] objectArray;
        int n2;
        StringReader stringReader = new StringReader(string + " ");
        Vector<Object[]> vector = new Vector<Object[]>();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        Object[] objectArray2 = new Object[]{new Character('y'), new StringBuffer(), new Integer(0)};
        vector.addElement(objectArray2);
        if (bl) {
            objectArray2 = new Object[]{new Character('h'), new StringBuffer(), new Integer(0)};
            vector.addElement(objectArray2);
        }
        while ((n2 = stringReader.read()) != -1) {
            char c2 = (char)n2;
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                objectArray = (Object[])vector.elementAt(n4);
                n = (Integer)objectArray[2];
                c = this.getSuccessor(((Character)objectArray[0]).charValue(), n);
                if (!Character.isLetterOrDigit(c2)) {
                    if (c == ((Character)objectArray[0]).charValue() && c != 'S') {
                        vector2.addElement(objectArray);
                    } else {
                        ((StringBuffer)objectArray[1]).append(c2);
                        if (c == 'X' || c == 'Y') {
                            objectArray[2] = new Integer(4);
                        }
                    }
                } else {
                    if (c == 'X') {
                        c = 'y';
                        objectArray2 = new Object[3];
                        objectArray2[1] = new StringBuffer(((StringBuffer)objectArray[1]).toString()).append('M');
                        objectArray2[0] = new Character('M');
                        objectArray2[2] = new Integer(1);
                        vector.addElement(objectArray2);
                    } else if (c == 'Y') {
                        c = 'M';
                        objectArray2 = new Object[3];
                        objectArray2[1] = new StringBuffer(((StringBuffer)objectArray[1]).toString()).append('d');
                        objectArray2[0] = new Character('d');
                        objectArray2[2] = new Integer(1);
                        vector.addElement(objectArray2);
                    }
                    ((StringBuffer)objectArray[1]).append(c);
                    if (c == ((Character)objectArray[0]).charValue()) {
                        objectArray[2] = new Integer(n + 1);
                    } else {
                        objectArray[0] = new Character(c);
                        objectArray[2] = new Integer(1);
                    }
                }
                ++n4;
            }
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                objectArray = (Object[])enumeration.nextElement();
                vector.removeElement(objectArray);
            }
            vector2.removeAllElements();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl2;
            objectArray = (Object[])enumeration.nextElement();
            c = ((Character)objectArray[0]).charValue();
            boolean bl3 = this.getSuccessor(c, n = ((Integer)objectArray[2]).intValue()) != c;
            boolean bl4 = (c == 's' || c == 'm' || c == 'h' && bl) && bl3;
            boolean bl5 = bl3 && c == 'd' && !bl;
            boolean bl6 = bl2 = ((StringBuffer)objectArray[1]).toString().indexOf(87) != -1;
            if ((bl4 || bl5) && !bl2) continue;
            vector2.addElement(objectArray);
        }
        Enumeration enumeration2 = vector2.elements();
        while (enumeration2.hasMoreElements()) {
            vector.removeElement(enumeration2.nextElement());
        }
        vector2.removeAllElements();
        objectArray = (Object[])vector.firstElement();
        StringBuffer stringBuffer = (StringBuffer)objectArray[1];
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    static {
        _DoubleFormatter.setGroupingUsed(false);
        _DoubleFormatter.setMaximumFractionDigits(12);
    }

    class EndPoint {
        int begin;
        int end;

        EndPoint(int n, int n2) {
            this.begin = n;
            this.end = n2;
        }
    }
}

