/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.result;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.exceptions.StreamingNotifiable;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.mysqla.result.ResultsetRows;
import com.mysql.cj.api.result.Row;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.profiler.ProfilerEventHandlerFactory;
import com.mysql.cj.core.profiler.ProfilerEventImpl;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import com.mysql.cj.mysqla.result.AbstractResultsetRows;
import java.sql.Statement;

public class ResultsetRowsDynamic
extends AbstractResultsetRows
implements ResultsetRows {
    private int columnCount;
    private MysqlaProtocol io;
    private boolean isAfterEnd = false;
    private boolean noMoreRows = false;
    private boolean isBinaryEncoded = false;
    private Row nextRow;
    private boolean streamerClosed = false;
    private boolean moreResultsExisted;
    private ExceptionInterceptor exceptionInterceptor;

    public ResultsetRowsDynamic(MysqlaProtocol io, int colCount, Field[] fields, boolean isBinaryEncoded) {
        this.io = io;
        this.columnCount = colCount;
        this.isBinaryEncoded = isBinaryEncoded;
        this.metadata = fields;
        this.exceptionInterceptor = this.io.getExceptionInterceptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object mutex = this;
        MysqlConnection conn = null;
        if (this.owner != null && (conn = this.owner.getConnection()) != null) {
            mutex = conn.getConnectionMutex();
        }
        boolean hadMore = false;
        int howMuchMore = 0;
        ResultsetRowsDynamic resultsetRowsDynamic = mutex;
        synchronized (resultsetRowsDynamic) {
            while (this.next() != null) {
                hadMore = true;
                if (++howMuchMore % 100 != 0) continue;
                Thread.yield();
            }
            if (conn != null) {
                if (!conn.getPropertySet().getBooleanReadableProperty("clobberStreamingResults").getValue().booleanValue() && conn.getPropertySet().getIntegerReadableProperty("netTimeoutForStreamingResults").getValue() > 0) {
                    int oldValue = conn.getSession().getServerVariable("net_write_timeout", 60);
                    this.io.clearInputStream();
                    Statement stmt = null;
                    try {
                        try {
                            stmt = ((JdbcConnection)conn).createStatement();
                            ((StatementImpl)stmt).executeSimpleNonQuery((JdbcConnection)conn, "SET net_write_timeout=" + oldValue);
                        }
                        finally {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                    }
                    catch (Exception ex) {
                        throw ExceptionFactory.createException(ex.getMessage(), ex, this.exceptionInterceptor);
                    }
                }
                if (conn.getPropertySet().getBooleanReadableProperty("useUsageAdvisor").getValue().booleanValue() && hadMore) {
                    ProfilerEventHandler eventSink = ProfilerEventHandlerFactory.getInstance(conn.getSession());
                    eventSink.consumeEvent(new ProfilerEventImpl(0, "", this.owner.getCurrentCatalog(), this.owner.getConnectionId(), this.owner.getOwningStatementId(), -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, null, Messages.getString("RowDataDynamic.2") + howMuchMore + Messages.getString("RowDataDynamic.3") + Messages.getString("RowDataDynamic.4") + Messages.getString("RowDataDynamic.5") + Messages.getString("RowDataDynamic.6") + this.owner.getPointOfOrigin()));
                }
            }
        }
        this.metadata = null;
        this.owner = null;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext;
        boolean bl = hasNext = this.nextRow != null;
        if (!hasNext && !this.streamerClosed) {
            this.io.getResultsHandler().closeStreamer(this);
            this.streamerClosed = true;
        }
        return hasNext;
    }

    @Override
    public boolean isAfterLast() {
        return this.isAfterEnd;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentPositionInFetchedRows < 0;
    }

    @Override
    public Row next() {
        this.nextRecord();
        if (this.nextRow == null && !this.streamerClosed && !this.moreResultsExisted) {
            this.io.getResultsHandler().closeStreamer(this);
            this.streamerClosed = true;
        }
        if (this.nextRow != null && this.currentPositionInFetchedRows != Integer.MAX_VALUE) {
            ++this.currentPositionInFetchedRows;
        }
        return this.nextRow;
    }

    private void nextRecord() {
        try {
            if (!this.noMoreRows) {
                this.nextRow = this.io.getResultsHandler().nextRow(this.metadata, this.columnCount, this.isBinaryEncoded, 1007, true);
                if (this.nextRow == null) {
                    this.noMoreRows = true;
                    this.isAfterEnd = true;
                    this.moreResultsExisted = this.io.getResultsHandler().tackOnMoreStreamingResults(this.owner, this.isBinaryEncoded);
                    if (this.currentPositionInFetchedRows == -1) {
                        this.wasEmpty = true;
                    }
                }
            } else {
                this.nextRow = null;
                this.isAfterEnd = true;
            }
        }
        catch (CJException sqlEx) {
            if (sqlEx instanceof StreamingNotifiable) {
                ((StreamingNotifiable)((Object)sqlEx)).setWasStreamingResults();
            }
            this.noMoreRows = true;
            throw sqlEx;
        }
        catch (Exception ex) {
            String exceptionType = ex.getClass().getName();
            String exceptionMessage = ex.getMessage();
            exceptionMessage = exceptionMessage + Messages.getString("RowDataDynamic.7");
            exceptionMessage = exceptionMessage + Util.stackTraceToString(ex);
            CJException cjEx = ExceptionFactory.createException(Messages.getString("RowDataDynamic.8") + exceptionType + Messages.getString("RowDataDynamic.9") + exceptionMessage, ex, this.exceptionInterceptor);
            throw cjEx;
        }
    }
}

