/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.oakpal.testing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPackageUtil {
    static final Logger log = LoggerFactory.getLogger(TestPackageUtil.class);
    static final String PN_TEST_PACKAGES_SRC = "test-packages.src";
    static final String PN_TEST_PACKAGES_ROOT = "test-packages.root";
    private static Path testPackagesRoot;
    private static String testPackagesSrc;
    static final Properties properties;

    private TestPackageUtil() {
    }

    public static File prepareTestPackage(String filename) throws IOException {
        File file = new File(testPackagesRoot.toFile(), filename);
        try (InputStream is = TestPackageUtil.class.getResourceAsStream(testPackagesSrc + filename);
             FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        return file;
    }

    public static File prepareTestPackageFromFolder(String filename, File srcFolder) throws IOException {
        if (srcFolder == null || !srcFolder.isDirectory()) {
            throw new IOException("expected directory in srcFolder parameter for test package filename " + filename);
        }
        File file = new File(testPackagesRoot.toFile(), filename);
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(file));){
            TestPackageUtil.add(srcFolder, srcFolder, jos);
        }
        return file;
    }

    static void add(File root, File source, JarOutputStream target) throws IOException {
        block19: {
            String relPath;
            block18: {
                File[] children;
                if (root == null || source == null) {
                    throw new IllegalArgumentException("Cannot add from a null file");
                }
                if (!(source.getPath() + File.separator).startsWith(root.getPath() + File.separator)) {
                    throw new IllegalArgumentException("source must be the same file or a child of root");
                }
                relPath = !root.getPath().equals(source.getPath()) ? source.getPath().substring(root.getPath().length() + 1).replace(File.separator, "/") : "";
                if (!source.isDirectory()) break block18;
                if (!relPath.isEmpty()) {
                    String name = relPath;
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    JarEntry entry = new JarEntry(name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                if ((children = source.listFiles()) == null) break block19;
                for (File nestedFile : children) {
                    TestPackageUtil.add(root, nestedFile, target);
                }
                break block19;
            }
            JarEntry entry = new JarEntry(relPath);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
                int count;
                byte[] buffer = new byte[1024];
                while ((count = ((InputStream)in).read(buffer)) != -1) {
                    target.write(buffer, 0, count);
                }
                target.closeEntry();
            }
        }
    }

    static {
        properties = new Properties();
        try (InputStream propsIn = TestPackageUtil.class.getResourceAsStream("/test-packages.properties");){
            if (propsIn != null) {
                properties.load(propsIn);
            }
        }
        catch (IOException e) {
            log.error("Failed to load test-packages.properties");
        }
        testPackagesSrc = properties.getProperty(PN_TEST_PACKAGES_SRC, "/oakpal-testing/test-packages/");
        testPackagesRoot = Paths.get(properties.getProperty(PN_TEST_PACKAGES_ROOT, "target").replaceAll("/test-packages$", ""), new String[0]).resolve("test-packages");
        testPackagesRoot.toFile().mkdir();
    }
}

