/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.maven.plugin.logging.Log;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.FileAnalysisStore;
import sbt.internal.inc.IncrementalCompilerImpl;
import sbt.internal.inc.Locate;
import sbt.internal.inc.LoggedReporter;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.classpath.ClasspathUtilities;
import sbt_inc.SbtLogger;
import scala.Function1;
import scala.Option;
import scala.compat.java8.functionConverterImpls.FromJavaConsumer;
import scala_maven.VersionNumber;
import xsbti.Logger;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileResult;
import xsbti.compile.CompilerCache;
import xsbti.compile.Compilers;
import xsbti.compile.DefinesClass;
import xsbti.compile.IncOptions;
import xsbti.compile.Inputs;
import xsbti.compile.MiniSetup;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.PreviousResult;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.Setup;
import xsbti.compile.ZincCompilerUtil;

public class SbtIncrementalCompiler {
    public static final String SBT_GROUP_ID = "org.scala-sbt";
    public static final String ZINC_ARTIFACT_ID = "zinc";
    public static final String COMPILER_BRIDGE_ARTIFACT_ID = "compiler-bridge";
    private final CompileOrder compileOrder;
    private final Logger logger;
    private final IncrementalCompilerImpl compiler;
    private final Compilers compilers;
    private final Setup setup;
    private final AnalysisStore analysisStore;

    public SbtIncrementalCompiler(File libraryJar, File reflectJar, File compilerJar, VersionNumber scalaVersion, List<File> extraJars, File compilerBridgeJar, Log l, File cacheFile, CompileOrder compileOrder) throws Exception {
        this.compileOrder = compileOrder;
        this.logger = new SbtLogger(l);
        l.info((CharSequence)("Using incremental compilation using " + compileOrder + " compile order"));
        ArrayList<File> allJars = new ArrayList<File>(extraJars);
        allJars.add(libraryJar);
        allJars.add(reflectJar);
        allJars.add(compilerJar);
        ScalaInstance scalaInstance = new ScalaInstance(scalaVersion.toString(), (ClassLoader)new URLClassLoader(new URL[]{libraryJar.toURI().toURL(), reflectJar.toURI().toURL(), compilerJar.toURI().toURL()}), ClasspathUtilities.rootLoader(), libraryJar, compilerJar, allJars.toArray(new File[0]), Option.apply((Object)scalaVersion.toString()));
        this.compiler = new IncrementalCompilerImpl();
        AnalyzingCompiler scalaCompiler = new AnalyzingCompiler((xsbti.compile.ScalaInstance)scalaInstance, ZincCompilerUtil.constantBridgeProvider((xsbti.compile.ScalaInstance)scalaInstance, (File)compilerBridgeJar), ClasspathOptionsUtil.auto(), (Function1)new FromJavaConsumer(noop -> {}), Option.apply(null));
        this.compilers = this.compiler.compilers((xsbti.compile.ScalaInstance)scalaInstance, ClasspathOptionsUtil.boot(), Option.apply(null), (ScalaCompiler)scalaCompiler);
        PerClasspathEntryLookup lookup = new PerClasspathEntryLookup(){

            public Optional<CompileAnalysis> analysis(File classpathEntry) {
                return Optional.empty();
            }

            public DefinesClass definesClass(File classpathEntry) {
                return Locate.definesClass((File)classpathEntry);
            }
        };
        LoggedReporter reporter = new LoggedReporter(100, this.logger, pos -> pos);
        this.analysisStore = AnalysisStore.getCachedStore((AnalysisStore)FileAnalysisStore.binary((File)cacheFile));
        this.setup = this.compiler.setup(lookup, false, cacheFile, CompilerCache.fresh(), IncOptions.of(), (Reporter)reporter, Option.apply(null), new T2[0]);
    }

    public void compile(List<String> classpathElements, List<File> sources, File classesDirectory, List<String> scalacOptions, List<String> javacOptions) {
        ArrayList<File> fullClasspath = new ArrayList<File>();
        fullClasspath.add(classesDirectory);
        for (String classpathElement : classpathElements) {
            fullClasspath.add(new File(classpathElement));
        }
        Inputs inputs = this.compiler.inputs(fullClasspath.toArray(new File[0]), sources.toArray(new File[0]), classesDirectory, scalacOptions.toArray(new String[0]), javacOptions.toArray(new String[0]), 100, new Function[0], this.compileOrder, this.compilers, this.setup, this.compiler.emptyPreviousResult());
        Optional analysisContents = this.analysisStore.get();
        if (analysisContents.isPresent()) {
            AnalysisContents analysisContents0 = (AnalysisContents)analysisContents.get();
            CompileAnalysis previousAnalysis = analysisContents0.getAnalysis();
            MiniSetup previousSetup = analysisContents0.getMiniSetup();
            PreviousResult previousResult = PreviousResult.of(Optional.of(previousAnalysis), Optional.of(previousSetup));
            inputs = inputs.withPreviousResult(previousResult);
        }
        CompileResult newResult = this.compiler.compile(inputs, this.logger);
        this.analysisStore.set(AnalysisContents.create((CompileAnalysis)newResult.analysis(), (MiniSetup)newResult.setup()));
    }
}

