/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.util.map.ByteObjectMap;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.tries.ByteTrieNode;
import net.amygdalum.util.tries.ByteTrieNodeCompiler;
import net.amygdalum.util.tries.PreByteTrieNode;

public class AhoCorasick
implements StringSearchAlgorithm {
    private ByteTrieNode<ByteString> trie;
    private int minLength;

    public AhoCorasick(Collection<String> patterns, Charset charset) {
        List bytepatterns = StringUtils.toByteArray(patterns, (Charset)charset);
        this.trie = AhoCorasick.computeTrie(bytepatterns, charset);
        this.minLength = ByteUtils.minLength((List)bytepatterns);
    }

    private static ByteTrieNode<ByteString> computeTrie(List<byte[]> bytepatterns, Charset charset) {
        PreByteTrieNode trie = new PreByteTrieNode();
        for (byte[] pattern : bytepatterns) {
            trie.extend(pattern, (Object)new ByteString(pattern, charset));
        }
        return AhoCorasick.computeSupportTransition((PreByteTrieNode<ByteString>)trie);
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(bytes, options);
        }
        return new NextMatchFinder(bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    private static ByteTrieNode<ByteString> computeSupportTransition(PreByteTrieNode<ByteString> trie) {
        LinkedList<Object> worklist = new LinkedList<Object>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            PreByteTrieNode current = (PreByteTrieNode)worklist.remove();
            for (ByteObjectMap.Entry next : current.getNexts().cursor()) {
                PreByteTrieNode nextTrie = (PreByteTrieNode)next.value;
                AhoCorasick.computeSupport((PreByteTrieNode<ByteString>)current, next.key, (PreByteTrieNode<ByteString>)nextTrie, trie);
                worklist.add(nextTrie);
            }
        }
        return new ByteTrieNodeCompiler(false).compileAndLink(trie);
    }

    private static void computeSupport(PreByteTrieNode<ByteString> parent, byte b, PreByteTrieNode<ByteString> trie, PreByteTrieNode<ByteString> init) {
        if (parent != null) {
            PreByteTrieNode down;
            for (down = parent.getLink(); down != null && down.nextNode(b) == null; down = down.getLink()) {
            }
            if (down != null) {
                PreByteTrieNode next = down.nextNode(b);
                trie.link(next);
                ByteString nextMatch = (ByteString)next.getAttached();
                if (nextMatch != null && trie.getAttached() == null) {
                    trie.setAttached((Object)nextMatch);
                }
            } else {
                trie.link(init);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new AhoCorasick(patterns, this.charset);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished()) {
                ByteTrieNode nextcurrent;
                byte b = this.bytes.next();
                ByteTrieNode next = this.current.nextNode(b);
                if (next == null && !this.isBufferEmpty()) {
                    this.bytes.prev();
                    break;
                }
                while (next == null && (nextcurrent = this.current.getLink()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(b);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getAttached() == null) continue;
                this.push(this.createMatches((ByteTrieNode<ByteString>)this.current, this.bytes.current()));
            }
            return this.longestLeftMost();
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            while (!this.bytes.finished()) {
                ByteTrieNode nextcurrent;
                byte b = this.bytes.next();
                ByteTrieNode next = this.current.nextNode(b);
                while (next == null && (nextcurrent = this.current.getLink()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(b);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getAttached() == null) continue;
                this.push(this.createMatches((ByteTrieNode<ByteString>)this.current, this.bytes.current()));
                return this.leftMost();
            }
            return null;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected ByteProvider bytes;
        protected ByteTrieNode<ByteString> current;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
            this.current = AhoCorasick.this.trie;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.current = AhoCorasick.this.trie;
            this.clear();
        }

        protected List<StringMatch> createMatches(ByteTrieNode<ByteString> current, long end) {
            ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
            while (current != null) {
                long start;
                StringMatch nextMatch;
                ByteString currentMatch = (ByteString)current.getAttached();
                if (currentMatch != null && !matches.contains(nextMatch = this.createMatch(start = end - (long)currentMatch.length(), end))) {
                    matches.add(nextMatch);
                }
                current = current.getLink();
            }
            return matches;
        }

        private StringMatch createMatch(long start, long end) {
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

