/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithmFactory;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteUtils;

public class BNDM
implements StringSearchAlgorithm {
    private int patternLength;
    private BitMapStates states;

    public BNDM(String pattern, Charset charset) {
        byte[] encoded = ByteUtils.encode((String)pattern, (Charset)charset);
        this.patternLength = encoded.length;
        this.states = BNDM.computeStates(encoded);
    }

    private static BitMapStates computeStates(byte[] pattern) {
        if (pattern.length > 64) {
            return new QuickMultiLongStates(pattern);
        }
        return new QuickSingleLongStates(pattern);
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (this.states.supportsSingle()) {
            return new LongFinder(bytes, options);
        }
        return new MultiLongFinder(bytes, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class QuickMultiLongStates
    extends MultiLongBitMapStates {
        private long[][] bytes;

        public QuickMultiLongStates(byte[] pattern) {
            this.bytes = QuickMultiLongStates.computeStates(pattern);
        }

        private static long[][] computeStates(byte[] pattern) {
            int numberOfSubpatterns = (pattern.length - 1) / 64 + 1;
            long[][] bytes = new long[numberOfSubpatterns][];
            for (int i = 0; i < bytes.length; ++i) {
                int start = i * 64;
                int end = i == bytes.length - 1 ? pattern.length : (i + 1) * 64;
                byte[] subpattern = Arrays.copyOfRange(pattern, start, end);
                bytes[i] = QuickMultiLongStates.computeSubStates(subpattern);
            }
            return bytes;
        }

        private static long[] computeSubStates(byte[] pattern) {
            long[] characters = new long[256];
            for (int i = 0; i < pattern.length; ++i) {
                int j = pattern.length - i - 1;
                byte b = pattern[i];
                int n = b & 0xFF;
                characters[n] = characters[n] | 1L << j;
            }
            return characters;
        }

        @Override
        public long select(int i, byte b) {
            return this.bytes[i][b & 0xFF];
        }
    }

    private static abstract class MultiLongBitMapStates
    implements BitMapStates {
        private MultiLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return false;
        }

        @Override
        public long single(byte b) {
            throw new UnsupportedOperationException();
        }
    }

    private static class QuickSingleLongStates
    extends SingleLongBitMapStates {
        private long[] bytes;

        public QuickSingleLongStates(byte[] pattern) {
            this.bytes = QuickSingleLongStates.computeStates(pattern);
        }

        private static long[] computeStates(byte[] pattern) {
            long[] characters = new long[256];
            for (int i = 0; i < pattern.length; ++i) {
                int j = pattern.length - i - 1;
                byte b = pattern[i];
                int n = b & 0xFF;
                characters[n] = characters[n] | 1L << j;
            }
            return characters;
        }

        @Override
        public long single(byte b) {
            return this.bytes[b & 0xFF];
        }
    }

    private static abstract class SingleLongBitMapStates
    implements BitMapStates {
        private SingleLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return true;
        }

        @Override
        public long select(int i, byte b) {
            if (i > 0) {
                return 0L;
            }
            return this.single(b);
        }
    }

    public static interface BitMapStates {
        public boolean supportsSingle();

        public long single(byte var1);

        public long select(int var1, byte var2);
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new BNDM(pattern, this.charset);
        }
    }

    private class MultiLongFinder
    extends Finder {
        protected final long[] finalstate;
        protected final long[] activeStates;
        private long state;
        private int segment;
        private int[] patternLengths;

        public MultiLongFinder(ByteProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.patternLengths = this.computePatternLengths();
            this.finalstate = this.computeFinalStates();
            this.activeStates = this.computeActiveStates();
            this.segment = 0;
            this.state = this.activeStates[this.segment];
        }

        private int[] computePatternLengths() {
            int numberOfSubpatterns = (BNDM.this.patternLength - 1) / 64 + 1;
            int[] patternLengths = new int[numberOfSubpatterns];
            Arrays.fill(patternLengths, 0, patternLengths.length - 1, 64);
            patternLengths[patternLengths.length - 1] = (BNDM.this.patternLength - 1) % 64 + 1;
            return patternLengths;
        }

        private long[] computeFinalStates() {
            long[] finalStates = new long[this.patternLengths.length];
            for (int i = 0; i < finalStates.length; ++i) {
                int patternLength = this.patternLengths[i];
                finalStates[i] = 1L << (patternLength - 1) % 64;
            }
            return finalStates;
        }

        private long[] computeActiveStates() {
            long[] activeStates = new long[this.finalstate.length];
            for (int i = 0; i < activeStates.length; ++i) {
                activeStates[i] = this.finalstate[i] - 1L | this.finalstate[i];
            }
            return activeStates;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.segment = 0;
            this.state = this.activeStates[this.segment];
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished(BNDM.this.patternLength - 1)) {
                this.segment = 0;
                this.state = this.activeStates[this.segment];
                int j = this.patternLengths[this.segment] - 1;
                int[] last = new int[this.patternLengths.length];
                System.arraycopy(this.patternLengths, 0, last, 0, this.patternLengths.length);
                while (this.state != 0L) {
                    byte currentByte = this.bytes.lookahead(this.segment * 64 + j);
                    long single = BNDM.this.states.select(this.segment, currentByte);
                    this.state &= single;
                    if ((this.state & this.finalstate[this.segment]) != 0L) {
                        if (j > 0) {
                            last[this.segment] = j;
                        } else {
                            if (this.segment == this.patternLengths.length - 1) {
                                StringMatch createMatch = this.createMatch();
                                this.bytes.forward(this.max(last, this.segment));
                                return createMatch;
                            }
                            ++this.segment;
                            this.state = this.activeStates[this.segment];
                            j = this.patternLengths[this.segment] - 1;
                            continue;
                        }
                    }
                    --j;
                    this.state = this.state << 1 & this.activeStates[this.segment];
                }
                this.bytes.forward(this.max(last, this.segment));
            }
            return null;
        }

        private int max(int[] values, int last) {
            int max = 0;
            for (int i = 0; i <= last; ++i) {
                int next = values[i];
                if (next <= max) continue;
                max = next;
            }
            return max;
        }
    }

    private class LongFinder
    extends Finder {
        private long state;

        public LongFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
            this.state = this.activeStates;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.state = this.activeStates;
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished(BNDM.this.patternLength - 1)) {
                this.state = this.activeStates;
                int j = BNDM.this.patternLength - 1;
                int last = BNDM.this.patternLength;
                while (this.state != 0L) {
                    byte currentByte = this.bytes.lookahead(j);
                    long single = BNDM.this.states.single(currentByte);
                    this.state &= single;
                    if ((this.state & this.finalstate) != 0L) {
                        if (j > 0) {
                            last = j;
                        } else {
                            StringMatch createMatch = this.createMatch();
                            this.bytes.forward(last);
                            return createMatch;
                        }
                    }
                    --j;
                    this.state = this.state << 1 & this.activeStates;
                }
                this.bytes.forward(last);
            }
            return null;
        }
    }

    private abstract class Finder
    extends AbstractStringFinder {
        protected final long finalstate;
        protected final long activeStates;
        protected ByteProvider bytes;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.finalstate = 1L << (BNDM.this.patternLength - 1) % 64;
            this.activeStates = this.finalstate - 1L | this.finalstate;
            this.bytes = bytes;
        }

        protected StringMatch createMatch() {
            long start = this.bytes.current();
            long end = start + (long)BNDM.this.patternLength;
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

