/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.ByteShift;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.tries.ByteTrieNode;
import net.amygdalum.util.tries.ByteTrieNodeCompiler;
import net.amygdalum.util.tries.PreByteTrieNode;

public class SetHorspool
implements StringSearchAlgorithm {
    private ByteTrieNode<ByteString> trie;
    private int minLength;
    private int maxLength;
    private ByteShift byteShift;

    public SetHorspool(Collection<String> patterns, Charset charset) {
        List bytepatterns = StringUtils.toByteArray(patterns, (Charset)charset);
        this.trie = SetHorspool.computeTrie(bytepatterns, charset);
        this.minLength = ByteUtils.minLength((List)bytepatterns);
        this.maxLength = ByteUtils.maxLength((List)bytepatterns);
        this.byteShift = this.computeByteShift(bytepatterns, this.minLength);
    }

    private ByteShift computeByteShift(List<byte[]> bytepatterns, int minLength) {
        return new QuickShift(bytepatterns, minLength);
    }

    private static ByteTrieNode<ByteString> computeTrie(List<byte[]> bytepatterns, Charset charset) {
        PreByteTrieNode trie = new PreByteTrieNode();
        for (byte[] pattern : bytepatterns) {
            PreByteTrieNode node = trie.extend(ByteUtils.revert((byte[])pattern), 0);
            node.setAttached((Object)new ByteString(pattern, charset));
        }
        return new ByteTrieNodeCompiler(false).compileAndLink(trie);
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(bytes, options);
        }
        return new NextMatchFinder(bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class QuickShift
    implements ByteShift {
        private int[] byteShift;

        public QuickShift(List<byte[]> bytepatterns, int minLength) {
            this.byteShift = QuickShift.computeByteShift(bytepatterns, minLength);
        }

        private static int[] computeByteShift(List<byte[]> patterns, int minLength) {
            int[] bytes = new int[256];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = minLength;
            }
            for (byte[] pattern : patterns) {
                for (int i = 0; i < pattern.length - 1; ++i) {
                    bytes[pattern[i] & 0xFF] = Math.min(bytes[pattern[i] & 0xFF], pattern.length - i - 1);
                }
            }
            return bytes;
        }

        @Override
        public int getShift(byte b) {
            return this.byteShift[b & 0xFF];
        }
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new SetHorspool(patterns, this.charset);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
        }

        @Override
        public StringMatch findNext() {
            long lastStart = this.lastStartFromBuffer();
            int lookahead = SetHorspool.this.minLength - 1;
            while (!this.bytes.finished(lookahead)) {
                int patternPointer = lookahead;
                long pos = this.bytes.current();
                byte current = this.bytes.lookahead(patternPointer);
                for (ByteTrieNode node = SetHorspool.this.trie.nextNode(current); node != null; node = node.nextNode(this.bytes.lookahead(patternPointer))) {
                    ByteString match = (ByteString)node.getAttached();
                    if (match != null) {
                        long start = this.bytes.current() + (long)patternPointer;
                        long end = this.bytes.current() + (long)patternPointer + (long)match.length();
                        StringMatch stringMatch = this.createMatch(start, end);
                        if (lastStart < 0L) {
                            lastStart = start;
                        }
                        this.push(stringMatch);
                    }
                    if (pos + (long)(--patternPointer) < 0L) break;
                }
                this.bytes.forward(SetHorspool.this.byteShift.getShift(current));
                if (!this.bufferContainsLongestMatch(lastStart)) continue;
                break;
            }
            return this.longestLeftMost();
        }

        public boolean bufferContainsLongestMatch(long lastStart) {
            return !this.isBufferEmpty() && this.bytes.current() - lastStart > (long)SetHorspool.this.maxLength;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected ByteProvider bytes;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            if (last > this.bytes.current()) {
                this.bytes.move(last);
            }
        }

        protected StringMatch createMatch(long start, long end) {
            ByteString slice = this.bytes.slice(start, end);
            return new StringMatch(start, end, slice.getString());
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            int lookahead = SetHorspool.this.minLength - 1;
            while (!this.bytes.finished(lookahead)) {
                int patternPointer = lookahead;
                long pos = this.bytes.current();
                byte current = this.bytes.lookahead(patternPointer);
                for (ByteTrieNode node = SetHorspool.this.trie.nextNode(current); node != null; node = node.nextNode(this.bytes.lookahead(patternPointer))) {
                    ByteString match = (ByteString)node.getAttached();
                    if (match != null) {
                        long start = this.bytes.current() + (long)patternPointer;
                        long end = this.bytes.current() + (long)patternPointer + (long)match.length();
                        this.push(this.createMatch(start, end));
                    }
                    if (pos + (long)(--patternPointer) < 0L) break;
                }
                this.bytes.forward(SetHorspool.this.byteShift.getShift(current));
                if (this.isBufferEmpty()) continue;
                return this.leftMost();
            }
            return null;
        }
    }
}

