/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.tries.CharTrieNode;
import net.amygdalum.util.tries.CharTrieNodeCompiler;
import net.amygdalum.util.tries.PreCharTrieNode;

public class AhoCorasick
implements StringSearchAlgorithm {
    private CharTrieNode<String> trie;
    private int minLength;

    public AhoCorasick(Collection<String> patterns) {
        List charpatterns = StringUtils.toCharArray(patterns);
        this.trie = AhoCorasick.computeTrie(charpatterns);
        this.minLength = CharUtils.minLength((List)charpatterns);
    }

    private static CharTrieNode<String> computeTrie(List<char[]> charpatterns) {
        PreCharTrieNode trie = new PreCharTrieNode();
        for (char[] pattern : charpatterns) {
            trie.extend(pattern, (Object)new String(pattern));
        }
        return AhoCorasick.computeSupportTransition((PreCharTrieNode<String>)trie);
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(chars, options);
        }
        return new NextMatchFinder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    private static CharTrieNode<String> computeSupportTransition(PreCharTrieNode<String> trie) {
        LinkedList<Object> worklist = new LinkedList<Object>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            PreCharTrieNode current = (PreCharTrieNode)worklist.remove();
            for (CharObjectMap.Entry next : current.getNexts().cursor()) {
                PreCharTrieNode nextTrie = (PreCharTrieNode)next.value;
                AhoCorasick.computeSupport((PreCharTrieNode<String>)current, next.key, (PreCharTrieNode<String>)nextTrie, trie);
                worklist.add(nextTrie);
            }
        }
        return new CharTrieNodeCompiler(false).compileAndLink(trie);
    }

    private static void computeSupport(PreCharTrieNode<String> parent, char c, PreCharTrieNode<String> trie, PreCharTrieNode<String> init) {
        if (parent != null) {
            PreCharTrieNode down;
            for (down = parent.getLink(); down != null && down.nextNode(c) == null; down = down.getLink()) {
            }
            if (down != null) {
                PreCharTrieNode next = down.nextNode(c);
                trie.link(next);
                String nextMatch = (String)next.getAttached();
                if (nextMatch != null && trie.getAttached() == null) {
                    trie.setAttached((Object)nextMatch);
                }
            } else {
                trie.link(init);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new AhoCorasick(patterns);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                CharTrieNode nextcurrent;
                char c = this.chars.next();
                CharTrieNode next = this.current.nextNode(c);
                if (next == null && !this.isBufferEmpty()) {
                    this.chars.prev();
                    break;
                }
                while (next == null && (nextcurrent = this.current.getLink()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(c);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getAttached() == null) continue;
                this.push(this.createMatches((CharTrieNode<String>)this.current, this.chars.current()));
            }
            return this.longestLeftMost();
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            while (!this.chars.finished()) {
                CharTrieNode nextcurrent;
                char c = this.chars.next();
                CharTrieNode next = this.current.nextNode(c);
                while (next == null && (nextcurrent = this.current.getLink()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(c);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getAttached() == null) continue;
                this.push(this.createMatches((CharTrieNode<String>)this.current, this.chars.current()));
                return this.leftMost();
            }
            return null;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected CharProvider chars;
        protected CharTrieNode<String> current;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
            this.current = AhoCorasick.this.trie;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.current = AhoCorasick.this.trie;
            this.clear();
        }

        protected List<StringMatch> createMatches(CharTrieNode<String> current, long end) {
            ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
            while (current != null) {
                long start;
                StringMatch nextMatch;
                String currentMatch = (String)current.getAttached();
                if (currentMatch != null && !matches.contains(nextMatch = this.createMatch(start = end - (long)currentMatch.length(), end))) {
                    matches.add(nextMatch);
                }
                current = current.getLink();
            }
            return matches;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

