/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.Arrays;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.map.CharLongMap;
import net.amygdalum.util.text.CharAlphabet;
import net.amygdalum.util.text.CharMapping;

public class BNDM
implements StringSearchAlgorithm {
    private int patternLength;
    private BitMapStates states;

    public BNDM(String pattern) {
        this(pattern, CharMapping.IDENTITY);
    }

    public BNDM(String pattern, CharMapping mapping) {
        this.patternLength = pattern.length();
        this.states = BNDM.computeStates(pattern.toCharArray(), mapping);
    }

    private static BitMapStates computeStates(char[] pattern, CharMapping mapping) {
        CharAlphabet alphabet = CharAlphabet.ranged((char[])pattern, (CharMapping)mapping);
        int compactSize = Math.max(256, pattern.length * 2);
        if (alphabet.getRange() < compactSize) {
            if (pattern.length > 64) {
                return new QuickMultiLongStates(pattern, alphabet, mapping);
            }
            return new QuickSingleLongStates(pattern, alphabet, mapping);
        }
        if (pattern.length > 64) {
            return new SmartMultiLongStates(pattern, mapping);
        }
        return new SmartSingleLongStates(pattern, mapping);
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (this.states.supportsSingle()) {
            return new LongFinder(chars, options);
        }
        return new MultiLongFinder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class SmartMultiLongStates
    extends MultiLongBitMapStates {
        private CharLongMap[] states;

        public SmartMultiLongStates(char[] pattern, CharMapping mapping) {
            this.states = SmartMultiLongStates.computeStates(pattern, mapping);
        }

        private static CharLongMap[] computeStates(char[] pattern, CharMapping mapping) {
            int numberOfSubpatterns = (pattern.length - 1) / 64 + 1;
            CharLongMap[] characters = new CharLongMap[numberOfSubpatterns];
            for (int i = 0; i < characters.length; ++i) {
                int start = i * 64;
                int end = i == characters.length - 1 ? pattern.length : (i + 1) * 64;
                char[] subpattern = Arrays.copyOfRange(pattern, start, end);
                characters[i] = SmartMultiLongStates.computeSubStates(subpattern, mapping);
            }
            return characters;
        }

        private static CharLongMap computeSubStates(char[] pattern, CharMapping mapping) {
            CharLongMap map = new CharLongMap(0L);
            for (int i = 0; i < pattern.length; ++i) {
                int j = pattern.length - i - 1;
                for (char c : mapping.map(pattern[i])) {
                    long newState = map.get(c) | 1L << j;
                    map.put(c, newState);
                }
            }
            return map;
        }

        @Override
        public long select(int i, char c) {
            return this.states[i].get(c);
        }
    }

    private static class QuickMultiLongStates
    extends MultiLongBitMapStates {
        private char minChar;
        private char maxChar;
        private long[][] characters;

        public QuickMultiLongStates(char[] pattern, CharAlphabet alphabet, CharMapping mapping) {
            this.minChar = alphabet.minChar();
            this.maxChar = alphabet.maxChar();
            this.characters = QuickMultiLongStates.computeStates(pattern, mapping, this.minChar, this.maxChar);
        }

        private static long[][] computeStates(char[] pattern, CharMapping mapping, char min, char max) {
            int numberOfSubpatterns = (pattern.length - 1) / 64 + 1;
            long[][] characters = new long[numberOfSubpatterns][];
            for (int i = 0; i < characters.length; ++i) {
                int start = i * 64;
                int end = i == characters.length - 1 ? pattern.length : (i + 1) * 64;
                char[] subpattern = Arrays.copyOfRange(pattern, start, end);
                characters[i] = QuickMultiLongStates.computeSubStates(subpattern, mapping, min, max);
            }
            return characters;
        }

        private static long[] computeSubStates(char[] pattern, CharMapping mapping, char min, char max) {
            long[] characters = new long[max - min + 1];
            for (int i = 0; i < pattern.length; ++i) {
                int j = pattern.length - i - 1;
                for (char c : mapping.map(pattern[i])) {
                    int n = c - min;
                    characters[n] = characters[n] | 1L << j;
                }
            }
            return characters;
        }

        @Override
        public long select(int i, char c) {
            if (c < this.minChar || c > this.maxChar) {
                return 0L;
            }
            return this.characters[i][c - this.minChar];
        }
    }

    private static abstract class MultiLongBitMapStates
    implements BitMapStates {
        private MultiLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return false;
        }

        @Override
        public long single(char c) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SmartSingleLongStates
    extends SingleLongBitMapStates {
        private CharLongMap states;

        public SmartSingleLongStates(char[] pattern, CharMapping mapping) {
            this.states = SmartSingleLongStates.computeStates(pattern, mapping);
        }

        private static CharLongMap computeStates(char[] pattern, CharMapping mapping) {
            CharLongMap map = new CharLongMap(0L);
            for (int i = 0; i < pattern.length; ++i) {
                int j = pattern.length - i - 1;
                for (char c : mapping.map(pattern[i])) {
                    long newState = map.get(c) | 1L << j;
                    map.put(c, newState);
                }
            }
            return map;
        }

        @Override
        public long single(char c) {
            return this.states.get(c);
        }
    }

    private static class QuickSingleLongStates
    extends SingleLongBitMapStates {
        private char minChar;
        private char maxChar;
        private long[] characters;

        public QuickSingleLongStates(char[] pattern, CharAlphabet alphabet, CharMapping mapping) {
            this.minChar = alphabet.minChar();
            this.maxChar = alphabet.maxChar();
            this.characters = QuickSingleLongStates.computeStates(pattern, mapping, this.minChar, this.maxChar);
        }

        private static long[] computeStates(char[] pattern, CharMapping mapping, char min, char max) {
            long[] characters = new long[max - min + 1];
            for (int i = 0; i < pattern.length; ++i) {
                int j = pattern.length - i - 1;
                for (char c : mapping.map(pattern[i])) {
                    int n = c - min;
                    characters[n] = characters[n] | 1L << j;
                }
            }
            return characters;
        }

        @Override
        public long single(char c) {
            if (c < this.minChar || c > this.maxChar) {
                return 0L;
            }
            return this.characters[c - this.minChar];
        }
    }

    private static abstract class SingleLongBitMapStates
    implements BitMapStates {
        private SingleLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return true;
        }

        @Override
        public long select(int i, char c) {
            if (i > 0) {
                return 0L;
            }
            return this.single(c);
        }
    }

    public static interface BitMapStates {
        public boolean supportsSingle();

        public long single(char var1);

        public long select(int var1, char var2);
    }

    public static class Factory
    implements StringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            if (this.mapping == null) {
                return new BNDM(pattern);
            }
            return new BNDM(pattern, this.mapping);
        }
    }

    private class MultiLongFinder
    extends Finder {
        protected final long[] finalstate;
        protected final long[] activeStates;
        private long state;
        private int segment;
        private int[] patternLengths;

        public MultiLongFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.patternLengths = this.computePatternLengths();
            this.finalstate = this.computeFinalStates();
            this.activeStates = this.computeActiveStates();
            this.segment = 0;
            this.state = this.activeStates[this.segment];
        }

        private int[] computePatternLengths() {
            int numberOfSubpatterns = (BNDM.this.patternLength - 1) / 64 + 1;
            int[] patternLengths = new int[numberOfSubpatterns];
            Arrays.fill(patternLengths, 0, patternLengths.length - 1, 64);
            patternLengths[patternLengths.length - 1] = (BNDM.this.patternLength - 1) % 64 + 1;
            return patternLengths;
        }

        private long[] computeFinalStates() {
            long[] finalStates = new long[this.patternLengths.length];
            for (int i = 0; i < finalStates.length; ++i) {
                int patternLength = this.patternLengths[i];
                finalStates[i] = 1L << (patternLength - 1) % 64;
            }
            return finalStates;
        }

        private long[] computeActiveStates() {
            long[] activeStates = new long[this.finalstate.length];
            for (int i = 0; i < activeStates.length; ++i) {
                activeStates[i] = this.finalstate[i] - 1L | this.finalstate[i];
            }
            return activeStates;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.segment = 0;
            this.state = this.activeStates[this.segment];
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished(BNDM.this.patternLength - 1)) {
                this.segment = 0;
                this.state = this.activeStates[this.segment];
                int j = this.patternLengths[this.segment] - 1;
                int[] last = new int[this.patternLengths.length];
                System.arraycopy(this.patternLengths, 0, last, 0, this.patternLengths.length);
                while (this.state != 0L) {
                    char currentChar = this.chars.lookahead(this.segment * 64 + j);
                    long single = BNDM.this.states.select(this.segment, currentChar);
                    this.state &= single;
                    if ((this.state & this.finalstate[this.segment]) != 0L) {
                        if (j > 0) {
                            last[this.segment] = j;
                        } else {
                            if (this.segment == this.patternLengths.length - 1) {
                                StringMatch createMatch = this.createMatch();
                                this.chars.forward(this.max(last, this.segment));
                                return createMatch;
                            }
                            ++this.segment;
                            this.state = this.activeStates[this.segment];
                            j = this.patternLengths[this.segment] - 1;
                            continue;
                        }
                    }
                    --j;
                    this.state = this.state << 1 & this.activeStates[this.segment];
                }
                this.chars.forward(this.max(last, this.segment));
            }
            return null;
        }

        private int max(int[] values, int last) {
            int max = 0;
            for (int i = 0; i <= last; ++i) {
                int next = values[i];
                if (next <= max) continue;
                max = next;
            }
            return max;
        }
    }

    private class LongFinder
    extends Finder {
        protected final long finalstate;
        protected final long activeStates;
        private long state;

        public LongFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.finalstate = 1L << (BNDM.this.patternLength - 1) % 64;
            this.state = this.activeStates = this.finalstate - 1L | this.finalstate;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.state = this.activeStates;
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished(BNDM.this.patternLength - 1)) {
                this.state = this.activeStates;
                int j = BNDM.this.patternLength - 1;
                int last = BNDM.this.patternLength;
                while (this.state != 0L) {
                    char currentChar = this.chars.lookahead(j);
                    long single = BNDM.this.states.single(currentChar);
                    this.state &= single;
                    if ((this.state & this.finalstate) != 0L) {
                        if (j > 0) {
                            last = j;
                        } else {
                            StringMatch createMatch = this.createMatch();
                            this.chars.forward(last);
                            return createMatch;
                        }
                    }
                    --j;
                    this.state = this.state << 1 & this.activeStates;
                }
                this.chars.forward(last);
            }
            return null;
        }
    }

    private abstract class Finder
    extends AbstractStringFinder {
        protected CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
        }

        protected StringMatch createMatch() {
            long start = this.chars.current();
            long end = start + (long)BNDM.this.patternLength;
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

