/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.CharShift;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;
import net.amygdalum.util.map.CharIntMap;
import net.amygdalum.util.text.CharUtils;

public class Horspool
implements StringSearchAlgorithm {
    private char[] pattern;
    private int patternLength;
    private CharShift charShift;

    public Horspool(String pattern) {
        this(pattern, false);
    }

    public Horspool(String pattern, boolean relaxed) {
        this.pattern = pattern.toCharArray();
        this.patternLength = this.pattern.length;
        this.charShift = Horspool.computeShift(this.pattern, relaxed);
    }

    private static CharShift computeShift(char[] pattern, boolean relaxed) {
        if (Horspool.isCompactRange(pattern)) {
            return new QuickShift(pattern);
        }
        if (relaxed) {
            return new RelaxedShift(pattern);
        }
        return new SmartShift(pattern);
    }

    public static boolean isCompactRange(char[] pattern) {
        char minChar = CharUtils.computeMinChar((char[])pattern);
        char maxChar = CharUtils.computeMaxChar((char[])pattern);
        return maxChar - minChar < 256 || maxChar - minChar < pattern.length * 2;
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class SmartShift
    implements CharShift {
        private CharIntMap characterShift;

        public SmartShift(char[] pattern) {
            this.characterShift = SmartShift.computeCharacterShift(pattern);
        }

        private static CharIntMap computeCharacterShift(char[] pattern) {
            CharIntMap map = new CharIntMap(pattern.length);
            for (int i = 0; i < pattern.length - 1; ++i) {
                map.put(pattern[i], pattern.length - i - 1);
            }
            return map;
        }

        @Override
        public int getShift(char c) {
            return this.characterShift.get(c);
        }
    }

    private static class RelaxedShift
    implements CharShift {
        private int[] characterShift;

        public RelaxedShift(char[] pattern) {
            this.characterShift = RelaxedShift.computeCharacterShift(pattern);
        }

        private static int[] computeCharacterShift(char[] pattern) {
            int i;
            int[] characters = new int[256];
            for (i = 0; i < characters.length; ++i) {
                characters[i] = pattern.length;
            }
            for (i = 0; i < pattern.length - 1; ++i) {
                int newShift = pattern.length - i - 1;
                int index = pattern[i] % 256;
                if (newShift >= characters[index]) continue;
                characters[index] = newShift;
            }
            return characters;
        }

        @Override
        public int getShift(char c) {
            return this.characterShift[c % 256];
        }
    }

    private static class QuickShift
    implements CharShift {
        private char minChar;
        private char maxChar;
        private int[] characterShift;
        private int defaultShift;

        public QuickShift(char[] pattern) {
            this.minChar = CharUtils.computeMinChar((char[])pattern);
            this.maxChar = CharUtils.computeMaxChar((char[])pattern);
            this.characterShift = QuickShift.computeCharacterShift(pattern, this.minChar, this.maxChar);
            this.defaultShift = pattern.length;
        }

        private static int[] computeCharacterShift(char[] pattern, char min, char max) {
            int i;
            int[] characters = new int[max - min + 1];
            for (i = 0; i < characters.length; ++i) {
                characters[i] = pattern.length;
            }
            for (i = 0; i < pattern.length - 1; ++i) {
                characters[pattern[i] - min] = pattern.length - i - 1;
            }
            return characters;
        }

        @Override
        public int getShift(char c) {
            if (c < this.minChar || c > this.maxChar) {
                return this.defaultShift;
            }
            return this.characterShift[c - this.minChar];
        }
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private boolean relaxed;

        public Factory() {
            this(false);
        }

        public Factory(boolean relaxed) {
            this.relaxed = relaxed;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new Horspool(pattern, this.relaxed);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
        }

        @Override
        public StringMatch findNext() {
            int lookahead = Horspool.this.patternLength - 1;
            block0: while (!this.chars.finished(lookahead)) {
                int patternPointer = lookahead;
                char nextChar = this.chars.lookahead(patternPointer);
                if (Horspool.this.pattern[patternPointer] == nextChar) {
                    while (patternPointer > 0) {
                        if (Horspool.this.pattern[--patternPointer] == this.chars.lookahead(patternPointer)) continue;
                        this.chars.forward(Horspool.this.charShift.getShift(nextChar));
                        continue block0;
                    }
                    if (patternPointer != 0) continue;
                    StringMatch match = this.createMatch();
                    this.chars.forward(Horspool.this.charShift.getShift(nextChar));
                    return match;
                }
                this.chars.forward(Horspool.this.charShift.getShift(nextChar));
            }
            return null;
        }

        private StringMatch createMatch() {
            long start = this.chars.current();
            long end = start + (long)Horspool.this.patternLength;
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

