/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.io;

import java.io.IOException;
import java.io.Reader;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.io.IORuntimeException;
import net.amygdalum.stringsearchalgorithms.io.OutOfBufferException;

public class ReaderCharProvider
implements CharProvider {
    private static final long NO_MARK = Long.MIN_VALUE;
    private Reader input;
    private int bufferSize;
    private int bufferNumber;
    private char[][] buffers;
    private int currentIndex;
    private int currentPos;
    private int topIndex;
    private int topPos;
    private long absolutePos;
    private long mark;

    public ReaderCharProvider(Reader input, long start, int chunk, int lookaroundBuffers) {
        this.input = input;
        this.bufferSize = chunk;
        this.bufferNumber = lookaroundBuffers + 1;
        this.buffers = new char[this.bufferNumber][this.bufferSize];
        this.currentIndex = -1;
        this.currentPos = 0;
        this.topIndex = -1;
        this.topPos = 0;
        this.mark = Long.MIN_VALUE;
        this.init(start);
    }

    public final void init(long start) {
        int buffersToRead = (int)(start / (long)this.bufferSize) + 1;
        this.read(buffersToRead);
        this.currentIndex = this.topIndex;
        this.currentPos = (int)(start % (long)this.bufferSize);
        this.absolutePos = start;
    }

    private int read(int buffersToRead) {
        if (buffersToRead <= 0) {
            return 0;
        }
        try {
            int freeBuffers;
            int buffersToShift;
            int buffersAlreadyRead = this.topIndex - this.currentIndex;
            for (int i = 0; i < buffersAlreadyRead; ++i) {
                --buffersToRead;
            }
            int buffersToSkip = buffersToRead - this.bufferNumber;
            if (buffersToSkip > 0) {
                for (int i = 0; i < buffersToSkip; ++i) {
                    this.topPos = this.input.read(this.buffers[0]);
                    --buffersToRead;
                }
                this.topIndex = -1;
                this.currentIndex = -1;
            }
            if ((buffersToShift = buffersToRead - (freeBuffers = this.bufferNumber - this.currentIndex - 1)) > 0) {
                int lastIndexToReplace = this.bufferNumber - buffersToShift;
                for (int i = 0; i < lastIndexToReplace; ++i) {
                    char[] temp = this.buffers[i];
                    this.buffers[i] = this.buffers[i + buffersToShift];
                    this.buffers[i + buffersToShift] = temp;
                }
                this.topIndex -= buffersToShift;
            }
            while (buffersToRead > 0) {
                ++this.topIndex;
                this.topPos = this.input.read(this.buffers[this.topIndex]);
                --buffersToRead;
                if (this.topPos >= this.bufferSize) continue;
            }
            if (buffersToRead > 0) {
                throw new OutOfBufferException();
            }
            if (buffersToSkip > 0) {
                return buffersToSkip + this.bufferNumber;
            }
            if (buffersToShift > 0) {
                return buffersToShift;
            }
            return 0;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private int readAhead(int buffersToRead) {
        if (buffersToRead <= 0) {
            return 0;
        }
        try {
            int freeBuffers = this.bufferNumber - this.topIndex - 1;
            int buffersToShift = buffersToRead - freeBuffers;
            if (buffersToShift > this.currentIndex) {
                throw new OutOfBufferException();
            }
            if (buffersToShift > 0) {
                int lastIndexToReplace = this.bufferNumber - buffersToShift;
                for (int i = 0; i < lastIndexToReplace; ++i) {
                    char[] temp = this.buffers[i];
                    this.buffers[i] = this.buffers[i + buffersToShift];
                    this.buffers[i + buffersToShift] = temp;
                }
                this.currentIndex -= buffersToShift;
                this.topIndex -= buffersToShift;
            }
            while (buffersToRead > 0) {
                ++this.topIndex;
                this.topPos = this.input.read(this.buffers[this.topIndex]);
                --buffersToRead;
                if (this.topPos >= this.bufferSize) continue;
            }
            if (buffersToRead > 0) {
                throw new OutOfBufferException();
            }
            return buffersToShift;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public char next() {
        int expectedIndex = this.currentIndex;
        while (this.currentPos >= this.bufferSize) {
            this.currentPos -= this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex <= this.topIndex) {
            this.currentIndex = expectedIndex;
        } else {
            int indexShift = this.read(expectedIndex - this.topIndex);
            this.currentIndex = expectedIndex - indexShift;
        }
        char c = this.buffers[this.currentIndex][this.currentPos];
        ++this.currentPos;
        ++this.absolutePos;
        return c;
    }

    @Override
    public char lookahead() {
        return this.lookahead(0);
    }

    @Override
    public char lookahead(int pos) {
        int expectedPos = this.currentPos + pos;
        int expectedIndex = this.currentIndex;
        while (expectedPos < 0) {
            expectedPos += this.bufferSize;
            --expectedIndex;
        }
        while (expectedPos >= this.bufferSize) {
            expectedPos -= this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        if (expectedIndex > this.topIndex) {
            int indexShift = this.readAhead(expectedIndex - this.topIndex);
            expectedIndex -= indexShift;
        }
        return this.buffers[expectedIndex][expectedPos];
    }

    @Override
    public char prev() {
        int expectedIndex;
        --this.currentPos;
        --this.absolutePos;
        for (expectedIndex = this.currentIndex; this.currentPos < 0 && expectedIndex > -1; --expectedIndex) {
            this.currentPos += this.bufferSize;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        this.currentIndex = expectedIndex;
        char c = this.buffers[this.currentIndex][this.currentPos];
        return c;
    }

    @Override
    public char lookbehind() {
        return this.lookbehind(0);
    }

    @Override
    public char lookbehind(int pos) {
        int expectedPos = this.currentPos - 1 - pos;
        int expectedIndex = this.currentIndex;
        while (expectedPos < 0) {
            expectedPos += this.bufferSize;
            --expectedIndex;
        }
        while (expectedPos >= this.bufferSize) {
            expectedPos -= this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        if (expectedIndex > this.topIndex) {
            int indexShift = this.readAhead(expectedIndex - this.topIndex);
            expectedIndex -= indexShift;
        }
        return this.buffers[expectedIndex][expectedPos];
    }

    @Override
    public long current() {
        return this.absolutePos;
    }

    @Override
    public void move(long pos) {
        long relativePos = pos - this.absolutePos;
        long expectedPos = (long)this.currentPos + relativePos;
        int expectedIndex = this.currentIndex;
        while (expectedPos < 0L) {
            expectedPos += (long)this.bufferSize;
            --expectedIndex;
        }
        while (expectedPos >= (long)this.bufferSize) {
            expectedPos -= (long)this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        if (relativePos > 0L) {
            int buffersToRead = expectedIndex - this.topIndex;
            int indexShift = this.read(buffersToRead);
            this.currentIndex = expectedIndex - indexShift;
            this.currentPos = (int)expectedPos;
            this.absolutePos = pos;
        } else {
            this.currentIndex = expectedIndex;
            this.currentPos = (int)expectedPos;
            this.absolutePos = pos;
        }
    }

    @Override
    public void forward(int i) {
        this.move(this.absolutePos + (long)i);
    }

    @Override
    public void finish() {
        try {
            this.topPos = -1;
            this.currentIndex = this.topIndex;
            this.input.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public boolean finished() {
        return this.finished(0);
    }

    @Override
    public boolean finished(int i) {
        int indexShift;
        int expectedPos = this.currentPos + i;
        int expectedIndex = this.currentIndex;
        while (expectedPos > this.bufferSize) {
            expectedPos -= this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex > this.topIndex) {
            indexShift = this.readAhead(expectedIndex - this.topIndex);
            expectedIndex -= indexShift;
        }
        if (expectedIndex == this.topIndex && expectedPos == this.topPos && this.topPos == this.bufferSize) {
            indexShift = this.readAhead(1);
            expectedIndex -= indexShift;
        }
        if (this.topPos == -1 && expectedIndex >= this.topIndex) {
            return true;
        }
        return this.topPos == -1 && expectedIndex == this.topIndex - 1 && expectedPos == this.bufferSize;
    }

    @Override
    public char at(long pos) {
        long relativePos = pos - this.absolutePos;
        long expectedPos = (long)this.currentPos + relativePos;
        int expectedIndex = this.currentIndex;
        while (expectedPos < 0L) {
            expectedPos += (long)this.bufferSize;
            --expectedIndex;
        }
        while (expectedPos >= (long)this.bufferSize) {
            expectedPos -= (long)this.bufferSize;
            ++expectedIndex;
        }
        if (expectedIndex < 0) {
            throw new OutOfBufferException();
        }
        if (expectedIndex > this.topIndex) {
            int indexShift = this.readAhead(expectedIndex - this.topIndex);
            expectedIndex -= indexShift;
        }
        return this.buffers[expectedIndex][(int)expectedPos];
    }

    @Override
    public char[] between(long start, long end) {
        long len = end - start;
        if (len / (long)this.bufferSize > (long)this.bufferNumber) {
            throw new OutOfBufferException();
        }
        long relativeStart = start - this.absolutePos;
        long expectedStartPos = (long)this.currentPos + relativeStart;
        int expectedStartIndex = this.currentIndex;
        while (expectedStartPos < 0L) {
            expectedStartPos += (long)this.bufferSize;
            --expectedStartIndex;
        }
        while (expectedStartPos >= (long)this.bufferSize) {
            expectedStartPos -= (long)this.bufferSize;
            ++expectedStartIndex;
        }
        long relativeEnd = end - this.absolutePos;
        long expectedEndPos = (long)this.currentPos + relativeEnd;
        int expectedEndIndex = this.currentIndex;
        while (expectedEndPos <= 0L) {
            expectedEndPos += (long)this.bufferSize;
            --expectedEndIndex;
        }
        while (expectedEndPos > (long)this.bufferSize) {
            expectedEndPos -= (long)this.bufferSize;
            ++expectedEndIndex;
        }
        if (expectedStartIndex < 0 || expectedEndIndex < 0) {
            throw new OutOfBufferException();
        }
        if (expectedEndIndex - expectedStartIndex >= this.bufferNumber) {
            throw new OutOfBufferException();
        }
        if (expectedEndIndex > this.topIndex) {
            int indexShift = this.readAhead(expectedEndIndex - this.topIndex);
            expectedStartIndex -= indexShift;
            expectedEndIndex -= indexShift;
        }
        int betweenLen = (int)len;
        char[] between = new char[betweenLen];
        if (betweenLen != 0) {
            if (expectedStartIndex == expectedEndIndex) {
                System.arraycopy(this.buffers[expectedStartIndex], (int)expectedStartPos, between, 0, (int)(expectedEndPos - expectedStartPos));
            } else {
                int to = 0;
                System.arraycopy(this.buffers[expectedStartIndex], (int)expectedStartPos, between, to, (int)((long)this.bufferSize - expectedStartPos));
                to = (int)((long)to + ((long)this.bufferSize - expectedStartPos));
                for (int i = expectedStartIndex + 1; i < expectedEndIndex; ++i) {
                    System.arraycopy(this.buffers[i], 0, between, to, this.bufferSize);
                    to += this.bufferSize;
                }
                System.arraycopy(this.buffers[expectedEndIndex], 0, between, to, (int)expectedEndPos);
                to = (int)((long)to + expectedEndPos);
            }
        }
        return between;
    }

    @Override
    public String slice(long start, long end) {
        return new String(this.between(start, end));
    }

    @Override
    public void mark() {
        this.mark = this.absolutePos;
    }

    @Override
    public boolean changed() {
        boolean changed = this.mark != Long.MIN_VALUE && this.mark != this.absolutePos;
        this.mark = Long.MIN_VALUE;
        return changed;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("...");
        if (this.currentIndex > 0) {
            buffer.append(this.buffers[this.currentIndex - 1]);
        }
        buffer.append(this.buffers[this.currentIndex], 0, this.currentPos);
        buffer.append('|');
        if (this.topIndex > this.currentIndex) {
            buffer.append(this.buffers[this.currentIndex], this.currentPos, this.bufferSize - this.currentPos);
        } else if (this.topPos > this.currentPos) {
            buffer.append(this.buffers[this.currentIndex], this.currentPos, this.topPos - this.currentPos);
        }
        return buffer.toString();
    }
}

