/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.io;

import net.amygdalum.stringsearchalgorithms.io.CharProvider;

public class StringCharProvider
implements CharProvider {
    private static final int NO_MARK = -1;
    private String input;
    private int pos;
    private int mark;

    public StringCharProvider(String input, int start) {
        this.input = input;
        this.pos = start;
        this.mark = -1;
    }

    public void restart() {
        this.pos = 0;
    }

    @Override
    public void finish() {
        this.pos = this.input.length();
    }

    @Override
    public char next() {
        char c = this.input.charAt(this.pos);
        ++this.pos;
        return c;
    }

    @Override
    public char lookahead() {
        return this.input.charAt(this.pos);
    }

    @Override
    public char lookahead(int i) {
        return this.input.charAt(this.pos + i);
    }

    @Override
    public char prev() {
        --this.pos;
        return this.input.charAt(this.pos);
    }

    @Override
    public char lookbehind() {
        return this.input.charAt(this.pos - 1);
    }

    @Override
    public char lookbehind(int i) {
        return this.input.charAt(this.pos - 1 - i);
    }

    @Override
    public long current() {
        return this.pos;
    }

    @Override
    public void move(long i) {
        this.pos = (int)i;
    }

    @Override
    public void forward(int i) {
        this.pos += i;
    }

    @Override
    public boolean finished() {
        return this.pos >= this.input.length();
    }

    @Override
    public boolean finished(int i) {
        return this.pos + i >= this.input.length();
    }

    @Override
    public char at(long i) {
        return this.input.charAt((int)i);
    }

    @Override
    public char[] between(long start, long end) {
        char[] between = new char[(int)(end - start)];
        this.input.getChars((int)start, (int)end, between, 0);
        return between;
    }

    @Override
    public String slice(long start, long end) {
        return this.input.substring((int)start, (int)end);
    }

    public String toString() {
        return this.input.substring(0, this.pos) + '|' + this.input.substring(this.pos);
    }

    @Override
    public void mark() {
        this.mark = this.pos;
    }

    @Override
    public boolean changed() {
        boolean changed = this.mark != -1 && this.mark != this.pos;
        this.mark = -1;
        return changed;
    }
}

