/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.DualGlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzerOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.regex.AlternativesNode;
import net.amygdalum.stringsearchalgorithms.regex.AnyCharNode;
import net.amygdalum.stringsearchalgorithms.regex.BoundedLoopNode;
import net.amygdalum.stringsearchalgorithms.regex.CharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.CompClassNode;
import net.amygdalum.stringsearchalgorithms.regex.ConcatNode;
import net.amygdalum.stringsearchalgorithms.regex.DefinedCharNode;
import net.amygdalum.stringsearchalgorithms.regex.EmptyNode;
import net.amygdalum.stringsearchalgorithms.regex.GroupNode;
import net.amygdalum.stringsearchalgorithms.regex.OptionalNode;
import net.amygdalum.stringsearchalgorithms.regex.RangeCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;
import net.amygdalum.stringsearchalgorithms.regex.SingleCharNode;
import net.amygdalum.stringsearchalgorithms.regex.SpecialCharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.StringNode;
import net.amygdalum.stringsearchalgorithms.regex.UnboundedLoopNode;
import net.amygdalum.util.map.BitSetObjectMap;
import net.amygdalum.util.map.CharObjectMap;

public class GlushkovAnalyzer
implements RegexNodeVisitor<Void> {
    private RegexNode root;
    private List<DefinedCharNode> charCollector;
    private Map<RegexNode, Set<Integer>> first;
    private Map<RegexNode, Set<Integer>> last;
    private Map<Integer, Set<Integer>> follow;
    private Map<Integer, Set<Integer>> precede;
    private Map<RegexNode, Integer> minLength;
    private DefinedCharNode[] chars;
    private int len;
    private char[] alphabet;

    public GlushkovAnalyzer(RegexNode root) {
        this.root = root;
        this.first = new LinkedHashMap<RegexNode, Set<Integer>>();
        this.last = new LinkedHashMap<RegexNode, Set<Integer>>();
        this.follow = new LinkedHashMap<Integer, Set<Integer>>();
        this.precede = new LinkedHashMap<Integer, Set<Integer>>();
        this.minLength = new LinkedHashMap<RegexNode, Integer>();
        this.charCollector = new ArrayList<DefinedCharNode>();
        this.charCollector.add(null);
    }

    private DefinedCharNode[] characters() {
        return this.charCollector.toArray(new DefinedCharNode[0]);
    }

    private char[] alphabet() {
        LinkedHashSet<Character> distinctChars = new LinkedHashSet<Character>();
        for (DefinedCharNode node : this.charCollector) {
            if (node == null) continue;
            for (char c : node.chars()) {
                distinctChars.add(Character.valueOf(c));
            }
        }
        char[] alphabet = new char[distinctChars.size()];
        int i = 0;
        Object object = distinctChars.iterator();
        while (object.hasNext()) {
            Character c = (Character)object.next();
            alphabet[i] = c.charValue();
            ++i;
        }
        return alphabet;
    }

    public Set<Character> firstChars() {
        LinkedHashSet<Character> firstChars = new LinkedHashSet<Character>();
        for (int index : this.first(this.root)) {
            for (char c : this.chars[index].chars()) {
                firstChars.add(Character.valueOf(c));
            }
        }
        return firstChars;
    }

    public Set<Character> lastChars() {
        LinkedHashSet<Character> lastChars = new LinkedHashSet<Character>();
        for (int index : this.last(this.root)) {
            for (char c : this.chars[index].chars()) {
                lastChars.add(Character.valueOf(c));
            }
        }
        return lastChars;
    }

    private void first(RegexNode node, Integer ... value) {
        this.first(node, new LinkedHashSet<Integer>(Arrays.asList(value)));
    }

    private void first(RegexNode node, Set<Integer> value) {
        this.first.put(node, value);
    }

    private Set<Integer> first(RegexNode node) {
        return this.first.get(node);
    }

    private List<Set<Integer>> first(List<RegexNode> nodes) {
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>(nodes.size());
        for (RegexNode node : nodes) {
            result.add(this.first(node));
        }
        return result;
    }

    private void last(RegexNode node, Integer ... value) {
        this.last(node, new LinkedHashSet<Integer>(Arrays.asList(value)));
    }

    private void last(RegexNode node, Set<Integer> value) {
        this.last.put(node, value);
    }

    private Set<Integer> last(RegexNode node) {
        return this.last.get(node);
    }

    private List<Set<Integer>> last(List<RegexNode> nodes) {
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>(nodes.size());
        for (RegexNode node : nodes) {
            result.add(this.last(node));
        }
        return result;
    }

    private void appendFollow(int key, Collection<Integer> append) {
        Set<Integer> followSet = this.follow.get(key);
        if (followSet == null) {
            followSet = new LinkedHashSet<Integer>();
            this.follow.put(key, followSet);
        }
        followSet.addAll(append);
    }

    private Set<Integer> follow(Integer i) {
        Set<Integer> set = this.follow.get(i);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    private void appendPrecede(int key, Collection<Integer> append) {
        Set<Integer> precedeSet = this.precede.get(key);
        if (precedeSet == null) {
            precedeSet = new LinkedHashSet<Integer>();
            this.precede.put(key, precedeSet);
        }
        precedeSet.addAll(append);
    }

    private Set<Integer> precede(Integer i) {
        Set<Integer> set = this.precede.get(i);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    private void minLength(RegexNode node, Integer value) {
        this.minLength.put(node, value);
    }

    private List<Integer> minLength(List<RegexNode> nodes) {
        ArrayList<Integer> result = new ArrayList<Integer>(nodes.size());
        for (RegexNode node : nodes) {
            result.add(this.minLength(node));
        }
        return result;
    }

    private Integer minLength(RegexNode node) {
        return this.minLength.get(node);
    }

    public GlushkovAnalyzer analyze() {
        this.root.accept(this);
        this.appendFollow(0, this.first(this.root));
        for (int f : this.first(this.root)) {
            this.appendPrecede(f, Arrays.asList(0));
        }
        this.chars = this.characters();
        this.len = this.chars.length;
        this.alphabet = this.alphabet();
        return this;
    }

    public GlushkovAutomaton buildAutomaton(GlushkovAnalyzerOption ... options) {
        BitSet initial = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.initial();
        BitSet finals = this.finals();
        CharObjectMap<BitSet> reachableByChar = this.reachableByChar(options);
        BitSetObjectMap<BitSet> reachableByState = this.reachableByState(reachableByChar, options);
        return new GlushkovAutomaton(initial, finals, reachableByChar, reachableByState);
    }

    public DualGlushkovAutomaton buildReverseAutomaton(GlushkovAnalyzerOption ... options) {
        BitSet initial = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.finals();
        BitSet finals = this.initial();
        CharObjectMap<BitSet> reachableByChar = this.reachableByChar(options);
        BitSetObjectMap<BitSet> reachableByState = this.sourceableByState(reachableByChar, options);
        return new DualGlushkovAutomaton(initial, finals, reachableByChar, reachableByState);
    }

    public int minLength() {
        return this.minLength(this.root);
    }

    private BitSet initial() {
        BitSet initial = new BitSet(this.len);
        initial.set(0);
        return initial;
    }

    private CharObjectMap<BitSet> reachableByChar(GlushkovAnalyzerOption ... options) {
        BitSet defaultValue = GlushkovAnalyzerOption.SELF_LOOP.in(options) ? this.initial() : new BitSet(this.len);
        CharObjectMap<BitSet> reachable = new CharObjectMap<BitSet>(defaultValue);
        for (int i = 1; i < this.len; ++i) {
            for (char c : this.chars[i].chars()) {
                BitSet b = reachable.get(c);
                if (b == defaultValue) {
                    b = (BitSet)defaultValue.clone();
                    reachable.put(c, b);
                }
                b.set(i);
            }
        }
        return reachable;
    }

    private BitSetObjectMap<BitSet> reachableByState(CharObjectMap<BitSet> reachableByChar, GlushkovAnalyzerOption ... options) {
        BitSet defaultValue = GlushkovAnalyzerOption.SELF_LOOP.in(options) ? this.initial() : new BitSet(this.len);
        BitSet start = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.initial();
        BitSetObjectMap<BitSet> reachable = new BitSetObjectMap<BitSet>(defaultValue);
        this.reachableByState(start, reachable, reachableByChar, defaultValue);
        return reachable;
    }

    private void reachableByState(BitSet d, BitSetObjectMap<BitSet> reachable, CharObjectMap<BitSet> reachableByChar, BitSet defaultValue) {
        BitSet td = reachable.get(d);
        if (td == defaultValue) {
            td = (BitSet)defaultValue.clone();
            reachable.put(d, td);
        }
        for (int i = 0; i < this.len; ++i) {
            if (!d.get(i)) continue;
            td.or(this.bits(this.len, this.follow(i)));
        }
        BitSet n = (BitSet)td.clone();
        for (char c : this.alphabet) {
            BitSet next = this.and(n, reachableByChar.get(c));
            if (reachable.get(next) != defaultValue) continue;
            this.reachableByState(next, reachable, reachableByChar, defaultValue);
        }
    }

    private BitSetObjectMap<BitSet> sourceableByState(CharObjectMap<BitSet> reachableByChar, GlushkovAnalyzerOption ... options) {
        BitSet defaultValue = GlushkovAnalyzerOption.SELF_LOOP.in(options) ? this.finals() : new BitSet(this.len);
        BitSet start = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.finals();
        BitSetObjectMap<BitSet> sourceable = new BitSetObjectMap<BitSet>(defaultValue);
        List<BitSet> allFinals = this.allFinals(start, reachableByChar, options);
        for (BitSet finals : allFinals) {
            this.sourceableByState(finals, this.len, sourceable, reachableByChar, defaultValue);
        }
        return sourceable;
    }

    private List<BitSet> allFinals(BitSet initial, CharObjectMap<BitSet> reachableByChar, GlushkovAnalyzerOption ... options) {
        BitSet start = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.initial();
        BitSet defaultValue = GlushkovAnalyzerOption.SELF_LOOP.in(options) ? this.initial() : new BitSet(this.len);
        Collection<BitSet> possible = this.possibleStartsByState(start, reachableByChar, defaultValue);
        return this.filterPossiblesStartsByChar(initial, reachableByChar, possible);
    }

    private Collection<BitSet> possibleStartsByState(BitSet next, CharObjectMap<BitSet> reachableByChar, BitSet defaultValue) {
        LinkedHashMap<BitSet, BitSet> possible = new LinkedHashMap<BitSet, BitSet>();
        this.possibleStartsByState(possible, next, reachableByChar, defaultValue);
        return possible.values();
    }

    private void possibleStartsByState(Map<BitSet, BitSet> possible, BitSet next, CharObjectMap<BitSet> reachableByChar, BitSet defaultValue) {
        if (possible.get(next) == null) {
            this.possibleStartsByState(next, possible, reachableByChar, defaultValue);
        }
        if (possible.get(next = this.or(next, this.initial())) == null) {
            this.possibleStartsByState(next, possible, reachableByChar, defaultValue);
        }
    }

    private void possibleStartsByState(BitSet d, Map<BitSet, BitSet> possible, CharObjectMap<BitSet> reachableByChar, BitSet defaultValue) {
        BitSet td = possible.get(d);
        if (td == null) {
            td = (BitSet)defaultValue.clone();
            possible.put(d, td);
        }
        for (int i = 0; i < this.len; ++i) {
            if (!d.get(i)) continue;
            td.or(this.bits(this.len, this.follow(i)));
        }
        BitSet n = (BitSet)td.clone();
        for (char c : this.alphabet) {
            BitSet next = this.and(n, reachableByChar.get(c));
            this.possibleStartsByState(possible, next, reachableByChar, defaultValue);
        }
    }

    private List<BitSet> filterPossiblesStartsByChar(BitSet initial, CharObjectMap<BitSet> reachableByChar, Collection<BitSet> possible) {
        LinkedHashSet<BitSet> filteredPossible = new LinkedHashSet<BitSet>();
        for (BitSet value : possible) {
            BitSet finalValue = (BitSet)initial.clone();
            finalValue.and(value);
            for (char c : this.alphabet) {
                BitSet charFilter = reachableByChar.get(c);
                BitSet state = this.and(finalValue, charFilter);
                if (state.isEmpty()) continue;
                filteredPossible.add(state);
            }
        }
        return new ArrayList<BitSet>(filteredPossible);
    }

    private void sourceableByState(BitSet d, int len, BitSetObjectMap<BitSet> sourceable, CharObjectMap<BitSet> reachableByChar, BitSet defaultValue) {
        BitSet td = sourceable.get(d);
        if (td == defaultValue) {
            td = (BitSet)defaultValue.clone();
            sourceable.put(d, td);
        }
        for (int i = 0; i < len; ++i) {
            if (!d.get(i)) continue;
            td.or(this.bits(len, this.precede(i)));
        }
        BitSet n = (BitSet)td.clone();
        for (char c : this.alphabet) {
            BitSet next = this.and(n, reachableByChar.get(c));
            if (sourceable.get(next) != defaultValue) continue;
            this.sourceableByState(next, len, sourceable, reachableByChar, defaultValue);
        }
    }

    private BitSet bits(int len, Set<Integer> ints) {
        BitSet bits = new BitSet(len);
        for (int i : ints) {
            bits.set(i);
        }
        return bits;
    }

    private BitSet finals() {
        BitSet finals = new BitSet(this.len);
        for (int x : this.last(this.root)) {
            finals.set(x);
        }
        if (this.minLength.get(this.root) == 0) {
            finals.set(0);
        }
        return finals;
    }

    private BitSet all() {
        BitSet all = new BitSet(this.len);
        all.flip(0, this.len);
        return all;
    }

    @Override
    public Void visitAlternatives(AlternativesNode node) {
        List<RegexNode> subNodes = node.getSubNodes();
        for (RegexNode subNode : subNodes) {
            subNode.accept(this);
        }
        this.first((RegexNode)node, this.union(this.first(subNodes)));
        this.last((RegexNode)node, this.union(this.last(subNodes)));
        this.minLength(node, this.minimum(this.minLength(subNodes)));
        return null;
    }

    @Override
    public Void visitAnyChar(AnyCharNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain char classes");
    }

    @Override
    public Void visitCharClass(CharClassNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain char classes");
    }

    @Override
    public Void visitCompClass(CompClassNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain char classes");
    }

    @Override
    public Void visitConcat(ConcatNode node) {
        List<RegexNode> subNodes = node.getSubNodes();
        for (RegexNode subNode : subNodes) {
            subNode.accept(this);
        }
        this.first((RegexNode)node, this.union(this.concatFirst(subNodes)));
        this.last((RegexNode)node, this.union(this.concatLast(subNodes)));
        this.minLength(node, this.sum(this.minLength(subNodes)));
        for (int i = 0; i < subNodes.size() - 1; ++i) {
            RegexNode current = subNodes.get(i);
            RegexNode next = subNodes.get(i + 1);
            for (int x : this.last(current)) {
                this.appendFollow(x, this.first(next));
            }
            for (int y : this.first(next)) {
                this.appendPrecede(y, this.last(current));
            }
        }
        return null;
    }

    private List<Set<Integer>> concatFirst(List<RegexNode> subNodes) {
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>();
        int minLength = 0;
        for (RegexNode subNode : subNodes) {
            if (minLength > 0) break;
            result.add(this.first(subNode));
            minLength += this.minLength(subNode).intValue();
        }
        return result;
    }

    private List<Set<Integer>> concatLast(List<RegexNode> subNodes) {
        ArrayList<RegexNode> reverseSubNodes = new ArrayList<RegexNode>(subNodes);
        Collections.reverse(reverseSubNodes);
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>();
        int minLength = 0;
        for (RegexNode subNode : reverseSubNodes) {
            if (minLength > 0) break;
            result.add(this.last(subNode));
            minLength += this.minLength(subNode).intValue();
        }
        return result;
    }

    @Override
    public Void visitEmpty(EmptyNode node) {
        this.first((RegexNode)node, new HashSet<Integer>());
        this.last((RegexNode)node, new HashSet<Integer>());
        this.minLength(node, 0);
        return null;
    }

    @Override
    public Void visitGroup(GroupNode node) {
        RegexNode subNode = node.getSubNode();
        subNode.accept(this);
        this.first((RegexNode)node, this.first(subNode));
        this.last((RegexNode)node, this.last(subNode));
        this.minLength(node, this.minLength(subNode));
        return null;
    }

    @Override
    public Void visitBoundedLoop(BoundedLoopNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain bounded loops");
    }

    @Override
    public Void visitUnboundedLoop(UnboundedLoopNode node) {
        if (node.getFrom() > 0) {
            throw new UnsupportedOperationException("decomposed normal from does not contain plus loops");
        }
        RegexNode subNode = node.getSubNode();
        subNode.accept(this);
        this.first((RegexNode)node, this.first(subNode));
        this.last((RegexNode)node, this.last(subNode));
        this.minLength(node, 0);
        RegexNode current = subNode;
        RegexNode next = subNode;
        for (int x : this.last(current)) {
            this.appendFollow(x, this.first(next));
        }
        for (int y : this.first(next)) {
            this.appendPrecede(y, this.last(current));
        }
        return null;
    }

    @Override
    public Void visitOptional(OptionalNode node) {
        RegexNode subNode = node.getSubNode();
        subNode.accept(this);
        this.first((RegexNode)node, this.first(subNode));
        this.last((RegexNode)node, this.last(subNode));
        this.minLength(node, 0);
        return null;
    }

    @Override
    public Void visitRangeChar(RangeCharNode node) {
        int pos = this.charCollector.size();
        this.charCollector.add(node);
        this.first((RegexNode)node, pos);
        this.last((RegexNode)node, pos);
        this.minLength(node, 1);
        return null;
    }

    @Override
    public Void visitSingleChar(SingleCharNode node) {
        int pos = this.charCollector.size();
        this.charCollector.add(node);
        this.first((RegexNode)node, pos);
        this.last((RegexNode)node, pos);
        this.minLength(node, 1);
        return null;
    }

    @Override
    public Void visitSpecialCharClass(SpecialCharClassNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain char classes");
    }

    @Override
    public Void visitString(StringNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain strings");
    }

    private Set<Integer> union(List<Set<Integer>> values) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Set<Integer> value : values) {
            result.addAll(value);
        }
        return result;
    }

    private Integer minimum(List<Integer> values) {
        int min = Integer.MAX_VALUE;
        for (Integer value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private Integer sum(List<Integer> values) {
        int sum = 0;
        for (Integer value : values) {
            sum += value.intValue();
        }
        return sum;
    }

    private BitSet and(BitSet b1, BitSet b2) {
        BitSet bitSet = (BitSet)b1.clone();
        bitSet.and(b2);
        return bitSet;
    }

    private BitSet or(BitSet b1, BitSet b2) {
        BitSet bitSet = (BitSet)b1.clone();
        bitSet.or(b2);
        return bitSet;
    }
}

