/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.regex.CharNode;
import net.amygdalum.stringsearchalgorithms.regex.DefinedCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RangeCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;
import net.amygdalum.stringsearchalgorithms.regex.SingleCharNode;

public class AnyCharNode
extends CharNode {
    private static final DefinedCharNode DOTALL = new RangeCharNode('\u0000', '\uffff');
    private List<DefinedCharNode> charNodes;

    private AnyCharNode(DefinedCharNode ... charNodes) {
        this(Arrays.asList(charNodes));
    }

    private AnyCharNode(List<DefinedCharNode> charNodes) {
        this.charNodes = charNodes;
    }

    public static AnyCharNode dotAll(char min, char max) {
        return new AnyCharNode(DOTALL);
    }

    public static AnyCharNode dotDefault(char min, char max) {
        return new AnyCharNode(AnyCharNode.computeDefault(min, max));
    }

    private static DefinedCharNode[] computeDefault(char min, char max) {
        return AnyCharNode.computeComplement(Arrays.asList(new SingleCharNode('\n'), new SingleCharNode('\r'), new SingleCharNode('\u0085'), new RangeCharNode('\u2028', '\u2029')), min, max).toArray(new DefinedCharNode[0]);
    }

    @Override
    public List<DefinedCharNode> toCharNodes() {
        return this.charNodes;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitAnyChar(this);
    }

    @Override
    public AnyCharNode clone() {
        return (AnyCharNode)super.clone();
    }

    public String toString() {
        return ".";
    }
}

