/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.LinkedHashMap;
import java.util.Map;
import net.amygdalum.stringsearchalgorithms.regex.CharNode;
import net.amygdalum.stringsearchalgorithms.regex.SpecialCharClassNode;

public class CharClassBuilder {
    private char min;
    private char max;
    private Map<Character, CharNode> charClasses = new LinkedHashMap<Character, CharNode>();

    public CharClassBuilder(char min, char max) {
        this.min = min;
        this.max = max;
    }

    public CharClassBuilder add(char symbol, CharNode node) {
        this.charClasses.put(Character.valueOf(symbol), node);
        return this;
    }

    public CharClassBuilder add(SpecialCharClassNode specialCharClass) {
        this.charClasses.put(Character.valueOf(specialCharClass.getSymbol()), specialCharClass);
        SpecialCharClassNode invertedCharClass = specialCharClass.invert(this.min, this.max);
        this.charClasses.put(Character.valueOf(invertedCharClass.getSymbol()), invertedCharClass);
        return this;
    }

    public Map<Character, CharNode> build() {
        return this.charClasses;
    }
}

