/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;

public abstract class BufferedStringFinder
extends AbstractStringFinder {
    private Queue<StringMatch> buffer = new PriorityQueue<StringMatch>();

    public BufferedStringFinder(StringFinderOption ... options) {
        super(options);
    }

    protected void push(StringMatch match) {
        this.buffer.add(match);
    }

    protected void push(Collection<StringMatch> matches) {
        this.buffer.addAll(matches);
    }

    protected void clear() {
        this.buffer.clear();
    }

    protected boolean isBufferEmpty() {
        return this.buffer.isEmpty();
    }

    protected long removeMatchesBefore(long pos) {
        long last = pos;
        Iterator bufferIterator = this.buffer.iterator();
        while (bufferIterator.hasNext()) {
            StringMatch next = (StringMatch)bufferIterator.next();
            if (next.start() < pos) {
                bufferIterator.remove();
                continue;
            }
            if (next.end() <= last) continue;
            last = next.end();
        }
        return last;
    }

    protected StringMatch leftMost() {
        StringMatch nextMatch;
        if (this.buffer.isEmpty()) {
            return null;
        }
        StringMatch match = this.buffer.remove();
        while (!this.buffer.isEmpty() && (nextMatch = this.buffer.peek()).start() == match.start() && nextMatch.end() == match.end()) {
            match = this.buffer.remove();
        }
        return match;
    }

    protected StringMatch longestLeftMost() {
        if (this.buffer.isEmpty()) {
            return null;
        }
        StringMatch match = this.buffer.remove();
        while (!this.buffer.isEmpty()) {
            StringMatch nextMatch = this.buffer.peek();
            if (nextMatch.start() == match.start()) {
                match = this.buffer.remove();
                continue;
            }
            if (nextMatch.end() > match.end()) break;
            this.buffer.remove();
        }
        return match;
    }

    protected long lastStartFromBuffer() {
        long start = Long.MAX_VALUE;
        for (StringMatch next : this.buffer) {
            if (next.start() >= start) continue;
            start = next.start();
        }
        if (start == Long.MAX_VALUE) {
            return -1L;
        }
        return start;
    }
}

