/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.TrieNode;
import net.amygdalum.util.map.ByteObjectMap;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.StringUtils;

public class AhoCorasick
implements StringSearchAlgorithm {
    private TrieNode<ByteString> trie;
    private int minLength;

    public AhoCorasick(Collection<String> patterns, Charset charset) {
        List<byte[]> bytepatterns = StringUtils.toByteArray(patterns, charset);
        this.trie = AhoCorasick.computeTrie(bytepatterns, charset);
        this.minLength = ByteUtils.minLength(bytepatterns);
    }

    private static TrieNode<ByteString> computeTrie(List<byte[]> bytepatterns, Charset charset) {
        TrieNode<ByteString> trie = new TrieNode<ByteString>();
        for (byte[] pattern : bytepatterns) {
            trie.extend(pattern, new ByteString(pattern, charset));
        }
        return AhoCorasick.computeSupportTransition(trie);
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(bytes, options);
        }
        return new NextMatchFinder(bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    private static TrieNode<ByteString> computeSupportTransition(TrieNode<ByteString> trie) {
        LinkedList<TrieNode> worklist = new LinkedList<TrieNode>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            TrieNode current = (TrieNode)worklist.remove();
            for (ByteObjectMap.Entry next : current.getNexts().cursor()) {
                TrieNode nextTrie = (TrieNode)next.value;
                AhoCorasick.computeSupport(current, next.key, nextTrie, trie);
                worklist.add(nextTrie);
            }
        }
        return trie;
    }

    private static void computeSupport(TrieNode<ByteString> parent, byte b, TrieNode<ByteString> trie, TrieNode<ByteString> init) {
        if (parent != null && trie instanceof TrieNode) {
            TrieNode<ByteString> down;
            for (down = parent.getFallback(); down != null && down.nextNode(b) == null; down = down.getFallback()) {
            }
            if (down != null) {
                TrieNode<ByteString> next = down.nextNode(b);
                trie.addFallback(next);
                ByteString nextMatch = next.getAttached();
                if (nextMatch != null && trie.getAttached() == null) {
                    trie.setAttached(nextMatch);
                }
            } else {
                trie.addFallback(init);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new AhoCorasick(patterns, this.charset);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished()) {
                TrieNode nextcurrent;
                byte b = this.bytes.next();
                TrieNode next = this.current.nextNode(b);
                if (next == null && !this.isBufferEmpty()) {
                    this.bytes.prev();
                    break;
                }
                while (next == null && (nextcurrent = this.current.getFallback()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(b);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getAttached() == null) continue;
                this.push(this.createMatches(this.current, this.bytes.current()));
            }
            return this.longestLeftMost();
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            while (!this.bytes.finished()) {
                TrieNode nextcurrent;
                byte b = this.bytes.next();
                TrieNode next = this.current.nextNode(b);
                while (next == null && (nextcurrent = this.current.getFallback()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(b);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getAttached() == null) continue;
                this.push(this.createMatches(this.current, this.bytes.current()));
                return this.leftMost();
            }
            return null;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected ByteProvider bytes;
        protected TrieNode<ByteString> current;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
            this.current = AhoCorasick.this.trie;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.current = AhoCorasick.this.trie;
            this.clear();
        }

        protected List<StringMatch> createMatches(TrieNode<ByteString> current, long end) {
            ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
            while (current != null) {
                long start;
                StringMatch nextMatch;
                ByteString currentMatch = current.getAttached();
                if (currentMatch != null && !matches.contains(nextMatch = this.createMatch(start = end - (long)currentMatch.length(), end))) {
                    matches.add(nextMatch);
                }
                current = current.getFallback();
            }
            return matches;
        }

        private StringMatch createMatch(long start, long end) {
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

