/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.ByteShift;
import net.amygdalum.stringsearchalgorithms.search.bytes.Encoding;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithmFactory;
import net.amygdalum.util.text.ByteString;

public class Sunday
implements StringSearchAlgorithm {
    private byte[] pattern;
    private int patternLength;
    private ByteShift byteShift;

    public Sunday(String pattern, Charset charset) {
        this.pattern = Encoding.encode(pattern, charset);
        this.patternLength = this.pattern.length;
        this.byteShift = Sunday.computeShift(this.pattern);
    }

    private static ByteShift computeShift(byte[] pattern) {
        return new QuickShift(pattern);
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        return new Finder(bytes, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class QuickShift
    implements ByteShift {
        private int[] byteShift;

        public QuickShift(byte[] pattern) {
            this.byteShift = QuickShift.computeByteShift(pattern);
        }

        private static int[] computeByteShift(byte[] pattern) {
            int i;
            int[] bytes = new int[256];
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = pattern.length + 1;
            }
            for (i = 0; i < pattern.length; ++i) {
                bytes[pattern[i] & 0xFF] = pattern.length - i;
            }
            return bytes;
        }

        @Override
        public int getShift(byte b) {
            return this.byteShift[b & 0xFF];
        }
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new Sunday(pattern, this.charset);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private ByteProvider bytes;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
        }

        @Override
        public StringMatch findNext() {
            int lookahead = Sunday.this.patternLength - 1;
            block0: while (!this.bytes.finished(lookahead)) {
                byte afterNextByte;
                int patternPointer = lookahead;
                byte nextByte = this.bytes.lookahead(patternPointer);
                if (Sunday.this.pattern[patternPointer] == nextByte) {
                    while (patternPointer > 0) {
                        if (Sunday.this.pattern[--patternPointer] == this.bytes.lookahead(patternPointer)) continue;
                        if (!this.bytes.finished(patternPointer + 1)) {
                            afterNextByte = this.bytes.lookahead(patternPointer + 1);
                            this.bytes.forward(Sunday.this.byteShift.getShift(afterNextByte));
                            continue block0;
                        }
                        this.bytes.finish();
                        continue block0;
                    }
                    if (patternPointer != 0) continue;
                    StringMatch match = this.createMatch();
                    if (!this.bytes.finished(patternPointer + 1)) {
                        byte afterNextByte2 = this.bytes.lookahead(patternPointer + 1);
                        this.bytes.forward(Sunday.this.byteShift.getShift(afterNextByte2));
                    } else {
                        this.bytes.finish();
                    }
                    return match;
                }
                if (!this.bytes.finished(patternPointer + 1)) {
                    afterNextByte = this.bytes.lookahead(patternPointer + 1);
                    this.bytes.forward(Sunday.this.byteShift.getShift(afterNextByte));
                    continue;
                }
                this.bytes.finish();
            }
            return null;
        }

        private StringMatch createMatch() {
            long start = this.bytes.current();
            long end = start + (long)Sunday.this.patternLength;
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

