/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.TrieNode;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.StringUtils;

public class WuManber
implements StringSearchAlgorithm {
    private static final int SHIFT_SEED = 17;
    private static final int HASH_SEED = 23;
    private static final int SHIFT_SIZE = 255;
    private static final int HASH_SIZE = 127;
    private char minChar;
    private char maxChar;
    private int minLength;
    private int maxLength;
    private int block;
    private int[] shift;
    private TrieNode<String>[] hash;

    public WuManber(Collection<String> patterns) {
        List<char[]> charpatterns = StringUtils.toCharArray(patterns);
        this.maxChar = CharUtils.computeMaxChar(charpatterns);
        this.minChar = CharUtils.computeMinChar(charpatterns);
        this.minLength = CharUtils.minLength(charpatterns);
        this.maxLength = CharUtils.maxLength(charpatterns);
        this.block = WuManber.blockSize(this.minLength, this.minChar, this.maxChar, charpatterns.size());
        this.shift = WuManber.computeShift(charpatterns, this.block, this.minLength);
        this.hash = WuManber.computeHash(charpatterns, this.block);
    }

    private static int blockSize(int minLength, char minChar, char maxChar, int patterns) {
        int optSize = (int)Math.ceil(Math.log(2 * minLength * patterns) / Math.log(maxChar - minChar));
        if (optSize <= 0) {
            return 1;
        }
        if (optSize > minLength) {
            return minLength;
        }
        return optSize;
    }

    private static int[] computeShift(List<char[]> patterns, int block, int minLength) {
        int[] shift = new int[255];
        for (int i = 0; i < shift.length; ++i) {
            shift[i] = minLength - block + 1;
        }
        ArrayList<char[]> patternStrings = new ArrayList<char[]>();
        HashSet<char[]> blocks = new HashSet<char[]>();
        for (char[] pattern : patterns) {
            patternStrings.add(pattern);
            for (int i = 0; i < pattern.length + 1 - block; ++i) {
                blocks.add(Arrays.copyOfRange(pattern, i, i + block));
            }
        }
        for (char[] currentBlock : blocks) {
            int shiftKey = WuManber.shiftHash(currentBlock);
            int shiftBy = shift[shiftKey];
            for (char[] pattern : patternStrings) {
                int rightMost = pattern.length - CharUtils.lastIndexOf(pattern, currentBlock) - block;
                if (rightMost < 0 || rightMost >= shiftBy) continue;
                shiftBy = rightMost;
            }
            shift[shiftKey] = shiftBy;
        }
        return shift;
    }

    public static int shiftHash(char[] block) {
        int result = 1;
        for (char c : block) {
            result = 17 * result + c;
        }
        int hash = result % 255;
        if (hash < 0) {
            hash += 255;
        }
        return hash;
    }

    private static TrieNode<String>[] computeHash(List<char[]> charpatterns, int block) {
        TrieNode[] hash = new TrieNode[127];
        for (char[] pattern : charpatterns) {
            char[] lastBlock = Arrays.copyOfRange(pattern, pattern.length - block, pattern.length);
            int hashKey = WuManber.hashHash(lastBlock);
            TrieNode trie = hash[hashKey];
            if (trie == null) {
                hash[hashKey] = trie = new TrieNode();
            }
            TrieNode<String> node = trie.extend(CharUtils.revert(pattern), 0);
            node.setAttached(new String(pattern));
        }
        return hash;
    }

    public static int hashHash(char[] block) {
        int result = 1;
        for (char c : block) {
            result = 23 * result + c;
        }
        int hash = result % 127;
        if (hash < 0) {
            hash += 127;
        }
        return hash;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(chars, options);
        }
        return new NextMatchFinder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new WuManber(patterns);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            long lastStart = this.lastStartFromBuffer();
            int lookahead = WuManber.this.minLength - 1;
            while (!this.chars.finished(lookahead)) {
                long pos = this.chars.current();
                char[] lastBlock = this.chars.between(pos + (long)WuManber.this.minLength - (long)WuManber.this.block, pos + (long)WuManber.this.minLength);
                int shiftKey = WuManber.shiftHash(lastBlock);
                int shiftBy = WuManber.this.shift[shiftKey];
                if (shiftBy == 0) {
                    int hashkey = WuManber.hashHash(lastBlock);
                    TrieNode node = WuManber.this.hash[hashkey];
                    if (node != null) {
                        int patternPointer = lookahead;
                        for (node = node.nextNode(this.chars.lookahead(patternPointer)); node != null; node = node.nextNode(this.chars.lookahead(patternPointer))) {
                            String match = (String)node.getAttached();
                            if (match != null) {
                                long start = this.chars.current() + (long)patternPointer;
                                long end = this.chars.current() + (long)WuManber.this.minLength;
                                StringMatch stringMatch = this.createMatch(start, end);
                                if (lastStart < 0L) {
                                    lastStart = start;
                                }
                                this.push(stringMatch);
                            }
                            if (pos + (long)(--patternPointer) < 0L) break;
                        }
                    }
                    this.chars.next();
                    if (!this.bufferContainsLongestMatch(lastStart)) continue;
                    break;
                }
                this.chars.forward(shiftBy);
            }
            return this.longestLeftMost();
        }

        public boolean bufferContainsLongestMatch(long lastStart) {
            return !this.isBufferEmpty() && this.chars.current() - lastStart - 1L > (long)(WuManber.this.maxLength - WuManber.this.minLength);
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            int lookahead = WuManber.this.minLength - 1;
            while (!this.chars.finished(lookahead)) {
                long pos = this.chars.current();
                char[] lastBlock = this.chars.between(pos + (long)WuManber.this.minLength - (long)WuManber.this.block, pos + (long)WuManber.this.minLength);
                int shiftKey = WuManber.shiftHash(lastBlock);
                int shiftBy = WuManber.this.shift[shiftKey];
                if (shiftBy == 0) {
                    int hashkey = WuManber.hashHash(lastBlock);
                    TrieNode node = WuManber.this.hash[hashkey];
                    if (node != null) {
                        int patternPointer = lookahead;
                        for (node = node.nextNode(this.chars.lookahead(patternPointer)); node != null; node = node.nextNode(this.chars.lookahead(patternPointer))) {
                            String match = (String)node.getAttached();
                            if (match != null) {
                                long start = this.chars.current() + (long)patternPointer;
                                long end = this.chars.current() + (long)WuManber.this.minLength;
                                this.push(this.createMatch(start, end));
                            }
                            if (pos + (long)(--patternPointer) < 0L) break;
                        }
                    }
                    this.chars.next();
                    if (this.isBufferEmpty()) continue;
                    return this.leftMost();
                }
                this.chars.forward(shiftBy);
            }
            return null;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            if (last > this.chars.current()) {
                this.chars.move(last);
            }
        }

        protected StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

