/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.amygdalum.util.map.TuneableMap;

public class ByteObjectMap<T>
extends TuneableMap {
    private static final char NULL_KEY = '\u0000';
    private float loadFactor;
    private int mask;
    private int expandAt;
    private int size;
    private byte[] keys;
    private T[] values;
    private T defaultValue;
    private T nullValue;

    public ByteObjectMap(T defaultValue) {
        this(16, 0.7f, defaultValue);
    }

    public ByteObjectMap(int initialSize, float loadFactor, T defaultValue) {
        this.loadFactor = loadFactor;
        this.mask = ByteObjectMap.mask(initialSize, loadFactor);
        this.expandAt = initialSize;
        this.size = 0;
        this.keys = new byte[this.mask + 1];
        this.values = new Object[this.mask + 1];
        this.defaultValue = defaultValue;
        this.nullValue = defaultValue;
    }

    public byte[] keys() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        byte[] keys = new byte[size];
        int pos = 0;
        for (byte b : this.keys) {
            if (b == 0) continue;
            keys[pos] = b;
            ++pos;
        }
        if (this.nullValue != this.defaultValue && pos < keys.length) {
            keys[pos] = 0;
        }
        Arrays.sort(keys);
        return keys;
    }

    public ByteObjectMap<T> add(byte key, T value) {
        this.put(key, value);
        return this;
    }

    public void put(byte key, T value) {
        if (key == 0) {
            this.nullValue = value;
            return;
        }
        int slot = ByteObjectMap.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != 0) {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == 0) {
            ++this.size;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (this.size > this.expandAt) {
            this.expand(this.size * 2);
        }
    }

    public T get(byte key) {
        if (key == 0) {
            return this.nullValue;
        }
        int slot = ByteObjectMap.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != 0) {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == 0) {
            return this.defaultValue;
        }
        return this.values[slot];
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Iterable<Entry> cursor() {
        return new EntryIterable();
    }

    private void expand(int size) {
        int i;
        int mask = ByteObjectMap.mask(size, this.loadFactor);
        byte[] oldkeys = this.keys;
        T[] oldvalues = this.values;
        byte[] keys = new byte[mask + 1];
        Object[] values = new Object[mask + 1];
        int[] delayed = new int[this.size];
        int pos = 0;
        for (i = 0; i < oldkeys.length; ++i) {
            byte key = oldkeys[i];
            if (key == 0) continue;
            T value = oldvalues[i];
            int slot = ByteObjectMap.hash(key) & mask;
            if (keys[slot] == 0) {
                keys[slot] = key;
                values[slot] = value;
                continue;
            }
            delayed[pos] = i;
            ++pos;
        }
        for (i = 0; i <= pos; ++i) {
            int j = delayed[i];
            byte key = oldkeys[j];
            T value = oldvalues[j];
            int slot = ByteObjectMap.hash(key) & mask;
            while (keys[slot] != key && keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
        this.expandAt = size;
        this.mask = mask;
        this.keys = keys;
        this.values = values;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (this.keys.length > 0) {
            byte key = this.keys[0];
            T value = this.values[0];
            buffer.append(key).append(": ").append(value);
        }
        for (int i = 1; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            T value = this.values[i];
            buffer.append(",\n").append(key).append(": ").append(value);
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    public class Entry {
        public byte key;
        public T value;
    }

    public class EntryIterator
    implements Iterator<Entry> {
        private int index = 0;
        private int currentKey = -1;
        private int fixedSize;
        private Entry entry;

        public EntryIterator() {
            this.fixedSize = ByteObjectMap.this.size;
            this.entry = new Entry();
        }

        @Override
        public boolean hasNext() {
            if (ByteObjectMap.this.size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            return this.index < this.fixedSize || this.index == this.fixedSize && ByteObjectMap.this.nullValue != ByteObjectMap.this.defaultValue;
        }

        @Override
        public Entry next() {
            if (ByteObjectMap.this.size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            while (this.currentKey < ByteObjectMap.this.keys.length - 1) {
                ++this.currentKey;
                byte b = ByteObjectMap.this.keys[this.currentKey];
                if (b == 0) continue;
                this.entry.key = ByteObjectMap.this.keys[this.currentKey];
                this.entry.value = ByteObjectMap.this.values[this.currentKey];
                ++this.index;
                return this.entry;
            }
            if (ByteObjectMap.this.nullValue != ByteObjectMap.this.defaultValue) {
                this.entry.key = 0;
                this.entry.value = ByteObjectMap.this.nullValue;
                ++this.index;
                return this.entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentKey < 0 || this.currentKey >= ByteObjectMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            ((ByteObjectMap)ByteObjectMap.this).keys[this.currentKey] = 0;
            ((ByteObjectMap)ByteObjectMap.this).values[this.currentKey] = ByteObjectMap.this.defaultValue;
        }
    }

    public class EntryIterable
    implements Iterable<Entry> {
        @Override
        public Iterator<Entry> iterator() {
            return new EntryIterator();
        }
    }
}

