/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

import net.amygdalum.util.map.TuneableMap;

public class CharIntMap
extends TuneableMap {
    private static final char NULL_KEY = '\u0000';
    private float loadFactor;
    private int mask;
    private int expandAt;
    private int size;
    private char[] keys;
    private int[] values;
    private int defaultValue;
    private int nullValue;

    public CharIntMap(int defaultValue) {
        this(16, 0.7f, defaultValue);
    }

    public CharIntMap(int initialSize, float loadFactor, int defaultValue) {
        this.loadFactor = loadFactor;
        this.mask = CharIntMap.mask(initialSize, loadFactor);
        this.expandAt = initialSize;
        this.size = 0;
        this.keys = new char[this.mask + 1];
        this.values = new int[this.mask + 1];
        this.defaultValue = defaultValue;
        this.nullValue = defaultValue;
    }

    public char[] keys() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        char[] keys = new char[size];
        int pos = 0;
        for (char c : this.keys) {
            if (c == '\u0000') continue;
            keys[pos] = c;
            ++pos;
        }
        if (this.nullValue != this.defaultValue && pos < keys.length) {
            keys[pos] = '\u0000';
        }
        return keys;
    }

    public CharIntMap add(char key, int value) {
        this.put(key, value);
        return this;
    }

    public void put(char key, int value) {
        if (key == '\u0000') {
            this.nullValue = value;
            return;
        }
        int slot = CharIntMap.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            ++this.size;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (this.size > this.expandAt) {
            this.expand(this.size * 2);
        }
    }

    public int get(char key) {
        if (key == '\u0000') {
            return this.nullValue;
        }
        int slot = CharIntMap.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            return this.defaultValue;
        }
        return this.values[slot];
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    private void expand(int size) {
        int i;
        int mask = CharIntMap.mask(size, this.loadFactor);
        char[] oldkeys = this.keys;
        int[] oldvalues = this.values;
        char[] keys = new char[mask + 1];
        int[] values = new int[mask + 1];
        int[] delayed = new int[this.size];
        int pos = 0;
        for (i = 0; i < oldkeys.length; ++i) {
            char key = oldkeys[i];
            if (key == '\u0000') continue;
            int value = oldvalues[i];
            int slot = CharIntMap.hash(key) & mask;
            if (keys[slot] == '\u0000') {
                keys[slot] = key;
                values[slot] = value;
                continue;
            }
            delayed[pos] = i;
            ++pos;
        }
        for (i = 0; i <= pos; ++i) {
            int j = delayed[i];
            char key = oldkeys[j];
            int value = oldvalues[j];
            int slot = CharIntMap.hash(key) & mask;
            while (keys[slot] != key && keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
        this.expandAt = size;
        this.mask = mask;
        this.keys = keys;
        this.values = values;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (this.keys.length > 0) {
            char key = this.keys[0];
            int value = this.values[0];
            buffer.append(key).append(": ").append(value);
        }
        for (int i = 1; i < this.keys.length; ++i) {
            char key = this.keys[i];
            int value = this.values[0];
            buffer.append(",\n").append(key).append(": ").append(value);
        }
        buffer.append("\n}");
        return buffer.toString();
    }
}

