/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import net.amygdalum.util.text.CharMapping;

public class CharAlphabet {
    private char minChar = (char)65535;
    private char maxChar = '\u0000';

    private CharAlphabet() {
    }

    public static CharAlphabet ranged(char[] pattern, CharMapping mapping) {
        CharAlphabet charAlphabet = new CharAlphabet();
        for (char pc : pattern) {
            for (char c : mapping.map(pc)) {
                charAlphabet.add(c);
            }
        }
        return charAlphabet;
    }

    public static CharAlphabet ranged(char[] pattern) {
        CharAlphabet charAlphabet = new CharAlphabet();
        for (char c : pattern) {
            charAlphabet.add(c);
        }
        return charAlphabet;
    }

    private void add(char c) {
        if (c < this.minChar) {
            this.minChar = c;
        }
        if (c > this.maxChar) {
            this.maxChar = c;
        }
    }

    public int getRange() {
        if (this.maxChar <= this.minChar) {
            return 0;
        }
        return this.maxChar - this.minChar + 1;
    }

    public char minChar() {
        return this.minChar;
    }

    public char maxChar() {
        return this.maxChar;
    }
}

