/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.RegexParser;
import net.amygdalum.regexparser.RegexParserOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.DualGlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzer;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzerOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovNormalizer;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;
import net.amygdalum.util.bits.BitSet;
import net.amygdalum.util.io.CharClassMapper;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.io.ReverseCharProvider;

public class BPGlushkov
implements StringSearchAlgorithm {
    private GlushkovAutomaton search;
    private DualGlushkovAutomaton back;
    private CharClassMapper mapper;
    private int minLength;

    public BPGlushkov(String pattern, RegexParserOption ... options) {
        GlushkovAnalyzer analyzer = BPGlushkov.parseAndNormalizeRegex(pattern, options);
        this.search = analyzer.buildAutomaton(GlushkovAnalyzerOption.SELF_LOOP);
        this.back = analyzer.buildReverseAutomaton(new GlushkovAnalyzerOption[0]);
        this.mapper = analyzer.mapper();
        this.minLength = analyzer.minLength();
    }

    private static GlushkovAnalyzer parseAndNormalizeRegex(String pattern, RegexParserOption ... options) {
        RegexParser parser = new RegexParser(pattern, options);
        RegexNode root = parser.parse();
        root = (RegexNode)root.accept((RegexNodeVisitor)new GlushkovNormalizer());
        return new GlushkovAnalyzer(root).analyze();
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private RegexParserOption[] options;

        public Factory(RegexParserOption ... options) {
            this.options = options;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new BPGlushkov(pattern, this.options);
        }
    }

    private class Finder
    extends BufferedStringFinder {
        private boolean longestMatch;
        private boolean nonEmpty;
        private CharProvider chars;
        private CharProvider reverse;
        private long border;
        private BitSet state;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.longestMatch = MatchOption.LONGEST_MATCH.in(options);
            this.nonEmpty = MatchOption.NON_EMPTY.in(options);
            this.chars = chars;
            this.reverse = new ReverseCharProvider(chars);
            this.border = -1L;
            this.state = BPGlushkov.this.search.getInitial();
        }

        @Override
        public void skipTo(long pos) {
            long last;
            this.border = last = this.removeMatchesBefore(pos);
            if (last > this.chars.current()) {
                this.chars.move(last);
            }
        }

        @Override
        public StringMatch findNext() {
            if (this.chars.finished() && this.border >= this.chars.current() && this.isBufferEmpty()) {
                return null;
            }
            if (this.isBufferEmpty()) {
                while (!this.chars.finished()) {
                    if (BPGlushkov.this.search.isFinal(this.state)) {
                        this.push(this.createMatches(this.chars.current(), this.state));
                    }
                    char c = BPGlushkov.this.mapper.representative(this.chars.next());
                    this.state = BPGlushkov.this.search.next(this.state, c);
                    if (!BPGlushkov.this.search.isInitial(this.state) || this.isBufferEmpty()) continue;
                    break;
                }
                if (this.chars.finished() && BPGlushkov.this.search.isFinal(this.state)) {
                    this.push(this.createMatches(this.chars.current(), this.state));
                    this.border = this.chars.current();
                }
            }
            if (this.isBufferEmpty()) {
                return null;
            }
            if (!this.longestMatch) {
                return this.leftMost();
            }
            return this.longestLeftMost();
        }

        private List<StringMatch> createMatches(long end, BitSet state) {
            if (end <= this.border) {
                return Collections.emptyList();
            }
            state = state.and(BPGlushkov.this.back.getInitial());
            ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
            long backup = this.reverse.current();
            this.reverse.move(end);
            while (!this.reverse.finished() && !state.isEmpty()) {
                if (BPGlushkov.this.back.isFinal(state)) {
                    long start = this.reverse.current();
                    matches.add(this.createMatch(start, end));
                }
                char c = BPGlushkov.this.mapper.representative(this.reverse.next());
                state = BPGlushkov.this.back.next(state, c);
            }
            if (this.reverse.finished() && BPGlushkov.this.back.isFinal(state)) {
                long start = this.reverse.current();
                matches.add(this.createMatch(start, end));
            }
            this.reverse.move(backup);
            if (this.nonEmpty) {
                this.removeEmpty(matches);
            }
            return matches;
        }

        public StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }

        private void removeEmpty(List<StringMatch> matches) {
            Iterator<StringMatch> matchIterator = matches.iterator();
            while (matchIterator.hasNext()) {
                StringMatch match = matchIterator.next();
                if (!match.isEmpty()) continue;
                matchIterator.remove();
            }
        }
    }
}

