/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.RegexParser;
import net.amygdalum.regexparser.RegexParserOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.FactorExtender;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.FactorExtenderFactory;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzer;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzerOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovNormalizer;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.MatchBuilder;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.MatchListener;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.util.bits.BitSet;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.io.StringCharProvider;

public class GlushkovPrefixExtender
implements FactorExtender {
    private String pattern;
    private GlushkovAutomaton automaton;
    private int minLength;
    private int prefixLength;
    private BitSet prefixInitial;

    public GlushkovPrefixExtender(String pattern, RegexParserOption ... options) {
        RegexNode root = GlushkovPrefixExtender.parseAndNormalizeRegex(pattern, options);
        GlushkovAnalyzer analyzer = new GlushkovAnalyzer(root).analyze();
        this.pattern = pattern;
        this.automaton = analyzer.buildAutomaton(new GlushkovAnalyzerOption[0]);
        this.minLength = analyzer.minLength();
    }

    private GlushkovPrefixExtender(String pattern, GlushkovAutomaton automaton, int minLength, int prefixLength, BitSet prefixInitial) {
        this.pattern = pattern;
        this.automaton = automaton;
        this.minLength = minLength;
        this.prefixLength = prefixLength;
        this.prefixInitial = prefixInitial;
    }

    private static RegexNode parseAndNormalizeRegex(String pattern, RegexParserOption ... options) {
        RegexParser parser = new RegexParser(pattern, options);
        RegexNode root = parser.parse();
        return (RegexNode)root.accept((RegexNodeVisitor)new GlushkovNormalizer());
    }

    @Override
    public GlushkovPrefixExtender forFactor(String prefix) {
        BitSet prefixInitial = this.match(this.automaton.getInitial(), (CharProvider)new StringCharProvider(prefix, 0), new MatchListener[0]);
        return new GlushkovPrefixExtender(this.pattern, this.automaton, this.minLength, prefix.length(), prefixInitial);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    @Override
    public List<String> getBestFactors(int max) {
        return new ArrayList<String>(this.getPrefixes(max));
    }

    @Override
    public boolean hasFactor(String factor) {
        return this.getPrefixes(factor.length()).contains(factor);
    }

    public Set<String> getPrefixes(int max) {
        return this.getPrefixes(this.automaton.getInitial(), 1, max);
    }

    private Set<String> getPrefixes(BitSet initialstate, int min, int max) {
        Map[] prefixes = new Map[max + 1];
        prefixes[0] = new LinkedHashMap();
        prefixes[0].put("", initialstate);
        for (int i = 1; i < prefixes.length; ++i) {
            prefixes[i] = new LinkedHashMap();
            Iterator prefixIterator = prefixes[i - 1].entrySet().iterator();
            while (prefixIterator.hasNext()) {
                Map.Entry entry = prefixIterator.next();
                String prefix = (String)entry.getKey();
                BitSet state = (BitSet)entry.getValue();
                if (this.automaton.isFinal(state)) {
                    if (i >= min) continue;
                    prefixIterator.remove();
                    continue;
                }
                for (char c : this.automaton.supportedChars()) {
                    String nextString = prefix + c;
                    BitSet nextState = this.automaton.next(state, c);
                    prefixes[i].put(nextString, nextState);
                }
            }
            Iterator newPrefixIterator = prefixes[i].keySet().iterator();
            block3: while (newPrefixIterator.hasNext()) {
                String newPrefix = (String)newPrefixIterator.next();
                for (int j = 1; j < i; ++j) {
                    String suffix = newPrefix.substring(newPrefix.length() - j, newPrefix.length());
                    if (!prefixes[j].containsKey(suffix)) continue;
                    newPrefixIterator.remove();
                    continue block3;
                }
            }
        }
        LinkedHashSet<String> allprefixes = new LinkedHashSet<String>();
        for (int i = 0; i < prefixes.length; ++i) {
            allprefixes.addAll(prefixes[i].keySet());
        }
        return allprefixes;
    }

    @Override
    public SortedSet<StringMatch> extendFactor(CharProvider chars, boolean longest) {
        MatchBuilder listener = new MatchBuilder(longest);
        this.match(this.prefixInitial, chars, listener);
        return listener.getMatches();
    }

    private BitSet match(BitSet state, CharProvider chars, MatchListener ... listeners) {
        boolean notify = listeners != null && listeners.length > 0;
        long pos = chars.current();
        long start = pos - (long)this.prefixLength;
        while (!chars.finished() && !state.isEmpty()) {
            if (notify && this.automaton.isFinal(state)) {
                long end = chars.current();
                for (MatchListener listener : listeners) {
                    listener.notify(start, end, chars);
                }
            }
            char c = chars.next();
            state = this.automaton.next(state, c);
        }
        if (notify && chars.finished() && this.automaton.isFinal(state)) {
            long end = chars.current();
            for (MatchListener listener : listeners) {
                listener.notify(start, end, chars);
            }
        }
        chars.move(pos);
        return state;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements FactorExtenderFactory {
        private RegexParserOption[] options;

        public Factory(RegexParserOption ... options) {
            this.options = options;
        }

        @Override
        public FactorExtender of(String pattern) {
            return new GlushkovPrefixExtender(pattern, this.options);
        }
    }
}

