/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

public class StringMatch
implements Comparable<StringMatch> {
    private long start;
    private long end;
    private String text;

    public StringMatch(long start, long end, String match) {
        this.start = start;
        this.end = end;
        this.text = match;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public String text() {
        return this.text;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public int length() {
        return this.text.length();
    }

    @Override
    public int compareTo(StringMatch o) {
        long start = this.start - o.start;
        if (start != 0L) {
            return start < 0L ? -1 : 1;
        }
        long end = this.end - o.end;
        if (end != 0L) {
            return end < 0L ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        return this.start + ":" + this.end + "(" + this.text + ")";
    }

    public int hashCode() {
        return 31 + (int)this.end * 13 + (int)this.start * 7 + this.text.hashCode() * 3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringMatch that = (StringMatch)obj;
        return this.start == that.start && this.end == that.end && this.text.equals(that.text);
    }
}

