/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.AttachmentAdaptor;
import net.amygdalum.util.text.ByteAutomaton;
import net.amygdalum.util.text.ByteFallbackAdaptor;
import net.amygdalum.util.text.ByteNode;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteTask;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.ByteWordSet;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayByteFallbackTrie;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayByteTrie;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayByteTrieBuilder;

public class AhoCorasick
implements StringSearchAlgorithm {
    private ByteWordSet<ByteString> trie;
    private int minLength;

    public AhoCorasick(Collection<String> patterns, Charset charset) {
        List bytepatterns = StringUtils.toByteArray(patterns, (Charset)charset);
        this.trie = AhoCorasick.computeTrie(bytepatterns, charset);
        this.minLength = ByteUtils.minLength((List)bytepatterns);
    }

    private static ByteWordSet<ByteString> computeTrie(List<byte[]> bytepatterns, Charset charset) {
        DoubleArrayByteTrieBuilder builder = new DoubleArrayByteTrieBuilder((DoubleArrayByteTrie)new DoubleArrayByteFallbackTrie());
        for (byte[] pattern : bytepatterns) {
            builder.extend(pattern, (Object)new ByteString(pattern, charset));
        }
        return builder.work((ByteTask)new FallbackLinks()).build();
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(this.trie, bytes, options);
        }
        return new NextMatchFinder(this.trie, bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new AhoCorasick(patterns, this.charset);
        }
    }

    private static class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(ByteWordSet<ByteString> trie, ByteProvider bytes, StringFinderOption ... options) {
            super(trie, bytes, options);
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished()) {
                byte b = this.bytes.next();
                boolean success = this.cursor.lookahead(b);
                if (!success && !this.isBufferEmpty()) {
                    this.bytes.prev();
                    break;
                }
                success = this.cursor.accept(b);
                if (!success) {
                    this.cursor.reset();
                }
                if (!this.cursor.hasAttachments()) continue;
                this.push(this.createMatches(this.bytes.current()));
            }
            return this.longestLeftMost();
        }
    }

    private static class NextMatchFinder
    extends Finder {
        public NextMatchFinder(ByteWordSet<ByteString> trie, ByteProvider bytes, StringFinderOption ... options) {
            super(trie, bytes, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            while (!this.bytes.finished()) {
                byte b = this.bytes.next();
                boolean success = this.cursor.accept(b);
                if (!success) {
                    this.cursor.reset();
                }
                if (!this.cursor.hasAttachments()) continue;
                this.push(this.createMatches(this.bytes.current()));
                return this.leftMost();
            }
            return null;
        }
    }

    private static abstract class Finder
    extends BufferedStringFinder {
        protected ByteProvider bytes;
        protected ByteAutomaton<ByteString> cursor;

        public Finder(ByteWordSet<ByteString> trie, ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
            this.cursor = trie.cursor();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.cursor.reset();
            this.clear();
        }

        protected List<StringMatch> createMatches(long end) {
            ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
            for (ByteString currentMatch : this.cursor) {
                long start = end - (long)currentMatch.length();
                StringMatch nextMatch = this.createMatch(start, end);
                if (matches.contains(nextMatch)) continue;
                matches.add(nextMatch);
            }
            return matches;
        }

        private StringMatch createMatch(long start, long end) {
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }

    private static class FallbackLinks
    implements ByteTask<ByteString> {
        private ByteNode<ByteString> root;

        private FallbackLinks() {
        }

        public List<ByteNode<ByteString>> init(ByteNode<ByteString> root) {
            this.root = root;
            ByteFallbackAdaptor.setFallback(root, null);
            return Arrays.asList(root);
        }

        public List<ByteNode<ByteString>> process(ByteNode<ByteString> node) {
            ArrayList<ByteNode<ByteString>> nexts = new ArrayList<ByteNode<ByteString>>();
            for (byte b : node.getAlternatives()) {
                ByteNode next = node.nextNode(b);
                ByteNode down = ByteFallbackAdaptor.getFallback(node);
                while (down != null) {
                    ByteNode nextNode = down.nextNode(b);
                    if (nextNode != null) {
                        ByteString attachment;
                        ByteFallbackAdaptor.setFallback((Object)next, (ByteNode)nextNode);
                        if (next.getAttached() != null || (attachment = (ByteString)nextNode.getAttached()) == null) break;
                        AttachmentAdaptor.attach((Object)next, (Object)attachment);
                        break;
                    }
                    down = ByteFallbackAdaptor.getFallback((Object)down);
                }
                if (down == null) {
                    ByteFallbackAdaptor.setFallback((Object)next, this.root);
                }
                nexts.add((ByteNode<ByteString>)next);
            }
            return nexts;
        }
    }
}

