/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithmFactory;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.ByteAutomaton;
import net.amygdalum.util.text.ByteConnectionAdaptor;
import net.amygdalum.util.text.ByteEncoding;
import net.amygdalum.util.text.ByteNode;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteTask;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.ByteWordSet;
import net.amygdalum.util.text.linkeddawg.ByteClassicDawgFactory;
import net.amygdalum.util.text.linkeddawg.ByteDawgFactory;
import net.amygdalum.util.text.linkeddawg.LinkedByteDawgBuilder;

public class BOM
implements StringSearchAlgorithm {
    private ByteWordSet<byte[]> trie;
    private int patternLength;

    public BOM(String pattern, Charset charset) {
        byte[] encoded = ByteEncoding.encode((String)pattern, (Charset)charset);
        this.patternLength = encoded.length;
        this.trie = BOM.computeTrie(encoded);
    }

    private static ByteWordSet<byte[]> computeTrie(byte[] pattern) {
        LinkedByteDawgBuilder builder = new LinkedByteDawgBuilder((ByteDawgFactory)new ByteClassicDawgFactory());
        builder.extend(ByteUtils.revert((byte[])pattern), (Object)pattern);
        builder.work((ByteTask)new BuildOracle());
        return builder.build();
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        return new Finder(this.trie, this.patternLength, bytes, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new BOM(pattern, this.charset);
        }
    }

    private static class Finder
    extends AbstractStringFinder {
        private final int lookahead;
        private ByteProvider bytes;
        private ByteAutomaton<byte[]> cursor;

        public Finder(ByteWordSet<byte[]> trie, int patternLength, ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.lookahead = patternLength - 1;
            this.bytes = bytes;
            this.cursor = trie.cursor();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished(this.lookahead)) {
                int j;
                this.cursor.reset();
                boolean success = true;
                for (j = this.lookahead; j >= 0 && success; --j) {
                    success = this.cursor.accept(this.bytes.lookahead(j));
                }
                if (success && j < 0) {
                    byte[] pattern = (byte[])this.cursor.iterator().next();
                    long start = this.bytes.current();
                    long end = start + (long)pattern.length;
                    StringMatch match = this.createMatch(start, end);
                    this.bytes.next();
                    return match;
                }
                if (j <= 0) {
                    this.bytes.next();
                    continue;
                }
                this.bytes.forward(j + 2);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }

    public static class BuildOracle
    implements ByteTask<byte[]> {
        private Map<ByteNode<byte[]>, ByteNode<byte[]>> oracle = new IdentityHashMap<ByteNode<byte[]>, ByteNode<byte[]>>();
        private ByteNode<byte[]> init;

        public List<ByteNode<byte[]>> init(ByteNode<byte[]> root) {
            this.init = root;
            return Arrays.asList(root);
        }

        public List<ByteNode<byte[]>> process(ByteNode<byte[]> node) {
            ArrayList<ByteNode<byte[]>> nexts = new ArrayList<ByteNode<byte[]>>();
            for (byte b : node.getAlternatives()) {
                ByteNode current = node.nextNode(b);
                ByteNode<byte[]> down = this.oracle.get(node);
                while (down != null) {
                    ByteNode next = down.nextNode(b);
                    if (next != null) {
                        this.oracle.put((ByteNode<byte[]>)current, (ByteNode<byte[]>)next);
                        break;
                    }
                    this.addNextNode(down, b, (ByteNode<byte[]>)current);
                    down = this.oracle.get(down);
                }
                if (down == null) {
                    this.oracle.put((ByteNode<byte[]>)current, this.init);
                }
                nexts.add((ByteNode<byte[]>)current);
            }
            return nexts;
        }

        private void addNextNode(ByteNode<byte[]> node, byte b, ByteNode<byte[]> next) {
            ((ByteConnectionAdaptor)node).addNextNode(b, next);
        }
    }
}

