/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithmFactory;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.ByteEncoding;
import net.amygdalum.util.text.ByteString;

public class KnuthMorrisPratt
implements StringSearchAlgorithm {
    private byte[] pattern;
    private int patternLength;
    private int[] next;

    public KnuthMorrisPratt(String pattern, Charset charset) {
        this.pattern = ByteEncoding.encode((String)pattern, (Charset)charset);
        this.patternLength = this.pattern.length;
        this.next = this.computeNext(this.pattern);
    }

    private int[] computeNext(byte[] pattern) {
        int[] next = new int[this.patternLength + 1];
        next[0] = -1;
        int patternPointer = 0;
        int suffixPointer = -1;
        while (patternPointer < this.patternLength) {
            while (suffixPointer > -1 && pattern[patternPointer] != pattern[suffixPointer]) {
                suffixPointer = next[suffixPointer];
            }
            if (++patternPointer < this.patternLength && pattern[patternPointer] == pattern[++suffixPointer]) {
                next[patternPointer] = next[suffixPointer];
                continue;
            }
            next[patternPointer] = suffixPointer;
        }
        return next;
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        return new Finder(bytes, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new KnuthMorrisPratt(pattern, this.charset);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private ByteProvider bytes;
        private int patternPointer;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
            this.patternPointer = 0;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.patternPointer = 0;
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished()) {
                byte nextByte = this.bytes.next();
                while (this.patternPointer > -1 && KnuthMorrisPratt.this.pattern[this.patternPointer] != nextByte) {
                    this.patternPointer = KnuthMorrisPratt.this.next[this.patternPointer];
                }
                ++this.patternPointer;
                if (this.patternPointer < KnuthMorrisPratt.this.patternLength) continue;
                StringMatch match = this.createMatch();
                this.patternPointer = KnuthMorrisPratt.this.next[this.patternPointer];
                return match;
            }
            return null;
        }

        private StringMatch createMatch() {
            long end = this.bytes.current();
            long start = end - (long)this.patternPointer;
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

