/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.ByteShift;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.ByteAutomaton;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.ByteWordSet;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayByteCompactTrie;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayByteTrie;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayByteTrieBuilder;

public class SetHorspool
implements StringSearchAlgorithm {
    private ByteWordSet<ByteString> trie;
    private int minLength;
    private int maxLength;
    private ByteShift byteShift;

    public SetHorspool(Collection<String> patterns, Charset charset) {
        List bytepatterns = StringUtils.toByteArray(patterns, (Charset)charset);
        this.trie = SetHorspool.computeTrie(bytepatterns, charset);
        this.minLength = ByteUtils.minLength((List)bytepatterns);
        this.maxLength = ByteUtils.maxLength((List)bytepatterns);
        this.byteShift = this.computeByteShift(bytepatterns, this.minLength);
    }

    private ByteShift computeByteShift(List<byte[]> bytepatterns, int minLength) {
        return new QuickShift(bytepatterns, minLength);
    }

    private static ByteWordSet<ByteString> computeTrie(List<byte[]> bytepatterns, Charset charset) {
        DoubleArrayByteTrieBuilder builder = new DoubleArrayByteTrieBuilder((DoubleArrayByteTrie)new DoubleArrayByteCompactTrie());
        for (byte[] pattern : bytepatterns) {
            builder.extend(ByteUtils.revert((byte[])pattern), (Object)new ByteString(pattern, charset));
        }
        return builder.build();
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(this.trie, this.minLength, this.maxLength, this.byteShift, bytes, options);
        }
        return new NextMatchFinder(this.trie, this.minLength, this.maxLength, this.byteShift, bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class QuickShift
    implements ByteShift {
        private int[] byteShift;

        public QuickShift(List<byte[]> bytepatterns, int minLength) {
            this.byteShift = QuickShift.computeByteShift(bytepatterns, minLength);
        }

        private static int[] computeByteShift(List<byte[]> patterns, int minLength) {
            int[] bytes = new int[256];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = minLength;
            }
            for (byte[] pattern : patterns) {
                for (int i = 0; i < pattern.length - 1; ++i) {
                    bytes[pattern[i] & 0xFF] = Math.min(bytes[pattern[i] & 0xFF], pattern.length - i - 1);
                }
            }
            return bytes;
        }

        @Override
        public int getShift(byte b) {
            return this.byteShift[b & 0xFF];
        }
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new SetHorspool(patterns, this.charset);
        }
    }

    private static class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(ByteWordSet<ByteString> trie, int minLength, int maxLength, ByteShift byteShift, ByteProvider bytes, StringFinderOption ... options) {
            super(trie, minLength, maxLength, byteShift, bytes, options);
        }

        @Override
        public StringMatch findNext() {
            long lastStart = this.lastStartFromBuffer();
            int lookahead = this.minLength - 1;
            while (!this.bytes.finished(lookahead)) {
                int patternPointer = lookahead;
                long pos = this.bytes.current();
                byte current = this.bytes.lookahead(patternPointer);
                this.cursor.reset();
                boolean success = this.cursor.accept(current);
                while (success) {
                    if (this.cursor.hasAttachments()) {
                        ByteString match = (ByteString)this.cursor.iterator().next();
                        long start = this.bytes.current() + (long)patternPointer;
                        long end = this.bytes.current() + (long)patternPointer + (long)match.length();
                        StringMatch stringMatch = this.createMatch(start, end);
                        if (lastStart < 0L) {
                            lastStart = start;
                        }
                        this.push(stringMatch);
                    }
                    if (pos + (long)(--patternPointer) < 0L) break;
                    success = this.cursor.accept(this.bytes.lookahead(patternPointer));
                }
                this.bytes.forward(this.byteShift.getShift(current));
                if (!this.bufferContainsLongestMatch(lastStart)) continue;
                break;
            }
            return this.longestLeftMost();
        }

        public boolean bufferContainsLongestMatch(long lastStart) {
            return !this.isBufferEmpty() && this.bytes.current() - lastStart > (long)this.maxLength;
        }
    }

    private static class NextMatchFinder
    extends Finder {
        public NextMatchFinder(ByteWordSet<ByteString> trie, int minLength, int maxLength, ByteShift byteShift, ByteProvider bytes, StringFinderOption ... options) {
            super(trie, minLength, maxLength, byteShift, bytes, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            int lookahead = this.minLength - 1;
            while (!this.bytes.finished(lookahead)) {
                int patternPointer = lookahead;
                long pos = this.bytes.current();
                byte current = this.bytes.lookahead(patternPointer);
                this.cursor.reset();
                boolean success = this.cursor.accept(current);
                while (success) {
                    if (this.cursor.hasAttachments()) {
                        ByteString match = (ByteString)this.cursor.iterator().next();
                        long start = this.bytes.current() + (long)patternPointer;
                        long end = this.bytes.current() + (long)patternPointer + (long)match.length();
                        this.push(this.createMatch(start, end));
                    }
                    if (pos + (long)(--patternPointer) < 0L) break;
                    success = this.cursor.accept(this.bytes.lookahead(patternPointer));
                }
                this.bytes.forward(this.byteShift.getShift(current));
                if (this.isBufferEmpty()) continue;
                return this.leftMost();
            }
            return null;
        }
    }

    private static abstract class Finder
    extends BufferedStringFinder {
        protected final int minLength;
        protected final int maxLength;
        protected final ByteShift byteShift;
        protected ByteProvider bytes;
        protected ByteAutomaton<ByteString> cursor;

        public Finder(ByteWordSet<ByteString> trie, int minLength, int maxLength, ByteShift byteShift, ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.byteShift = byteShift;
            this.bytes = bytes;
            this.cursor = trie.cursor();
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            if (last > this.bytes.current()) {
                this.bytes.move(last);
            }
        }

        protected StringMatch createMatch(long start, long end) {
            ByteString slice = this.bytes.slice(start, end);
            return new StringMatch(start, end, slice.getString());
        }
    }
}

