/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.text.CharAutomaton;
import net.amygdalum.util.text.CharConnectionAdaptor;
import net.amygdalum.util.text.CharMapping;
import net.amygdalum.util.text.CharNode;
import net.amygdalum.util.text.CharTask;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.CharWordSet;
import net.amygdalum.util.text.linkeddawg.CharClassicDawgFactory;
import net.amygdalum.util.text.linkeddawg.CharDawgFactory;
import net.amygdalum.util.text.linkeddawg.LinkedCharDawgBuilder;

public class BOM
implements StringSearchAlgorithm {
    private CharWordSet<char[]> trie;
    private int patternLength;

    public BOM(String pattern) {
        this(pattern, CharMapping.IDENTITY);
    }

    public BOM(String pattern, CharMapping mapping) {
        this.patternLength = pattern.length();
        this.trie = BOM.computeTrie(pattern.toCharArray(), mapping);
    }

    private static CharWordSet<char[]> computeTrie(char[] pattern, CharMapping mapping) {
        if (mapping != CharMapping.IDENTITY) {
            pattern = mapping.normalized(pattern);
        }
        LinkedCharDawgBuilder builder = new LinkedCharDawgBuilder((CharDawgFactory)new CharClassicDawgFactory());
        builder.extend(CharUtils.revert((char[])pattern), (Object)pattern);
        builder.work((CharTask)new BuildOracle());
        builder.work((CharTask)new UseCharClasses(mapping));
        return builder.build();
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(this.trie, this.patternLength, chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            if (this.mapping == null) {
                return new BOM(pattern);
            }
            return new BOM(pattern, this.mapping);
        }
    }

    private static class Finder
    extends AbstractStringFinder {
        private final int lookahead;
        private CharProvider chars;
        private CharAutomaton<char[]> cursor;

        public Finder(CharWordSet<char[]> trie, int patternLength, CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.lookahead = patternLength - 1;
            this.chars = chars;
            this.cursor = trie.cursor();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished(this.lookahead)) {
                int j;
                this.cursor.reset();
                boolean success = true;
                for (j = this.lookahead; j >= 0 && success; --j) {
                    success = this.cursor.accept(this.chars.lookahead(j));
                }
                if (success && j < 0) {
                    char[] pattern = (char[])this.cursor.iterator().next();
                    long start = this.chars.current();
                    long end = start + (long)pattern.length;
                    StringMatch match = this.createMatch(start, end);
                    this.chars.next();
                    return match;
                }
                if (j <= 0) {
                    this.chars.next();
                    continue;
                }
                this.chars.forward(j + 2);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }

    public static class UseCharClasses
    implements CharTask<char[]> {
        private CharMapping mapping;
        private Set<CharNode<char[]>> done;

        public UseCharClasses(CharMapping mapping) {
            this.mapping = mapping;
            this.done = new HashSet<CharNode<char[]>>();
        }

        public List<CharNode<char[]>> init(CharNode<char[]> root) {
            if (this.mapping == CharMapping.IDENTITY) {
                return Collections.emptyList();
            }
            return Arrays.asList(root);
        }

        public List<CharNode<char[]>> process(CharNode<char[]> node) {
            ArrayList<CharNode<char[]>> nexts = new ArrayList<CharNode<char[]>>();
            for (char c : node.getAlternatives()) {
                CharNode next = node.nextNode(c);
                for (char cc : this.mapping.map(c)) {
                    this.addNextNode(node, cc, (CharNode<char[]>)next);
                }
                if (!this.done.add((CharNode<char[]>)next)) continue;
                nexts.add((CharNode<char[]>)next);
            }
            return nexts;
        }

        private void addNextNode(CharNode<char[]> node, char c, CharNode<char[]> next) {
            ((CharConnectionAdaptor)node).addNextNode(c, next);
        }
    }

    public static class BuildOracle
    implements CharTask<char[]> {
        private Map<CharNode<char[]>, CharNode<char[]>> oracle = new IdentityHashMap<CharNode<char[]>, CharNode<char[]>>();
        private CharNode<char[]> init;

        public List<CharNode<char[]>> init(CharNode<char[]> root) {
            this.init = root;
            return Arrays.asList(root);
        }

        public List<CharNode<char[]>> process(CharNode<char[]> node) {
            ArrayList<CharNode<char[]>> nexts = new ArrayList<CharNode<char[]>>();
            for (char c : node.getAlternatives()) {
                CharNode current = node.nextNode(c);
                CharNode<char[]> down = this.oracle.get(node);
                while (down != null) {
                    CharNode next = down.nextNode(c);
                    if (next != null) {
                        this.oracle.put((CharNode<char[]>)current, (CharNode<char[]>)next);
                        break;
                    }
                    this.addNextNode(down, c, (CharNode<char[]>)current);
                    down = this.oracle.get(down);
                }
                if (down == null) {
                    this.oracle.put((CharNode<char[]>)current, this.init);
                }
                nexts.add((CharNode<char[]>)current);
            }
            return nexts;
        }

        private void addNextNode(CharNode<char[]> node, char c, CharNode<char[]> next) {
            ((CharConnectionAdaptor)node).addNextNode(c, next);
        }
    }
}

