/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.Collection;
import java.util.LinkedHashSet;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmWrapper;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.io.CaseInsensitiveCharProvider;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.text.CharMapping;

public class CaseInsensitive
implements StringSearchAlgorithm,
StringSearchAlgorithmWrapper {
    public static final CharMapping MAPPING = new CharMapping(){

        public char[] map(char c) {
            char uc;
            char lc = Character.toLowerCase(c);
            if (lc != (uc = Character.toUpperCase(c))) {
                return new char[]{lc, uc};
            }
            return new char[]{lc};
        }

        public char[] normalized(char[] chars) {
            char[] normalized = new char[chars.length];
            for (int i = 0; i < normalized.length; ++i) {
                normalized[i] = Character.toLowerCase(chars[i]);
            }
            return normalized;
        }
    };
    private StringSearchAlgorithm algorithm;

    private CaseInsensitive(StringSearchAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public StringSearchAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public static StringSearchAlgorithmFactory caseInsensitive(StringSearchAlgorithmFactory factory) {
        if (factory instanceof SupportsCharClasses) {
            ((SupportsCharClasses)((Object)factory)).enableCharClasses(MAPPING);
            return factory;
        }
        return new Factory(factory);
    }

    public static MultiStringSearchAlgorithmFactory caseInsensitive(MultiStringSearchAlgorithmFactory factory) {
        if (factory instanceof SupportsCharClasses) {
            ((SupportsCharClasses)((Object)factory)).enableCharClasses(MAPPING);
            return factory;
        }
        return new MultiFactory(factory);
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return this.algorithm.createFinder((CharProvider)new CaseInsensitiveCharProvider(chars), options);
    }

    @Override
    public int getPatternLength() {
        return this.algorithm.getPatternLength();
    }

    public static class MultiFactory
    implements MultiStringSearchAlgorithmFactory {
        private MultiStringSearchAlgorithmFactory factory;

        private MultiFactory(MultiStringSearchAlgorithmFactory factory) {
            this.factory = factory;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            LinkedHashSet<String> lc = new LinkedHashSet<String>();
            for (String pattern : patterns) {
                lc.add(pattern.toLowerCase());
            }
            return new CaseInsensitive(this.factory.of(lc));
        }
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private StringSearchAlgorithmFactory factory;

        private Factory(StringSearchAlgorithmFactory factory) {
            this.factory = factory;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            String lc = pattern.toLowerCase();
            return new CaseInsensitive(this.factory.of(lc));
        }
    }
}

