/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.text.CharMapping;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.QGramAlphabet;
import net.amygdalum.util.text.QGramMapping;
import net.amygdalum.util.text.StringSet;
import net.amygdalum.util.text.StringUtils;

public class QGramShiftOr
implements StringSearchAlgorithm {
    private int minLength;
    private int maxLength;
    private QGramMapping qmapping;
    private StringSet patterns;
    private BitMapStates states;

    public QGramShiftOr(Collection<String> patterns) {
        this(patterns, QGramShiftOr.bestMapping(patterns), CharMapping.IDENTITY);
    }

    public QGramShiftOr(Collection<String> patterns, CharMapping mapping) {
        this(patterns, QGramShiftOr.bestMapping(patterns), mapping);
    }

    public QGramShiftOr(Collection<String> patterns, QGramMapping qmapping, CharMapping mapping) {
        List charpatterns = StringUtils.toCharArray(patterns);
        this.minLength = CharUtils.minLength((List)charpatterns);
        this.maxLength = CharUtils.maxLength((List)charpatterns);
        this.qmapping = qmapping;
        this.patterns = new StringSet(charpatterns);
        this.states = QGramShiftOr.computeStates(charpatterns, qmapping, mapping, this.maxLength);
    }

    public static QGramMapping bestMapping(Collection<String> patterns) {
        List charpatterns = StringUtils.toCharArray(patterns);
        char minChar = CharUtils.computeMinChar((Collection)charpatterns);
        char maxChar = CharUtils.computeMaxChar((Collection)charpatterns);
        int range = maxChar - minChar + 1;
        int bits = 1;
        for (int i = range; i > 0; i >>= 2) {
            ++bits;
        }
        int q = CharUtils.minLength((List)charpatterns);
        if (q > 3) {
            q = 3;
        }
        return new QGramMapping(q, bits);
    }

    private static BitMapStates computeStates(List<char[]> patterns, QGramMapping qmapping, CharMapping mapping, int maxLength) {
        QGramAlphabet alphabet = QGramAlphabet.of(patterns, (QGramMapping)qmapping);
        if (maxLength > 64) {
            return new RelaxedMultiLongStates(patterns, alphabet, mapping, maxLength);
        }
        return new RelaxedSingleLongStates(patterns, alphabet, mapping);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (this.states.supportsSingle()) {
            if (MatchOption.LONGEST_MATCH.in(options)) {
                return new LongLongestFinder(chars, options);
            }
            return new LongNextFinder(chars, options);
        }
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new MultiLongLongestFinder(chars, options);
        }
        return new MultiLongNextFinder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class RelaxedMultiLongStates
    extends MultiLongBitMapStates {
        private int minQGram;
        private int maxQGram;
        private long[][] characters;
        private long[] zero;

        public RelaxedMultiLongStates(List<char[]> patterns, QGramAlphabet alphabet, CharMapping mapping, int maxLength) {
            this.minQGram = alphabet.minQGram();
            this.maxQGram = alphabet.maxQGram();
            this.characters = RelaxedMultiLongStates.computeStates(patterns, alphabet, mapping, maxLength);
            this.zero = RelaxedMultiLongStates.computeZero(maxLength);
        }

        private static long[][] computeStates(List<char[]> patterns, QGramAlphabet alphabet, CharMapping mapping, int maxLength) {
            QGramMapping qmapping = alphabet.getMapping();
            int min = alphabet.minQGram();
            int max = alphabet.maxQGram();
            long[][] characters = new long[max - min + 1][];
            for (int c = min; c <= max; ++c) {
                characters[c - min] = RelaxedMultiLongStates.computeZero(maxLength);
            }
            for (char[] pattern : patterns) {
                int i = 0;
                for (int[] qcs : qmapping.iterate(pattern, mapping)) {
                    int lastElement = maxLength - 1;
                    int neededSlots = lastElement / 64;
                    int slotsFromBeginning = i / 64;
                    int slot = neededSlots - slotsFromBeginning;
                    int offset = i % 64;
                    for (int qc : qcs) {
                        long[] lArray = characters[qc - min];
                        int n = slot;
                        lArray[n] = lArray[n] & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    ++i;
                }
            }
            return characters;
        }

        @Override
        public long[] all(int qc) {
            if (qc < this.minQGram || qc > this.maxQGram) {
                return this.zero;
            }
            return this.characters[qc - this.minQGram];
        }
    }

    private static abstract class MultiLongBitMapStates
    implements BitMapStates {
        private MultiLongBitMapStates() {
        }

        public static long[] computeZero(int length) {
            long[] zero = new long[(length - 1) / 64 + 1];
            Arrays.fill(zero, -1L);
            return zero;
        }

        @Override
        public boolean supportsSingle() {
            return false;
        }

        @Override
        public long single(int c) {
            throw new UnsupportedOperationException();
        }
    }

    private static class RelaxedSingleLongStates
    extends SingleLongBitMapStates {
        private int minQGram;
        private int maxQGram;
        private long[] characters;

        public RelaxedSingleLongStates(List<char[]> pattern, QGramAlphabet alphabet, CharMapping mapping) {
            this.minQGram = alphabet.minQGram();
            this.maxQGram = alphabet.maxQGram();
            this.characters = RelaxedSingleLongStates.computeStates(pattern, alphabet, mapping);
        }

        private static long[] computeStates(List<char[]> patterns, QGramAlphabet alphabet, CharMapping mapping) {
            QGramMapping qmapping = alphabet.getMapping();
            int min = alphabet.minQGram();
            int max = alphabet.maxQGram();
            long[] characters = new long[max - min + 1];
            Arrays.fill(characters, -1L);
            for (char[] pattern : patterns) {
                int i = 0;
                int[][] nArray = qmapping.iterate(pattern, mapping);
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    int[] qcs;
                    for (int qc : qcs = nArray[j]) {
                        int n2 = qc - min;
                        characters[n2] = characters[n2] & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    ++i;
                }
            }
            return characters;
        }

        @Override
        public long single(int c) {
            if (c < this.minQGram || c > this.maxQGram) {
                return -1L;
            }
            return this.characters[c - this.minQGram];
        }
    }

    private static abstract class SingleLongBitMapStates
    implements BitMapStates {
        private SingleLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return true;
        }

        @Override
        public long[] all(int qc) {
            return new long[]{this.single(qc)};
        }
    }

    public static interface BitMapStates {
        public static final long ALLBITS = -1L;

        public boolean supportsSingle();

        public long single(int var1);

        public long[] all(int var1);
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            if (this.mapping == null) {
                return new QGramShiftOr(patterns);
            }
            return new QGramShiftOr(patterns, this.mapping);
        }
    }

    private class MultiLongLongestFinder
    extends MultiLongFinder {
        public MultiLongLongestFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            char[] qgram = QGramShiftOr.this.qmapping.newQGram();
            while (!this.chars.finished(this.q1)) {
                int nextQGram = this.nextQGram(qgram);
                long[] bits = QGramShiftOr.this.states.all(nextQGram);
                this.state = this.next(this.state, bits);
                if (this.isFinalState()) {
                    this.push(this.verifyMatches());
                }
                if (this.isBufferEmpty() || !this.isZeroState() && !this.firstMatchOutOfSubsumptionRange()) continue;
                break;
            }
            return this.longestLeftMost();
        }
    }

    private class MultiLongNextFinder
    extends MultiLongFinder {
        public MultiLongNextFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            char[] qgram = QGramShiftOr.this.qmapping.newQGram();
            while (!this.chars.finished(this.q1)) {
                int nextQGram = this.nextQGram(qgram);
                long[] bits = QGramShiftOr.this.states.all(nextQGram);
                this.state = this.next(this.state, bits);
                if (!this.isFinalState()) continue;
                this.push(this.verifyMatches());
                if (this.isBufferEmpty()) continue;
                return this.leftMost();
            }
            return null;
        }
    }

    private abstract class MultiLongFinder
    extends Finder {
        protected final long[] finalstate;
        protected long[] state;

        public MultiLongFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.finalstate = this.computeFinalState();
            this.state = MultiLongBitMapStates.computeZero(QGramShiftOr.this.maxLength);
        }

        private long[] computeFinalState() {
            long[] finalstate = MultiLongBitMapStates.computeZero(QGramShiftOr.this.maxLength);
            for (int len : QGramShiftOr.this.patterns.containedLengths()) {
                int lenQ = len - this.q;
                int slot = (QGramShiftOr.this.maxLength - 1) / 64 - lenQ / 64;
                int offset = lenQ % 64;
                int n = slot;
                finalstate[n] = finalstate[n] & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return finalstate;
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            if (last > this.chars.current()) {
                this.chars.move(last);
                Arrays.fill(this.state, -1L);
            } else {
                long diff = this.chars.current() - pos;
                if (diff < (long)QGramShiftOr.this.maxLength) {
                    for (int i = this.state.length - 1; i >= 0 && diff > 0L; diff -= 64L, --i) {
                        if (diff < 64L) {
                            int n = i;
                            this.state[n] = this.state[n] | -1L << (int)diff;
                            continue;
                        }
                        this.state[i] = -1L;
                    }
                }
            }
        }

        protected final List<StringMatch> verifyMatches() {
            LinkedList<StringMatch> matches = new LinkedList<StringMatch>();
            for (int len : QGramShiftOr.this.patterns.containedLengths()) {
                int offset;
                int slotsFromBeginning;
                int lenQ = len - this.q;
                int lastElement = QGramShiftOr.this.maxLength - 1;
                int allslots = lastElement / 64;
                int slot = allslots - (slotsFromBeginning = lenQ / 64);
                if ((this.state[slot] | 1L << (offset = lenQ % 64) ^ 0xFFFFFFFFFFFFFFFFL) == -1L) continue;
                long end = this.chars.current() + (long)this.q1;
                long start = end - (long)len;
                char[] found = this.chars.between(start, end);
                if (!QGramShiftOr.this.patterns.contains(found)) continue;
                matches.add(0, this.createMatch(start, end));
            }
            return matches;
        }

        protected long[] next(long[] state, long[] bits) {
            for (int i = 0; i < state.length; ++i) {
                int j = i + 1;
                long leastBit = j < state.length ? state[j] >>> 63 : 0L;
                state[i] = state[i] << 1 | leastBit | bits[i];
            }
            return state;
        }

        protected boolean isFinalState() {
            for (int i = 0; i < this.state.length; ++i) {
                if ((this.state[i] | this.finalstate[i]) == -1L) continue;
                return true;
            }
            return false;
        }

        protected boolean isZeroState() {
            for (int i = 0; i < this.state.length; ++i) {
                if (this.state[i] == -1L) continue;
                return false;
            }
            return true;
        }
    }

    private class LongLongestFinder
    extends LongFinder {
        public LongLongestFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            char[] qgram = QGramShiftOr.this.qmapping.newQGram();
            while (!this.chars.finished(this.q1)) {
                int nextQGram = this.nextQGram(qgram);
                long bits = QGramShiftOr.this.states.single(nextQGram);
                this.state = this.state << 1 | bits;
                if (this.isFinalState()) {
                    this.push(this.verifyMatches());
                }
                if (this.isBufferEmpty() || !this.isZeroState() && !this.firstMatchOutOfSubsumptionRange()) continue;
                break;
            }
            return this.longestLeftMost();
        }
    }

    private class LongNextFinder
    extends LongFinder {
        public LongNextFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            char[] qgram = QGramShiftOr.this.qmapping.newQGram();
            while (!this.chars.finished(this.q1)) {
                int nextQGram = this.nextQGram(qgram);
                long bits = QGramShiftOr.this.states.single(nextQGram);
                this.state = this.state << 1 | bits;
                if (!this.isFinalState()) continue;
                this.push(this.verifyMatches());
                if (this.isBufferEmpty()) continue;
                return this.leftMost();
            }
            return null;
        }
    }

    private abstract class LongFinder
    extends Finder {
        protected final long finalstate;
        protected long state;

        public LongFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.finalstate = this.computeFinalState();
            this.state = -1L;
        }

        private long computeFinalState() {
            long finalstate = -1L;
            for (int len : QGramShiftOr.this.patterns.containedLengths()) {
                int lenQ = len - this.q;
                finalstate &= 1L << lenQ ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return finalstate;
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            if (last > this.chars.current()) {
                this.chars.move(last);
                this.state = -1L;
            } else {
                long diff = this.chars.current() - pos;
                if (diff < (long)QGramShiftOr.this.maxLength) {
                    this.state |= -1L << (int)diff;
                }
            }
        }

        protected final List<StringMatch> verifyMatches() {
            LinkedList<StringMatch> matches = new LinkedList<StringMatch>();
            for (int len : QGramShiftOr.this.patterns.containedLengths()) {
                int lenQ = len - this.q;
                if ((this.state | 1L << lenQ ^ 0xFFFFFFFFFFFFFFFFL) == -1L) continue;
                long end = this.chars.current() + (long)this.q1;
                long start = end - (long)len;
                char[] found = this.chars.between(start, end);
                if (!QGramShiftOr.this.patterns.contains(found)) continue;
                matches.add(0, this.createMatch(start, end));
            }
            return matches;
        }

        protected boolean isFinalState() {
            return (this.state | this.finalstate) != -1L;
        }

        protected boolean isZeroState() {
            return this.state == -1L;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected int q;
        protected int q1;
        protected CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.q = QGramShiftOr.this.qmapping.getQ();
            this.q1 = QGramShiftOr.this.qmapping.getQ() - 1;
            this.chars = chars;
        }

        protected int nextQGram(char[] qgram) {
            for (int i = 0; i < qgram.length; ++i) {
                qgram[i] = this.chars.lookahead(i);
            }
            this.chars.next();
            return QGramShiftOr.this.qmapping.map(qgram);
        }

        protected StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }

        protected boolean firstMatchOutOfSubsumptionRange() {
            long lastStart = this.lastStartFromBuffer();
            return this.chars.current() > lastStart + (long)QGramShiftOr.this.maxLength;
        }
    }
}

