/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.Collection;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.CharShift;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.map.CharIntMap;
import net.amygdalum.util.text.CharAutomaton;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.CharWordSet;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayCharCompactTrie;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayCharTrie;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayCharTrieBuilder;

public class SetHorspool
implements StringSearchAlgorithm {
    private CharWordSet<String> trie;
    private int minLength;
    private int maxLength;
    private CharShift charShift;

    public SetHorspool(Collection<String> patterns) {
        this(patterns, false);
    }

    public SetHorspool(Collection<String> patterns, boolean relaxed) {
        List charpatterns = StringUtils.toCharArray(patterns);
        this.trie = SetHorspool.computeTrie(charpatterns);
        this.minLength = CharUtils.minLength((List)charpatterns);
        this.maxLength = CharUtils.maxLength((List)charpatterns);
        this.charShift = this.computeCharacterShift(charpatterns, this.minLength, relaxed);
    }

    private CharShift computeCharacterShift(List<char[]> charpatterns, int minLength, boolean relaxed) {
        if (this.isCompactRange(charpatterns, minLength)) {
            return new QuickShift(charpatterns, minLength);
        }
        if (relaxed) {
            return new RelaxedShift(charpatterns, minLength);
        }
        return new SmartShift(charpatterns, minLength);
    }

    public boolean isCompactRange(List<char[]> charpatterns, int minLength) {
        char minChar = CharUtils.computeMinChar(charpatterns);
        char maxChar = CharUtils.computeMaxChar(charpatterns);
        return maxChar - minChar < 256 || maxChar - minChar < minLength * 2;
    }

    private static CharWordSet<String> computeTrie(List<char[]> charpatterns) {
        DoubleArrayCharTrieBuilder builder = new DoubleArrayCharTrieBuilder((DoubleArrayCharTrie)new DoubleArrayCharCompactTrie());
        for (char[] pattern : charpatterns) {
            builder.extend(CharUtils.revert((char[])pattern), (Object)new String(pattern));
        }
        return builder.build();
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(this.trie, this.minLength, this.maxLength, this.charShift, chars, options);
        }
        return new NextMatchFinder(this.trie, this.minLength, this.maxLength, this.charShift, chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class SmartShift
    implements CharShift {
        private CharIntMap characterShift;

        public SmartShift(List<char[]> charpatterns, int minLength) {
            this.characterShift = SmartShift.computeCharacterShift(charpatterns, minLength);
        }

        private static CharIntMap computeCharacterShift(List<char[]> patterns, int minLength) {
            CharIntMap map = new CharIntMap(minLength);
            for (char[] pattern : patterns) {
                for (int i = 0; i < pattern.length - 1; ++i) {
                    int value = map.get(pattern[i]);
                    map.put(pattern[i], Math.min(value, pattern.length - i - 1));
                }
            }
            return map;
        }

        @Override
        public int getShift(char c) {
            return this.characterShift.get(c);
        }
    }

    private static class RelaxedShift
    implements CharShift {
        private int[] characterShift;

        public RelaxedShift(List<char[]> charpatterns, int minLength) {
            this.characterShift = RelaxedShift.computeCharacterShift(charpatterns, minLength);
        }

        private static int[] computeCharacterShift(List<char[]> patterns, int minLength) {
            int[] characters = new int[256];
            for (int i = 0; i < characters.length; ++i) {
                characters[i] = minLength;
            }
            for (char[] pattern : patterns) {
                for (int i = 0; i < pattern.length - 1; ++i) {
                    int newShift = pattern.length - i - 1;
                    int index = pattern[i] % 256;
                    if (newShift >= characters[index]) continue;
                    characters[index] = newShift;
                }
            }
            return characters;
        }

        @Override
        public int getShift(char c) {
            return this.characterShift[c % 256];
        }
    }

    private static class QuickShift
    implements CharShift {
        private char minChar;
        private char maxChar;
        private int[] characterShift;
        private int defaultShift;

        public QuickShift(List<char[]> charpatterns, int minLength) {
            this.minChar = CharUtils.computeMinChar(charpatterns);
            this.maxChar = CharUtils.computeMaxChar(charpatterns);
            this.characterShift = QuickShift.computeCharacterShift(charpatterns, minLength, CharUtils.computeMinChar(charpatterns), CharUtils.computeMaxChar(charpatterns));
            this.defaultShift = minLength;
        }

        private static int[] computeCharacterShift(List<char[]> patterns, int minLength, char min, char max) {
            int[] characters = new int[max - min + 1];
            for (int i = 0; i < characters.length; ++i) {
                characters[i] = minLength;
            }
            for (char[] pattern : patterns) {
                for (int i = 0; i < pattern.length - 1; ++i) {
                    characters[pattern[i] - min] = Math.min(characters[pattern[i] - min], pattern.length - i - 1);
                }
            }
            return characters;
        }

        @Override
        public int getShift(char c) {
            if (c < this.minChar || c > this.maxChar) {
                return this.defaultShift;
            }
            return this.characterShift[c - this.minChar];
        }
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private boolean relaxed;

        public Factory() {
            this(false);
        }

        public Factory(boolean relaxed) {
            this.relaxed = relaxed;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new SetHorspool(patterns, this.relaxed);
        }
    }

    private static class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(CharWordSet<String> trie, int minLength, int maxLength, CharShift charShift, CharProvider chars, StringFinderOption ... options) {
            super(trie, minLength, maxLength, charShift, chars, options);
        }

        @Override
        public StringMatch findNext() {
            long lastStart = this.lastStartFromBuffer();
            int lookahead = this.minLength - 1;
            while (!this.chars.finished(lookahead)) {
                int patternPointer = lookahead;
                long pos = this.chars.current();
                char current = this.chars.lookahead(patternPointer);
                this.cursor.reset();
                boolean success = this.cursor.accept(current);
                while (success) {
                    if (this.cursor.hasAttachments()) {
                        String match = (String)this.cursor.iterator().next();
                        long start = this.chars.current() + (long)patternPointer;
                        long end = this.chars.current() + (long)patternPointer + (long)match.length();
                        StringMatch stringMatch = this.createMatch(start, end);
                        if (lastStart < 0L) {
                            lastStart = start;
                        }
                        this.push(stringMatch);
                    }
                    if (pos + (long)(--patternPointer) < 0L) break;
                    success = this.cursor.accept(this.chars.lookahead(patternPointer));
                }
                this.chars.forward(this.charShift.getShift(current));
                if (!this.bufferContainsLongestMatch(lastStart)) continue;
                break;
            }
            return this.longestLeftMost();
        }

        public boolean bufferContainsLongestMatch(long lastStart) {
            return !this.isBufferEmpty() && this.chars.current() - lastStart > (long)this.maxLength;
        }
    }

    private static class NextMatchFinder
    extends Finder {
        public NextMatchFinder(CharWordSet<String> trie, int minLength, int maxLength, CharShift charShift, CharProvider chars, StringFinderOption ... options) {
            super(trie, minLength, maxLength, charShift, chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            int lookahead = this.minLength - 1;
            while (!this.chars.finished(lookahead)) {
                int patternPointer = lookahead;
                long pos = this.chars.current();
                char current = this.chars.lookahead(patternPointer);
                this.cursor.reset();
                boolean success = this.cursor.accept(current);
                while (success) {
                    if (this.cursor.hasAttachments()) {
                        String match = (String)this.cursor.iterator().next();
                        long start = this.chars.current() + (long)patternPointer;
                        long end = this.chars.current() + (long)patternPointer + (long)match.length();
                        this.push(this.createMatch(start, end));
                    }
                    if (pos + (long)(--patternPointer) < 0L) break;
                    success = this.cursor.accept(this.chars.lookahead(patternPointer));
                }
                this.chars.forward(this.charShift.getShift(current));
                if (this.isBufferEmpty()) continue;
                return this.leftMost();
            }
            return null;
        }
    }

    private static abstract class Finder
    extends BufferedStringFinder {
        protected final int minLength;
        protected final int maxLength;
        protected final CharShift charShift;
        protected CharProvider chars;
        protected CharAutomaton<String> cursor;

        public Finder(CharWordSet<String> trie, int minLength, int maxLength, CharShift charShift, CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.charShift = charShift;
            this.chars = chars;
            this.cursor = trie.cursor();
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            if (last > this.chars.current()) {
                this.chars.move(last);
            }
        }

        protected StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

