/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.text.CharAutomaton;
import net.amygdalum.util.text.CharTrieBuilder;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.CharWordSet;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayCharCompactTrie;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayCharTrie;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayCharTrieBuilder;

public class WuManber
implements StringSearchAlgorithm {
    private static final int SHIFT_SEED = 17;
    private static final int HASH_SEED = 23;
    private static final int SHIFT_SIZE = 255;
    private static final int HASH_SIZE = 127;
    private int minLength;
    private int maxLength;
    private int block;
    private int[] shift;
    private CharWordSet<String>[] hash;

    public WuManber(Collection<String> patterns) {
        List charpatterns = StringUtils.toCharArray(patterns);
        this.minLength = CharUtils.minLength((List)charpatterns);
        this.maxLength = CharUtils.maxLength((List)charpatterns);
        this.block = WuManber.blockSize(this.minLength, charpatterns);
        this.shift = WuManber.computeShift(charpatterns, this.block, this.minLength);
        this.hash = WuManber.computeHash(charpatterns, this.block);
    }

    private static int blockSize(int minLength, List<char[]> charpatterns) {
        char maxChar = CharUtils.computeMaxChar(charpatterns);
        char minChar = CharUtils.computeMinChar(charpatterns);
        int optSize = (int)Math.ceil(Math.log(2 * minLength * charpatterns.size()) / Math.log(maxChar - minChar));
        if (optSize <= 0) {
            return 1;
        }
        if (optSize > minLength) {
            return minLength;
        }
        return optSize;
    }

    private static int[] computeShift(List<char[]> patterns, int block, int minLength) {
        int[] shift = new int[255];
        for (int i = 0; i < shift.length; ++i) {
            shift[i] = minLength - block + 1;
        }
        ArrayList<char[]> patternStrings = new ArrayList<char[]>();
        HashSet<char[]> blocks = new HashSet<char[]>();
        for (char[] pattern : patterns) {
            patternStrings.add(pattern);
            for (int i = 0; i < pattern.length + 1 - block; ++i) {
                blocks.add(Arrays.copyOfRange(pattern, i, i + block));
            }
        }
        for (char[] currentBlock : blocks) {
            int shiftKey = WuManber.shiftHash(currentBlock);
            int shiftBy = shift[shiftKey];
            for (char[] pattern : patternStrings) {
                int rightMost = pattern.length - CharUtils.lastIndexOf((char[])pattern, (char[])currentBlock) - block;
                if (rightMost < 0 || rightMost >= shiftBy) continue;
                shiftBy = rightMost;
            }
            shift[shiftKey] = shiftBy;
        }
        return shift;
    }

    public static int shiftHash(char[] block) {
        int result = 1;
        for (char c : block) {
            result = 17 * result + c;
        }
        int hash = result % 255;
        if (hash < 0) {
            hash += 255;
        }
        return hash;
    }

    private static CharWordSet<String>[] computeHash(List<char[]> charpatterns, int block) {
        CharTrieBuilder[] builders = new CharTrieBuilder[127];
        for (char[] pattern : charpatterns) {
            char[] lastBlock = Arrays.copyOfRange(pattern, pattern.length - block, pattern.length);
            int hashKey = WuManber.hashHash(lastBlock);
            CharTrieBuilder builder = builders[hashKey];
            if (builder == null) {
                builders[hashKey] = builder = new DoubleArrayCharTrieBuilder((DoubleArrayCharTrie)new DoubleArrayCharCompactTrie());
            }
            builder.extend(CharUtils.revert((char[])pattern), (Object)new String(pattern));
        }
        CharWordSet[] hash = new CharWordSet[builders.length];
        for (int i = 0; i < hash.length; ++i) {
            hash[i] = builders[i] == null ? null : builders[i].build();
        }
        return hash;
    }

    public static int hashHash(char[] block) {
        int result = 1;
        for (char c : block) {
            result = 23 * result + c;
        }
        int hash = result % 127;
        if (hash < 0) {
            hash += 127;
        }
        return hash;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(this.minLength, this.maxLength, this.block, this.shift, this.hash, chars, options);
        }
        return new NextMatchFinder(this.minLength, this.maxLength, this.block, this.shift, this.hash, chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new WuManber(patterns);
        }
    }

    private static class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(int minLength, int maxLength, int block, int[] shift, CharWordSet<String>[] hash, CharProvider chars, StringFinderOption ... options) {
            super(minLength, maxLength, block, shift, hash, chars, options);
        }

        @Override
        public StringMatch findNext() {
            long lastStart = this.lastStartFromBuffer();
            while (!this.chars.finished(this.lookahead)) {
                long pos = this.chars.current();
                char[] lastBlock = this.chars.between(pos + (long)this.minLength - (long)this.block, pos + (long)this.minLength);
                int shiftKey = WuManber.shiftHash(lastBlock);
                int shiftBy = this.shift[shiftKey];
                if (shiftBy == 0) {
                    int hashkey = WuManber.hashHash(lastBlock);
                    CharAutomaton cursor = this.hash[hashkey];
                    cursor.reset();
                    int patternPointer = this.lookahead;
                    boolean success = cursor.accept(this.chars.lookahead(patternPointer));
                    while (success) {
                        if (cursor.hasAttachments()) {
                            String match = (String)cursor.iterator().next();
                            long start = this.chars.current() + (long)patternPointer;
                            long end = this.chars.current() + (long)patternPointer + (long)match.length();
                            StringMatch stringMatch = this.createMatch(start, end);
                            if (lastStart < 0L) {
                                lastStart = start;
                            }
                            this.push(stringMatch);
                        }
                        if (pos + (long)(--patternPointer) < 0L) break;
                        success = cursor.accept(this.chars.lookahead(patternPointer));
                    }
                    this.chars.next();
                    if (!this.bufferContainsLongestMatch(lastStart)) continue;
                    break;
                }
                this.chars.forward(shiftBy);
            }
            return this.longestLeftMost();
        }

        public boolean bufferContainsLongestMatch(long lastStart) {
            return !this.isBufferEmpty() && this.chars.current() - lastStart - 1L > (long)(this.maxLength - this.minLength);
        }
    }

    private static class NextMatchFinder
    extends Finder {
        public NextMatchFinder(int minLength, int maxLength, int block, int[] shift, CharWordSet<String>[] hash, CharProvider chars, StringFinderOption ... options) {
            super(minLength, maxLength, block, shift, hash, chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            while (!this.chars.finished(this.lookahead)) {
                long pos = this.chars.current();
                char[] lastBlock = this.chars.between(pos + (long)this.minLength - (long)this.block, pos + (long)this.minLength);
                int shiftKey = WuManber.shiftHash(lastBlock);
                int shiftBy = this.shift[shiftKey];
                if (shiftBy == 0) {
                    int hashkey = WuManber.hashHash(lastBlock);
                    CharAutomaton cursor = this.hash[hashkey];
                    cursor.reset();
                    int patternPointer = this.lookahead;
                    boolean success = cursor.accept(this.chars.lookahead(patternPointer));
                    while (success) {
                        if (cursor.hasAttachments()) {
                            String match = (String)cursor.iterator().next();
                            long start = this.chars.current() + (long)patternPointer;
                            long end = this.chars.current() + (long)patternPointer + (long)match.length();
                            this.push(this.createMatch(start, end));
                        }
                        if (pos + (long)(--patternPointer) < 0L) break;
                        success = cursor.accept(this.chars.lookahead(patternPointer));
                    }
                    this.chars.next();
                    if (this.isBufferEmpty()) continue;
                    return this.leftMost();
                }
                this.chars.forward(shiftBy);
            }
            return null;
        }
    }

    private static abstract class Finder
    extends BufferedStringFinder {
        protected final int minLength;
        protected final int lookahead;
        protected final int maxLength;
        protected final int block;
        protected final int[] shift;
        protected CharProvider chars;
        protected CharAutomaton<String>[] hash;

        public Finder(int minLength, int maxLength, int block, int[] shift, CharWordSet<String>[] hash, CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.minLength = minLength;
            this.lookahead = minLength - 1;
            this.maxLength = maxLength;
            this.block = block;
            this.shift = shift;
            this.hash = Finder.cursor(hash);
            this.chars = chars;
        }

        private static CharAutomaton<String>[] cursor(CharWordSet<String>[] hash) {
            CharAutomaton[] cursors = new CharAutomaton[hash.length];
            for (int i = 0; i < hash.length; ++i) {
                CharWordSet<String> node = hash[i];
                cursors[i] = node == null ? CharAutomaton.NULL : node.cursor();
            }
            return cursors;
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            if (last > this.chars.current()) {
                this.chars.move(last);
            }
        }

        protected StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

