/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.ByteAutomaton;
import net.amygdalum.util.text.ByteConnectionAdaptor;
import net.amygdalum.util.text.ByteNode;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteTask;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.ByteWordGraphCompiler;
import net.amygdalum.util.text.ByteWordSet;
import net.amygdalum.util.text.ByteWordSetBuilder;
import net.amygdalum.util.text.JoinStrategy;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.linkeddawg.LinkedByteDawgCompiler;

public class SetBackwardOracleMatching
implements StringSearchAlgorithm {
    private ByteWordSet<List<byte[]>> trie;
    private int minLength;

    public SetBackwardOracleMatching(Collection<String> patterns, Charset charset) {
        List bytepatterns = StringUtils.toByteArray(patterns, (Charset)charset);
        this.minLength = ByteUtils.minLength((List)bytepatterns);
        this.trie = SetBackwardOracleMatching.computeTrie(bytepatterns, this.minLength);
    }

    private static ByteWordSet<List<byte[]>> computeTrie(List<byte[]> bytepatterns, int length) {
        ByteWordSetBuilder builder = new ByteWordSetBuilder((ByteWordGraphCompiler)new LinkedByteDawgCompiler(), (JoinStrategy)new MergePatterns());
        for (byte[] pattern : bytepatterns) {
            byte[] prefix = Arrays.copyOfRange(pattern, 0, length);
            byte[] reversePrefix = ByteUtils.revert((byte[])prefix);
            byte[] suffix = Arrays.copyOfRange(pattern, length, pattern.length);
            builder.extend(reversePrefix, Arrays.asList(prefix, suffix));
        }
        builder.work((ByteTask)new BuildOracle());
        return (ByteWordSet)builder.build();
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        return new Finder(this.trie, this.minLength, bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new SetBackwardOracleMatching(patterns, this.charset);
        }
    }

    private static class Finder
    extends AbstractStringFinder {
        private final int minLength;
        private final int lookahead;
        private ByteProvider bytes;
        private ByteAutomaton<List<byte[]>> cursor;
        private Queue<StringMatch> buffer;

        public Finder(ByteWordSet<List<byte[]>> trie, int minLength, ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.minLength = minLength;
            this.lookahead = minLength - 1;
            this.bytes = bytes;
            this.cursor = trie.cursor();
            this.buffer = new LinkedList<StringMatch>();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.buffer.clear();
        }

        @Override
        public StringMatch findNext() {
            if (!this.buffer.isEmpty()) {
                return this.buffer.remove();
            }
            while (!this.bytes.finished(this.lookahead)) {
                List patterns;
                Iterator iPatterns;
                byte[] prefix;
                int j;
                this.cursor.reset();
                boolean success = true;
                for (j = this.lookahead; j >= 0 && success; --j) {
                    success = this.cursor.accept(this.bytes.lookahead(j));
                }
                long currentWindowStart = this.bytes.current();
                long currentPos = currentWindowStart + (long)j + 1L;
                long currentWindowEnd = currentWindowStart + (long)this.minLength;
                byte[] matchedPrefix = this.bytes.between(currentPos, currentWindowEnd);
                if (success && j < 0 && Arrays.equals(prefix = (byte[])(iPatterns = (patterns = (List)this.cursor.iterator().next()).iterator()).next(), matchedPrefix)) {
                    while (iPatterns.hasNext()) {
                        byte[] matchedSuffix;
                        byte[] suffix = (byte[])iPatterns.next();
                        long currentWordEnd = currentWindowEnd + (long)suffix.length;
                        if (this.bytes.finished((int)(currentWordEnd - currentWindowStart - 1L)) || !Arrays.equals(suffix, matchedSuffix = this.bytes.between(currentWindowEnd, currentWordEnd))) continue;
                        this.buffer.add(this.createMatch(currentWindowStart, currentWordEnd));
                    }
                    this.bytes.next();
                    if (this.buffer.isEmpty()) continue;
                    return this.buffer.remove();
                }
                if (j <= 0) {
                    this.bytes.next();
                    continue;
                }
                this.bytes.forward(j + 1);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }

    public static class BuildOracle
    implements ByteTask<List<byte[]>> {
        private Map<ByteNode<List<byte[]>>, ByteNode<List<byte[]>>> oracle = new IdentityHashMap<ByteNode<List<byte[]>>, ByteNode<List<byte[]>>>();
        private ByteNode<List<byte[]>> init;

        public List<ByteNode<List<byte[]>>> init(ByteNode<List<byte[]>> root) {
            this.init = root;
            return Arrays.asList(root);
        }

        public List<ByteNode<List<byte[]>>> process(ByteNode<List<byte[]>> node) {
            ArrayList<ByteNode<List<byte[]>>> nexts = new ArrayList<ByteNode<List<byte[]>>>();
            for (byte b : node.getAlternatives()) {
                ByteNode current = node.nextNode(b);
                ByteNode<List<byte[]>> down = this.oracle.get(node);
                while (down != null) {
                    ByteNode next = down.nextNode(b);
                    if (next != null) {
                        this.oracle.put((ByteNode<List<byte[]>>)current, (ByteNode<List<byte[]>>)next);
                        break;
                    }
                    this.addNextNode(down, b, (ByteNode<List<byte[]>>)current);
                    down = this.oracle.get(down);
                }
                if (down == null) {
                    this.oracle.put((ByteNode<List<byte[]>>)current, this.init);
                }
                nexts.add((ByteNode<List<byte[]>>)current);
            }
            return nexts;
        }

        private void addNextNode(ByteNode<List<byte[]>> node, byte b, ByteNode<List<byte[]>> next) {
            ((ByteConnectionAdaptor)node).addNextNode(b, next);
        }
    }

    public static class MergePatterns
    implements JoinStrategy<List<byte[]>> {
        public List<byte[]> join(List<byte[]> existing, List<byte[]> next) {
            if (existing == null) {
                return new ArrayList<byte[]>(next);
            }
            existing.add(next.get(1));
            return existing;
        }
    }
}

