/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.codegen.core;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.Supertype;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;

public final class CodegenUtils {
    private CodegenUtils() {
    }

    public static Set<Property> getProperties(EntityType model) {
        Supertype supertype = model.getSuperType();
        if (supertype != null) {
            Class superClass = supertype.getType().getJavaClass();
            TreeSet<Property> properties = new TreeSet<Property>();
            for (Property property : model.getProperties()) {
                String propertyName = property.getEscapedName();
                if (CodegenUtils.findField(superClass, propertyName) != null) continue;
                properties.add(property);
            }
            return properties;
        }
        return model.getProperties();
    }

    public static Field findAccessibleField(Class<?> classType, String fieldName) {
        int modifiers;
        Field field = CodegenUtils.findField(classType, fieldName);
        if (field != null && (Modifier.isProtected(modifiers = field.getModifiers()) || Modifier.isPublic(modifiers))) {
            return field;
        }
        return null;
    }

    private static Field findField(Class<?> classType, String fieldName) {
        if (classType == null || classType == Object.class) {
            return null;
        }
        try {
            Field field = classType.getDeclaredField(fieldName);
            if (field != null) {
                return field;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CodegenUtils.findField(classType.getSuperclass(), fieldName);
    }

    public static String getTypeName(Class<?> classType) {
        if (classType.isArray()) {
            try {
                Class<?> cl = classType;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classType.getName();
    }
}

