/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.codegen.core;

import com.j256.ormlite.field.DataType;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.Supertype;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.codegen.NamingStrategy;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import net.apexes.codegen.core.CodegenUtils;
import net.apexes.commons.ormlite.Column;
import net.apexes.commons.ormlite.Table;

public class ColumnMetadataSerializer
implements Serializer {
    protected final TypeMappings typeMappings;
    protected final Collection<String> keywords;
    private final NamingStrategy namingStrategy;
    private final Set<String> imports;

    @Inject
    public ColumnMetadataSerializer(TypeMappings typeMappings, NamingStrategy namingStrategy, @Named(value="innerClassesForKeys") boolean innerClassesForKeys, @Named(value="imports") Set<String> imports, @Named(value="columnComparator") Comparator<Property> columnComparator, @Named(value="entityPathType") Class<?> entityPathType) {
        this.typeMappings = typeMappings;
        this.keywords = Collections.emptyList();
        this.namingStrategy = namingStrategy;
        this.imports = new HashSet<String>(imports);
    }

    public void serialize(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        Set<Property> properties = CodegenUtils.getProperties(model);
        Type queryType = this.typeMappings.getPathType((Type)model, model, false);
        if (!queryType.getPackageName().isEmpty()) {
            writer.packageDecl(queryType.getPackageName());
        }
        TreeSet<String> importClasses = new TreeSet<String>();
        if (!(model.getPackageName().isEmpty() || queryType.getPackageName().equals(model.getPackageName()) || queryType.getSimpleName().equals(model.getSimpleName()))) {
            String packageName;
            String fullName = model.getFullName();
            if (fullName.substring((packageName = model.getPackageName()).length() + 1).contains(".")) {
                fullName = fullName.substring(0, fullName.lastIndexOf(46));
            }
            importClasses.add(fullName);
        }
        importClasses.add(Column.class.getName());
        for (Property property : properties) {
            switch (property.getType().getCategory()) {
                case DATE: 
                case DATETIME: 
                case TIME: {
                    importClasses.add(DataType.class.getName());
                    break;
                }
            }
        }
        writer.importClasses(importClasses.toArray(new String[0]));
        this.writeUserImports(writer);
        this.introJavadoc(writer, model);
        this.introClassHeader(writer, model);
        if (config.createDefaultVariable()) {
            this.introDefaultInstance(writer, model, config.defaultVariableName());
        }
        this.serializeProperties(model, properties, writer);
        this.constructors(model, config, writer);
        this.outro(model, writer);
    }

    protected void writeUserImports(CodeWriter writer) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        HashSet<String> classes = new HashSet<String>();
        for (String javaImport : this.imports) {
            boolean isClass = Character.isUpperCase(javaImport.charAt(javaImport.lastIndexOf(".") + 1));
            if (isClass) {
                classes.add(javaImport);
                continue;
            }
            packages.add(javaImport);
        }
        if (!packages.isEmpty()) {
            writer.importPackages(packages.toArray(new String[0]));
        }
        if (!classes.isEmpty()) {
            writer.importClasses(classes.toArray(new String[0]));
        }
    }

    protected void introJavadoc(CodeWriter writer, EntityType model) throws IOException {
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        writer.javadoc(new String[]{queryType.getSimpleName() + " is a ORMLite query type for " + model.getSimpleName(), "@see " + model.getFullName()});
    }

    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Type superType;
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        TypeCategory category = model.getOriginalCategory();
        Supertype supertype = model.getSuperType();
        if (supertype != null) {
            superType = supertype.getType();
            superType = this.typeMappings.getPathType(superType, null, false);
        } else {
            superType = new ClassType(category, Table.class, new Type[]{model});
        }
        writer.beginClass(queryType, superType, new Type[0]);
    }

    protected void introDefaultInstance(CodeWriter writer, EntityType entityType, String defaultName) throws IOException {
        String variableName = !defaultName.isEmpty() ? defaultName : this.namingStrategy.getDefaultVariableName(entityType);
        Type queryType = this.typeMappings.getPathType((Type)entityType, entityType, true);
        String table = (String)entityType.getData().get("table");
        writer.publicStaticFinal(queryType, variableName, "new " + queryType.getSimpleName() + "(\"" + table + "\")");
    }

    protected void serializeProperties(EntityType model, Set<Property> properties, CodeWriter writer) throws IOException {
        SimpleType colmumType = new SimpleType(Column.class.getSimpleName());
        StringBuilder sb = new StringBuilder();
        for (Property property : properties) {
            String propertyName = property.getEscapedName();
            sb.setLength(0);
            sb.append("field(\"").append(propertyName).append("\")");
            switch (property.getType().getCategory()) {
                case DATE: 
                case DATETIME: 
                case TIME: {
                    sb.append(".dataType(DataType.DATE)");
                    break;
                }
            }
            ColumnMetadata metadata = (ColumnMetadata)property.getData().get("COLUMN");
            sb.append(".columnName(\"").append(metadata.getName()).append("\")");
            if (!metadata.isNullable()) {
                sb.append(".notNull()");
            }
            sb.append(".build()");
            writer.javadoc(new String[]{metadata.getName(), "@see " + model.getFullName() + "#" + propertyName});
            writer.publicFinal((Type)colmumType, propertyName, sb.toString());
        }
    }

    protected void constructors(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        String localName = writer.getRawName((Type)model);
        writer.beginConstructor(new Parameter[]{new Parameter("tableName", (Type)Types.STRING)});
        writer.line(new String[]{"super(", writer.getClassConstant(localName), ", tableName);"});
        this.constructorContent(writer, model);
        writer.end();
    }

    protected void constructorContent(CodeWriter writer, EntityType model) throws IOException {
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }
}

