/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.codegen.core;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.Types;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.Supertype;
import com.querydsl.core.util.BeanUtils;
import com.querydsl.sql.ColumnMetadata;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.apexes.codegen.core.CodegenUtils;

public class JavabeanSerializer
implements Serializer {
    private static final Function<Property, Parameter> propertyToParameter = new Function<Property, Parameter>(){

        public Parameter apply(Property input) {
            return new Parameter(input.getName(), input.getType());
        }
    };
    private final boolean propertyAnnotations;
    private final List<Type> interfaces = Lists.newArrayList();
    private final String javadocSuffix;
    private boolean addToString;
    private boolean addFullConstructor;
    private boolean addCloneFrom;
    private boolean printSupertype = false;

    public JavabeanSerializer() {
        this(true, " is a Querydsl bean type");
    }

    public JavabeanSerializer(String javadocSuffix) {
        this(true, javadocSuffix);
    }

    public JavabeanSerializer(boolean propertyAnnotations) {
        this(propertyAnnotations, " is a Querydsl bean type");
    }

    public JavabeanSerializer(boolean propertyAnnotations, String javadocSuffix) {
        this.propertyAnnotations = propertyAnnotations;
        this.javadocSuffix = javadocSuffix;
        this.setPrintSupertype(true);
    }

    public void serialize(EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        Set<String> importedClasses = this.getAnnotationTypes(model);
        for (Type iface : this.interfaces) {
            importedClasses.add(iface.getFullName());
        }
        if (model.hasLists()) {
            importedClasses.add(List.class.getName());
        }
        if (model.hasCollections()) {
            importedClasses.add(Collection.class.getName());
        }
        if (model.hasSets()) {
            importedClasses.add(Set.class.getName());
        }
        if (model.hasMaps()) {
            importedClasses.add(Map.class.getName());
        }
        if (this.addToString && model.hasArrays()) {
            importedClasses.add(Arrays.class.getName());
        }
        writer.importClasses(importedClasses.toArray(new String[importedClasses.size()]));
        writer.javadoc(new String[]{simpleName + this.javadocSuffix + ". the database table \"" + model.getData().get("table") + "\""});
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        if (!this.interfaces.isEmpty()) {
            Type superType = null;
            if (this.printSupertype && model.getSuperType() != null) {
                superType = model.getSuperType().getType();
            }
            Type[] ifaces = this.interfaces.toArray(new Type[this.interfaces.size()]);
            writer.beginClass((Type)model, superType, ifaces);
        } else if (this.printSupertype && model.getSuperType() != null) {
            writer.beginClass((Type)model, model.getSuperType().getType(), new Type[0]);
        } else {
            writer.beginClass((Type)model);
        }
        this.bodyStart(model, writer);
        if (this.addFullConstructor) {
            this.addFullConstructor(model, writer);
        }
        Set<Property> properties = CodegenUtils.getProperties(model);
        this.serializeProperties(model, properties, writer);
        if (this.addCloneFrom) {
            this.addCloneFrom(model, writer);
        }
        if (this.addToString) {
            this.addToString(properties, writer);
        }
        this.bodyEnd(model, writer);
        writer.end();
    }

    protected void serializeProperties(EntityType model, Set<Property> properties, CodeWriter writer) throws IOException {
        for (Property property : properties) {
            if (this.propertyAnnotations) {
                for (Annotation annotation : property.getAnnotations()) {
                    writer.annotation(annotation);
                }
            }
            ColumnMetadata metadata = (ColumnMetadata)property.getData().get("COLUMN");
            writer.javadoc(new String[]{metadata.getName()});
            writer.privateField(property.getType(), property.getEscapedName());
        }
        for (Property property : properties) {
            String propertyName = property.getEscapedName();
            writer.beginPublicMethod(property.getType(), "get" + BeanUtils.capitalize((String)propertyName), new Parameter[0]);
            writer.line(new String[]{"return ", propertyName, ";"});
            writer.end();
            Parameter parameter = new Parameter(propertyName, property.getType());
            writer.beginPublicMethod((Type)Types.VOID, "set" + BeanUtils.capitalize((String)propertyName), new Parameter[]{parameter});
            writer.line(new String[]{"this.", propertyName, " = ", propertyName, ";"});
            writer.end();
        }
    }

    protected void addFullConstructor(EntityType model, CodeWriter writer) throws IOException {
        writer.beginConstructor(new Parameter[0]);
        writer.end();
        writer.beginConstructor((Collection)model.getProperties(), propertyToParameter);
        for (Property property : model.getProperties()) {
            writer.line(new String[]{"this.", property.getEscapedName(), " = ", property.getEscapedName(), ";"});
        }
        writer.end();
    }

    protected void addToString(Set<Property> properties, CodeWriter writer) throws IOException {
        if (!properties.isEmpty()) {
            writer.line(new String[]{"@Override"});
            writer.beginPublicMethod((Type)Types.STRING, "toString", new Parameter[0]);
            writer.line(new String[]{"StringBuilder sb = new StringBuilder();"});
            writer.line(new String[]{"sb.append(super.toString());"});
            for (Property property : properties) {
                String propertyName = property.getEscapedName();
                writer.line(new String[]{"sb.append(\",", propertyName, "=\").append(", propertyName, ");"});
            }
            writer.line(new String[]{"return sb.toString();"});
            writer.end();
        }
    }

    protected void addCloneFrom(EntityType model, CodeWriter writer) throws IOException {
        Parameter parameter = new Parameter("from", (Type)model);
        writer.beginPublicMethod((Type)Types.VOID, "cloneFrom", new Parameter[]{parameter});
        Supertype supertype = model.getSuperType();
        if (supertype != null) {
            Class superClass = supertype.getType().getJavaClass();
            try {
                boolean superHasCloneFrom = false;
                for (Method method : superClass.getDeclaredMethods()) {
                    int m;
                    if (!"cloneFrom".equals(method.getName()) || !Modifier.isPublic(m = method.getModifiers()) && !Modifier.isProtected(m)) continue;
                    superHasCloneFrom = true;
                    break;
                }
                if (superHasCloneFrom) {
                    writer.line(new String[]{"super.cloneFrom(from);"});
                }
            }
            catch (Exception superHasCloneFrom) {
                // empty catch block
            }
        }
        for (Property property : CodegenUtils.getProperties(model)) {
            String propertyName = property.getEscapedName();
            Class classType = property.getType().getJavaClass();
            boolean canClone = Cloneable.class.isAssignableFrom(classType);
            if (canClone) {
                writer.line(new String[]{"this.", propertyName, " = from.", propertyName, " == null ? null : (", CodegenUtils.getTypeName(classType), ") from.", propertyName, ".clone();"});
                continue;
            }
            writer.line(new String[]{"this.", propertyName, " = from.", propertyName, ";"});
        }
        writer.end();
    }

    protected void bodyStart(EntityType model, CodeWriter writer) throws IOException {
        Class superClass;
        Supertype supertype = model.getSuperType();
        if (supertype != null && Serializable.class.isAssignableFrom(superClass = supertype.getType().getJavaClass())) {
            writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", "1L");
        }
    }

    protected void bodyEnd(EntityType model, CodeWriter writer) throws IOException {
    }

    private Set<String> getAnnotationTypes(EntityType model) {
        HashSet<String> imports = new HashSet<String>();
        for (Annotation annotation : model.getAnnotations()) {
            imports.add(annotation.annotationType().getName());
        }
        if (this.propertyAnnotations) {
            for (Property property : model.getProperties()) {
                for (Annotation annotation : property.getAnnotations()) {
                    imports.add(annotation.annotationType().getName());
                }
            }
        }
        return imports;
    }

    public void addInterface(Class<?> iface) {
        this.interfaces.add((Type)new ClassType(iface, new Type[0]));
    }

    public void addInterface(Type type) {
        this.interfaces.add(type);
    }

    public void setAddToString(boolean addToString) {
        this.addToString = addToString;
    }

    public void setAddFullConstructor(boolean addFullConstructor) {
        this.addFullConstructor = addFullConstructor;
    }

    public void setAddCloneFrom(boolean addCloneFrom) {
        this.addCloneFrom = addCloneFrom;
    }

    public void setPrintSupertype(boolean printSupertype) {
        this.printSupertype = printSupertype;
    }
}

