/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.codegen.core;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.ScalaWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.querydsl.codegen.AbstractModule;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.Supertype;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.sql.ColumnImpl;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLTemplatesRegistry;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.SQLCodegenModule;
import com.querydsl.sql.codegen.SpatialSupport;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import com.querydsl.sql.codegen.support.InverseForeignKeyData;
import com.querydsl.sql.codegen.support.NotNullImpl;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import com.querydsl.sql.codegen.support.SizeImpl;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.apexes.codegen.core.IndexData;
import net.apexes.codegen.core.SuperType;
import net.apexes.codegen.core.TableFilter;
import net.apexes.commons.querydsl.info.ColumnInfo;
import net.apexes.commons.querydsl.info.ForeignKeyInfo;
import net.apexes.commons.querydsl.info.IndexInfo;
import net.apexes.commons.querydsl.info.PrimaryKeyInfo;
import net.apexes.commons.querydsl.info.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExporter {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataExporter.class);
    private final SQLTemplatesRegistry sqlTemplatesRegistry = new SQLTemplatesRegistry();
    private final SQLCodegenModule module = new SQLCodegenModule();
    private final Set<String> classes = new HashSet<String>();
    private File targetFolder;
    private File beansTargetFolder;
    @Nullable
    private String beanPackageName;
    @Nullable
    private String schemaPattern;
    @Nullable
    private String tableNamePattern;
    @Nullable
    private Serializer beanSerializer;
    private boolean createScalaSources = false;
    private final Map<EntityType, Type> entityToWrapped = new HashMap<EntityType, Type>();
    private Serializer serializer;
    private TypeMappings typeMappings;
    private QueryTypeFactory queryTypeFactory;
    private NamingStrategy namingStrategy;
    private Configuration configuration;
    private KeyDataConvertor keyDataConvertor;
    private boolean columnAnnotations = false;
    private boolean validationAnnotations = false;
    private boolean schemaToPackage = false;
    private String sourceEncoding = "UTF-8";
    private boolean lowerCase = false;
    private boolean exportTables = true;
    private boolean exportViews = true;
    private boolean exportAll = false;
    private boolean exportKeys = true;
    private boolean ignoreMetadata = false;
    private boolean spatial = false;
    @Nullable
    private String tableTypesToExport;

    protected EntityType createEntityType(SchemaAndTable schemaAndTable, String className) {
        EntityType classModel;
        if (this.beanSerializer == null) {
            String packageName = this.normalizePackage(this.module.getPackageName(), schemaAndTable);
            String simpleName = this.module.getPrefix() + className + this.module.getSuffix();
            SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, packageName + "." + simpleName, packageName, simpleName, false, false, new Type[0]);
            classModel = new EntityType((Type)classTypeModel, (Function)this.module.get(Function.class, "variableNameFunction"));
            this.typeMappings.register((Type)classModel, (Type)classModel);
        } else {
            String beanPackage = this.normalizePackage(this.beanPackageName, schemaAndTable);
            String simpleName = this.module.getBeanPrefix() + className + this.module.getBeanSuffix();
            SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, beanPackage + "." + simpleName, beanPackage, simpleName, false, false, new Type[0]);
            classModel = new EntityType((Type)classTypeModel, (Function)this.module.get(Function.class, "variableNameFunction"));
            Type mappedType = this.queryTypeFactory.create((Type)classModel);
            this.entityToWrapped.put(classModel, mappedType);
            this.typeMappings.register((Type)classModel, mappedType);
        }
        classModel.getData().put("schema", schemaAndTable.getSchema());
        classModel.getData().put("table", schemaAndTable.getTable());
        SuperType supertype = this.getSuperType(classModel);
        if (supertype != null) {
            classModel.addSupertype((Supertype)supertype);
            this.typeMappings.register(supertype.getType(), supertype.getQueryType());
        }
        return classModel;
    }

    private String normalizePackage(String packageName, SchemaAndTable schemaAndTable) {
        String rval = packageName;
        if (this.schemaToPackage) {
            rval = this.namingStrategy.getPackage(rval, schemaAndTable);
        }
        return rval;
    }

    protected Property createProperty(EntityType classModel, String normalizedColumnName, String propertyName, Type typeModel) {
        return new Property(classModel, propertyName, propertyName, typeModel, Collections.emptyList(), false);
    }

    public void export(DatabaseMetaData md) throws Exception {
        this.export(md, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(DatabaseMetaData md, TableFilter tableFilter) throws Exception {
        ArrayList<String> types;
        if (this.beanPackageName == null) {
            this.beanPackageName = this.module.getPackageName();
        }
        if (this.beansTargetFolder == null) {
            this.beansTargetFolder = this.targetFolder;
        }
        this.module.bind("beanPackageName", (Object)this.beanPackageName);
        if (this.spatial) {
            SpatialSupport.addSupport((AbstractModule)this.module);
        }
        this.classes.clear();
        this.typeMappings = (TypeMappings)this.module.get(TypeMappings.class);
        this.queryTypeFactory = (QueryTypeFactory)this.module.get(QueryTypeFactory.class);
        this.serializer = (Serializer)this.module.get(Serializer.class);
        this.beanSerializer = (Serializer)this.module.get(Serializer.class, "beanSerializer");
        this.namingStrategy = (NamingStrategy)this.module.get(NamingStrategy.class);
        this.configuration = (Configuration)this.module.get(Configuration.class);
        SQLTemplates templates = this.sqlTemplatesRegistry.getTemplates(md);
        if (templates != null) {
            this.configuration.setTemplates(templates);
        } else {
            logger.info("Found no specific dialect for " + md.getDatabaseProductName());
        }
        this.keyDataConvertor = this.beanSerializer == null ? new KeyDataConvertor(this.namingStrategy, this.module.getPackageName(), this.module.getPrefix(), this.module.getSuffix(), this.schemaToPackage) : new KeyDataConvertor(this.namingStrategy, this.beanPackageName, this.module.getBeanPrefix(), this.module.getBeanSuffix(), this.schemaToPackage);
        String[] typesArray = null;
        if (this.tableTypesToExport != null && !this.tableTypesToExport.isEmpty()) {
            types = new ArrayList<String>();
            for (String tableType : this.tableTypesToExport.split(",")) {
                types.add(tableType.trim());
            }
            typesArray = types.toArray(new String[types.size()]);
        } else if (!this.exportAll) {
            types = new ArrayList(2);
            if (this.exportTables) {
                types.add("TABLE");
            }
            if (this.exportViews) {
                types.add("VIEW");
            }
            typesArray = types.toArray(new String[types.size()]);
        }
        ImmutableList schemaPatterns = Arrays.asList(this.schemaPattern);
        if (this.schemaPattern != null && this.schemaPattern.contains(",")) {
            schemaPatterns = ImmutableList.copyOf((Object[])this.schemaPattern.split(","));
        }
        ImmutableList tablePatterns = Arrays.asList(this.tableNamePattern);
        if (this.tableNamePattern != null && this.tableNamePattern.contains(",")) {
            tablePatterns = ImmutableList.copyOf((Object[])this.tableNamePattern.split(","));
        }
        for (String schemaPattern : schemaPatterns) {
            schemaPattern = schemaPattern != null ? schemaPattern.trim() : null;
            for (String tablePattern : tablePatterns) {
                tablePattern = tablePattern != null ? tablePattern.trim() : null;
                try (ResultSet tables = md.getTables(null, schemaPattern, tablePattern, typesArray);){
                    while (tables.next()) {
                        String catalog = tables.getString("TABLE_CAT");
                        String schema = tables.getString("TABLE_SCHEM");
                        String tableName = this.normalize(tables.getString("TABLE_NAME"));
                        if (tableFilter != null) {
                            if (!tableFilter.accept(catalog, schema, tableName)) continue;
                            this.handleTable(md, catalog, schema, tableName);
                            continue;
                        }
                        this.handleTable(md, catalog, schema, tableName);
                    }
                }
            }
        }
    }

    private void handleTable(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        logger.info("{}.{} ...", (Object)schema, (Object)tableName);
        String schemaName = this.normalize(schema);
        String normalizedSchemaName = this.namingStrategy.normalizeSchemaName(schemaName);
        String normalizedTableName = this.namingStrategy.normalizeTableName(tableName);
        SchemaAndTable schemaAndTable = new SchemaAndTable(normalizedSchemaName, normalizedTableName);
        if (!this.namingStrategy.shouldGenerateClass(schemaAndTable)) {
            return;
        }
        String className = this.namingStrategy.getClassName(schemaAndTable);
        EntityType classModel = this.createEntityType(schemaAndTable, className);
        TableInfo tableInfo = new TableInfo(md, catalog, schema, tableName, this.lowerCase);
        if (this.exportKeys) {
            List ixInfos;
            List invFkInfos;
            List fkInfos;
            PrimaryKeyInfo pkInfo = tableInfo.getPrimaryKey();
            if (pkInfo != null) {
                PrimaryKeyData pkData = new PrimaryKeyData(pkInfo.getName(), pkInfo.getColumns().toArray(new String[0]));
                classModel.getData().put(PrimaryKeyData.class, Arrays.asList(pkData));
            }
            if (!(fkInfos = tableInfo.getImportedKeys()).isEmpty()) {
                Collection<ForeignKeyData> fkDatas = this.keyDataConvertor.toForeignKeyData(fkInfos);
                for (ForeignKeyData fkd : fkDatas) {
                    if (!this.namingStrategy.shouldGenerateForeignKey(schemaAndTable, fkd)) continue;
                    classModel.getData().put(ForeignKeyData.class, fkDatas);
                }
            }
            if (!(invFkInfos = tableInfo.getExportedKeys()).isEmpty()) {
                classModel.getData().put(InverseForeignKeyData.class, this.keyDataConvertor.toInverseForeignKeyData(invFkInfos));
            }
            if (!(ixInfos = tableInfo.getIndexs()).isEmpty()) {
                classModel.getData().put(IndexData.class, this.keyDataConvertor.toIndexData(ixInfos));
            }
        }
        for (ColumnInfo columnInfo : tableInfo.getColumns()) {
            this.handleColumn(classModel, tableName, columnInfo);
        }
        this.serialize(classModel, schemaAndTable);
        logger.info("{}.{} successfully!", (Object)schema, (Object)tableName);
    }

    private void handleColumn(EntityType classModel, String tableName, ColumnInfo columnInfo) throws SQLException {
        String columnName = columnInfo.getName();
        String normalizedColumnName = columnInfo.getNormalizedName();
        int columnType = columnInfo.getJdbcType();
        String typeName = columnInfo.getTypeName();
        Integer columnSize = columnInfo.getSize();
        Integer columnDigits = columnInfo.getDigits();
        int columnIndex = columnInfo.getIndex();
        String defaultValue = columnInfo.getDefaultValue();
        String describe = columnInfo.getDescribe();
        ColumnMetadata column = ColumnMetadata.named((String)normalizedColumnName).ofType(columnType).withIndex(columnIndex);
        if (columnInfo.isNotNullable()) {
            column = column.notNull();
        }
        if (columnSize != null && columnSize > 0) {
            column = column.withSize(((Number)columnSize).intValue());
        }
        if (columnDigits != null) {
            column = column.withDigits(((Number)columnDigits).intValue());
        }
        String propertyName = this.namingStrategy.getPropertyName(normalizedColumnName, classModel);
        Class<Object> clazz = this.configuration.getJavaType(columnType, typeName, columnSize != null ? columnSize : 0, columnDigits != null ? columnDigits : 0, tableName, columnName);
        if (clazz == null) {
            clazz = Object.class;
        }
        TypeCategory fieldType = TypeCategory.get((String)clazz.getName());
        if (Number.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.NUMERIC;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.ENUM;
        }
        ClassType typeModel = new ClassType(fieldType, clazz, new Type[0]);
        Property property = this.createProperty(classModel, normalizedColumnName, propertyName, (Type)typeModel);
        property.getData().put("COLUMN", column);
        if (defaultValue != null) {
            property.getData().put("COLUMN_DEF", defaultValue);
        }
        if (describe != null && !describe.trim().isEmpty()) {
            property.getData().put("REMARKS", describe);
        }
        if (this.columnAnnotations) {
            property.addAnnotation((Annotation)new ColumnImpl(normalizedColumnName));
        }
        if (this.validationAnnotations) {
            int size;
            if (columnInfo.isNotNullable()) {
                property.addAnnotation((Annotation)new NotNullImpl());
            }
            int n = size = columnSize == null ? 0 : columnSize;
            if (size > 0 && clazz.equals(String.class)) {
                property.addAnnotation((Annotation)new SizeImpl(0, size));
            }
        }
        classModel.addProperty(property);
    }

    private String normalize(String str) {
        if (this.lowerCase && str != null) {
            return str.toLowerCase();
        }
        return str;
    }

    private void serialize(EntityType type, SchemaAndTable schemaAndTable) {
        try {
            String fileSuffix;
            String string = fileSuffix = this.createScalaSources ? ".scala" : ".java";
            if (this.beanSerializer != null) {
                String packageName = this.normalizePackage(this.beanPackageName, schemaAndTable);
                String path = packageName.replace('.', '/') + "/" + type.getSimpleName() + fileSuffix;
                this.write(this.beanSerializer, new File(this.beansTargetFolder, path), type);
                if (!this.ignoreMetadata) {
                    String otherPath = this.entityToWrapped.get(type).getFullName().replace('.', '/') + fileSuffix;
                    this.write(this.serializer, new File(this.targetFolder, otherPath), type);
                }
            } else {
                String packageName = this.normalizePackage(this.module.getPackageName(), schemaAndTable);
                String path = packageName.replace('.', '/') + "/" + type.getSimpleName() + fileSuffix;
                this.write(this.serializer, new File(this.targetFolder, path), type);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void write(Serializer serializer, File targetFile, EntityType type) throws IOException {
        if (!this.classes.add(targetFile.getPath())) {
            throw new IllegalStateException("Attempted to write multiple times to " + targetFile.getPath() + ", please check your configuration");
        }
        StringWriter w = new StringWriter();
        ScalaWriter writer = this.createScalaSources ? new ScalaWriter((Appendable)w) : new JavaWriter((Appendable)w);
        serializer.serialize(type, SimpleSerializerConfig.DEFAULT, (CodeWriter)writer);
        boolean generate = true;
        byte[] bytes = w.toString().getBytes(this.sourceEncoding);
        if (targetFile.exists() && targetFile.length() == (long)bytes.length) {
            String str = Files.toString((File)targetFile, (Charset)Charset.forName(this.sourceEncoding));
            if (str.equals(w.toString())) {
                generate = false;
            }
        } else {
            targetFile.getParentFile().mkdirs();
        }
        if (generate) {
            Files.write((byte[])bytes, (File)targetFile);
        }
    }

    Set<String> getClasses() {
        return this.classes;
    }

    public void setSchemaPattern(@Nullable String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(@Nullable String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setConfiguration(Configuration configuration) {
        this.module.bind(Configuration.class, (Object)configuration);
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setTargetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setBeansTargetFolder(File targetFolder) {
        this.beansTargetFolder = targetFolder;
    }

    public void setPackageName(String packageName) {
        this.module.bind("packageName", (Object)packageName);
    }

    public void setBeanPackageName(@Nullable String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public void setNamePrefix(String namePrefix) {
        this.module.bind("prefix", (Object)namePrefix);
    }

    public void setNameSuffix(String nameSuffix) {
        this.module.bind("suffix", (Object)nameSuffix);
    }

    public void setBeanPrefix(String beanPrefix) {
        this.module.bind("beanPrefix", (Object)beanPrefix);
    }

    public void setBeanSuffix(String beanSuffix) {
        this.module.bind("beanSuffix", (Object)beanSuffix);
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.module.bind(NamingStrategy.class, (Object)namingStrategy);
    }

    public void setBeanSerializer(@Nullable Serializer beanSerializer) {
        this.setBeanSerializer(beanSerializer, false);
    }

    public void setBeanSerializer(@Nullable Serializer beanSerializer, boolean ignoreMetadata) {
        this.module.bind("beanSerializer", (Object)beanSerializer);
        this.ignoreMetadata = ignoreMetadata;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.module.bind("innerClassesForKeys", (Object)innerClassesForKeys);
    }

    public void setColumnComparatorClass(Class<? extends Comparator<Property>> columnComparatorClass) {
        this.module.bind("columnComparator", columnComparatorClass);
    }

    public void setSerializerClass(Class<? extends Serializer> serializerClass) {
        this.module.bind(Serializer.class, serializerClass);
    }

    public void setEntityPathType(Class<?> classType) {
        this.module.bindInstance("entityPathType", classType);
    }

    public void setTypeMappings(TypeMappings typeMappings) {
        this.module.bind(TypeMappings.class, (Object)typeMappings);
    }

    public TypeMappings getTypeMappings() {
        return (TypeMappings)this.module.get(TypeMappings.class);
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    @Deprecated
    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
        this.module.bind("schemaToPackage", (Object)schemaToPackage);
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public void setExportTables(boolean exportTables) {
        this.exportTables = exportTables;
    }

    public void setExportViews(boolean exportViews) {
        this.exportViews = exportViews;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public void setExportKeys(boolean exportKeys) {
        this.exportKeys = exportKeys;
    }

    public void setImports(String[] imports) {
        this.module.bind("imports", new HashSet<String>(Arrays.asList(imports)));
    }

    public void setSpatial(boolean spatial) {
        this.spatial = spatial;
    }

    public void setTableTypesToExport(String tableTypesToExport) {
        this.tableTypesToExport = tableTypesToExport;
    }

    protected SuperType getSuperType(EntityType entityType) {
        return null;
    }

    private static class KeyDataConvertor {
        private final NamingStrategy namingStrategy;
        private final String packageName;
        private final String prefix;
        private final String suffix;
        private final boolean schemaToPackage;

        public KeyDataConvertor(NamingStrategy namingStrategy, String packageName, String prefix, String suffix, boolean schemaToPackage) {
            this.namingStrategy = namingStrategy;
            this.packageName = packageName;
            this.prefix = prefix;
            this.suffix = suffix;
            this.schemaToPackage = schemaToPackage;
        }

        public Collection<ForeignKeyData> toForeignKeyData(List<ForeignKeyInfo> list) {
            ArrayList<ForeignKeyData> result = new ArrayList<ForeignKeyData>();
            for (ForeignKeyInfo info : list) {
                String name = info.getName();
                String parentSchemaName = info.getParentSchema();
                String parentTableName = info.getParentTable();
                ForeignKeyData keyData = new ForeignKeyData(name, parentSchemaName, parentTableName, this.createType(parentSchemaName, parentTableName));
                int size = info.getForeignColumns().size();
                for (int i = 0; i < size; ++i) {
                    String foreignColumnName = (String)info.getForeignColumns().get(i);
                    String parentColumnName = (String)info.getParentColumns().get(i);
                    keyData.add(foreignColumnName, parentColumnName);
                }
                result.add(keyData);
            }
            return result;
        }

        public Collection<InverseForeignKeyData> toInverseForeignKeyData(List<ForeignKeyInfo> list) {
            ArrayList<InverseForeignKeyData> result = new ArrayList<InverseForeignKeyData>();
            for (ForeignKeyInfo info : list) {
                String name = info.getName();
                String foreignSchemaName = info.getForeignSchema();
                String foreignTableName = info.getForeignTable();
                InverseForeignKeyData keyData = new InverseForeignKeyData(name, foreignSchemaName, foreignTableName, this.createType(foreignSchemaName, foreignTableName));
                int size = info.getForeignColumns().size();
                for (int i = 0; i < size; ++i) {
                    String foreignColumnName = (String)info.getForeignColumns().get(i);
                    String parentColumnName = (String)info.getParentColumns().get(i);
                    keyData.add(parentColumnName, foreignColumnName);
                }
                result.add(keyData);
            }
            return result;
        }

        public Collection<IndexData> toIndexData(List<IndexInfo> list) {
            ArrayList<IndexData> result = new ArrayList<IndexData>();
            for (IndexInfo info : list) {
                String indexSchemaName = info.getSchema();
                String indexTableName = info.getTable();
                IndexData indexData = new IndexData(info, this.createType(indexSchemaName, indexTableName));
                result.add(indexData);
            }
            return result;
        }

        private Type createType(String schemaName, String table) {
            SchemaAndTable schemaAndTable = new SchemaAndTable(schemaName, table);
            String packageName = this.packageName;
            if (this.schemaToPackage) {
                packageName = this.namingStrategy.getPackage(packageName, schemaAndTable);
            }
            String simpleName = this.prefix + this.namingStrategy.getClassName(schemaAndTable) + this.suffix;
            return new SimpleType(packageName + "." + simpleName, packageName, simpleName, new Type[0]);
        }
    }
}

