/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.codegen.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.querydsl.codegen.EntitySerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.PrimaryKey;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import com.querydsl.sql.codegen.support.InverseForeignKeyData;
import com.querydsl.sql.codegen.support.KeyData;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.apexes.codegen.core.CodegenUtils;
import net.apexes.codegen.core.IndexData;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.querydsl.Index;
import net.apexes.commons.querydsl.info.IndexColumn;
import net.apexes.commons.querydsl.types.dsl.TablePathBase;

public class MetadataSerializer
extends EntitySerializer {
    private static final Map<Integer, String> typeConstants = Maps.newHashMap();
    protected final NamingStrategy namingStrategy;
    protected final boolean innerClassesForKeys;
    private final Set<String> imports;
    private final Comparator<Property> columnComparator;
    private final Class<?> entityPathType;

    @Inject
    public MetadataSerializer(TypeMappings typeMappings, NamingStrategy namingStrategy, @Named(value="innerClassesForKeys") boolean innerClassesForKeys, @Named(value="imports") Set<String> imports, @Named(value="columnComparator") Comparator<Property> columnComparator, @Named(value="entityPathType") Class<?> entityPathType) {
        super(typeMappings, Collections.emptyList());
        this.namingStrategy = namingStrategy;
        this.innerClassesForKeys = innerClassesForKeys;
        this.imports = new HashSet<String>(imports);
        this.columnComparator = columnComparator;
        if (!TablePathBase.class.isAssignableFrom(entityPathType)) {
            throw new RuntimeException("The entityPathType must extends " + TablePathBase.class);
        }
        this.entityPathType = entityPathType;
    }

    protected void constructorsForVariables(CodeWriter writer, EntityType model) throws IOException {
        super.constructorsForVariables(writer, model);
        String localName = writer.getRawName((Type)model);
        String genericName = writer.getGenericName(true, (Type)model);
        if (!localName.equals(genericName)) {
            writer.suppressWarnings("all");
        }
        writer.beginConstructor(new Parameter[]{new Parameter("variable", (Type)Types.STRING), new Parameter("schema", (Type)Types.STRING), new Parameter("table", (Type)Types.STRING)});
        writer.line(new String[]{"super", "(", writer.getClassConstant(localName) + ", " + "forVariable(variable), schema, table);"});
        this.constructorContent(writer, model);
        writer.end();
    }

    protected void constructorContent(CodeWriter writer, EntityType model) throws IOException {
        writer.line(new String[]{"addMetadata();"});
    }

    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        writer.line(new String[]{"@Generated(\"", ((Object)((Object)this)).getClass().getName(), "\")"});
        TypeCategory category = model.getOriginalCategory();
        if (model.equals((Object)queryType)) {
            for (Annotation annotation : model.getAnnotations()) {
                writer.annotation(annotation);
            }
        }
        writer.beginClass(queryType, (Type)new ClassType(category, this.entityPathType, new Type[]{model}), new Type[0]);
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", String.valueOf(model.hashCode()));
    }

    protected String getAdditionalConstructorParameter(EntityType model) {
        StringBuilder builder = new StringBuilder();
        if (model.getData().containsKey("schema")) {
            builder.append(", \"").append(model.getData().get("schema")).append("\"");
        } else {
            builder.append(", null");
        }
        builder.append(", \"").append(model.getData().get("table")).append("\"");
        return builder.toString();
    }

    protected void introDefaultInstance(CodeWriter writer, EntityType entityType, String defaultName) throws IOException {
        String variableName = !defaultName.isEmpty() ? defaultName : this.namingStrategy.getDefaultVariableName(entityType);
        String alias = this.namingStrategy.getDefaultAlias(entityType);
        Type queryType = this.typeMappings.getPathType((Type)entityType, entityType, true);
        writer.publicStaticFinal(queryType, variableName, "new " + queryType.getSimpleName() + "(\"" + alias + "\")");
    }

    protected void introImports(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        super.introImports(writer, config, model);
        Collection foreignKeys = (Collection)model.getData().get(ForeignKeyData.class);
        Collection inverseForeignKeys = (Collection)model.getData().get(InverseForeignKeyData.class);
        Collection indexs = (Collection)model.getData().get(IndexData.class);
        boolean addJavaUtilImport = false;
        if (foreignKeys != null) {
            for (ForeignKeyData keyData : foreignKeys) {
                if (keyData.getForeignColumns().size() <= 1) continue;
                addJavaUtilImport = true;
            }
        }
        if (inverseForeignKeys != null) {
            for (ForeignKeyData keyData : inverseForeignKeys) {
                if (keyData.getForeignColumns().size() <= 1) continue;
                addJavaUtilImport = true;
            }
        }
        if (indexs != null) {
            for (IndexData indexData : indexs) {
                if (indexData.getColumns().size() <= 1) continue;
                addJavaUtilImport = true;
            }
        }
        if (addJavaUtilImport) {
            writer.imports(new Package[]{List.class.getPackage()});
        }
        writer.imports(new Class[]{ColumnMetadata.class, java.sql.Types.class});
        if (!this.entityPathType.getPackage().equals(ColumnMetadata.class.getPackage())) {
            writer.imports(new Package[]{this.entityPathType.getPackage()});
        }
        this.writeUserImports(writer);
    }

    protected void writeUserImports(CodeWriter writer) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        HashSet<String> classes = new HashSet<String>();
        for (String javaImport : this.imports) {
            boolean isClass = Character.isUpperCase(javaImport.charAt(javaImport.lastIndexOf(".") + 1));
            if (isClass) {
                classes.add(javaImport);
                continue;
            }
            packages.add(javaImport);
        }
        String[] marker = new String[]{};
        writer.importPackages(packages.toArray(marker));
        writer.importClasses(classes.toArray(marker));
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.beginPublicMethod((Type)Types.VOID, "addMetadata", new Parameter[0]);
        ArrayList properties = Lists.newArrayList((Iterable)model.getProperties());
        if (this.columnComparator != null) {
            Collections.sort(properties, this.columnComparator);
        }
        for (Property property : properties) {
            String defaultValue;
            String name = property.getEscapedName();
            ColumnMetadata metadata = (ColumnMetadata)property.getData().get("COLUMN");
            StringBuilder columnMeta = new StringBuilder();
            columnMeta.append("ColumnMetadata");
            columnMeta.append(".named(\"" + metadata.getName() + "\")");
            columnMeta.append(".withIndex(" + metadata.getIndex() + ")");
            if (metadata.hasJdbcType()) {
                String type = String.valueOf(metadata.getJdbcType());
                if (typeConstants.containsKey(metadata.getJdbcType())) {
                    type = "Types." + typeConstants.get(metadata.getJdbcType());
                }
                columnMeta.append(".ofType(" + type + ")");
            }
            if (metadata.hasSize()) {
                columnMeta.append(".withSize(" + metadata.getSize() + ")");
            }
            if (metadata.getDigits() > 0) {
                columnMeta.append(".withDigits(" + metadata.getDigits() + ")");
            }
            if (!metadata.isNullable()) {
                columnMeta.append(".notNull()");
            }
            if ((defaultValue = (String)property.getData().get("COLUMN_DEF")) != null) {
                writer.line(new String[]{"addMetadata(", name, ", ", columnMeta.toString(), ", \"", defaultValue, "\");"});
                continue;
            }
            writer.line(new String[]{"addMetadata(", name, ", ", columnMeta.toString(), ");"});
        }
        writer.end();
        super.outro(model, writer);
    }

    protected void serializeProperties(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        Collection primaryKeys = (Collection)model.getData().get(PrimaryKeyData.class);
        if (this.innerClassesForKeys) {
            Collection foreignKeys = (Collection)model.getData().get(ForeignKeyData.class);
            Collection inverseForeignKeys = (Collection)model.getData().get(InverseForeignKeyData.class);
            Collection indexs = (Collection)model.getData().get(IndexData.class);
            SimpleType primaryKeyType = new SimpleType("PrimaryKeys");
            SimpleType foreignKeysType = new SimpleType("ForeignKeys");
            SimpleType inverseForeignKeysType = new SimpleType("InverseForeignKeys");
            SimpleType indexsType = new SimpleType("Indexs");
            String primaryKeysVariable = "pk";
            String foreignKeysVariable = "fk";
            String inverseForeignKeysVariable = "ifk";
            String indexsVariable = "ix";
            if (primaryKeys != null) {
                writer.beginClass((Type)primaryKeyType);
                this.serializePrimaryKeys(model, writer, primaryKeys);
                writer.end();
            }
            if (foreignKeys != null) {
                writer.beginClass((Type)foreignKeysType);
                if (foreignKeys != null) {
                    this.serializeForeignKeys(model, writer, foreignKeys, false);
                }
                writer.end();
            }
            if (inverseForeignKeys != null) {
                writer.beginClass((Type)inverseForeignKeysType);
                if (inverseForeignKeys != null) {
                    this.serializeForeignKeys(model, writer, inverseForeignKeys, true);
                }
                writer.end();
            }
            if (indexs != null) {
                writer.beginClass((Type)indexsType);
                this.serializeIndexs(model, writer, indexs);
                writer.end();
            }
            super.serializeProperties(model, config, writer);
            if (primaryKeys != null) {
                writer.publicFinal((Type)primaryKeyType, primaryKeysVariable, "new " + primaryKeyType.getSimpleName() + "()");
            }
            if (foreignKeys != null) {
                writer.publicFinal((Type)foreignKeysType, foreignKeysVariable, "new " + foreignKeysType.getSimpleName() + "()");
            }
            if (inverseForeignKeys != null) {
                writer.publicFinal((Type)inverseForeignKeysType, inverseForeignKeysVariable, "new " + inverseForeignKeysType.getSimpleName() + "()");
            }
            if (indexs != null) {
                writer.publicFinal((Type)indexsType, indexsVariable, "new " + indexsType.getSimpleName() + "()");
            }
        } else {
            super.serializeProperties(model, config, writer);
            if (primaryKeys != null) {
                this.serializePrimaryKeys(model, writer, primaryKeys);
            }
        }
    }

    protected void serialize(EntityType model, Property property, Type type, CodeWriter writer, String factoryMethod, String ... args) throws IOException {
        Field field = CodegenUtils.findAccessibleField(this.entityPathType, property.getName());
        if (field == null) {
            super.serialize(model, property, type, writer, factoryMethod, args);
        }
    }

    protected void customField(EntityType model, Property field, SerializerConfig config, CodeWriter writer) throws IOException {
        if (Enume.class.isAssignableFrom(field.getType().getJavaClass())) {
            Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
            String localRawName = writer.getRawName(field.getType());
            this.serialize(model, field, queryType, writer, "createEnume", writer.getClassConstant(localRawName));
        } else {
            Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
            String localRawName = writer.getRawName(field.getType());
            this.serialize(model, field, queryType, writer, "create" + field.getType().getSimpleName(), writer.getClassConstant(localRawName));
        }
    }

    protected void serializePrimaryKeys(EntityType model, CodeWriter writer, Collection<PrimaryKeyData> primaryKeys) throws IOException {
        for (PrimaryKeyData primaryKey : primaryKeys) {
            String fieldName = this.namingStrategy.getPropertyNameForPrimaryKey(primaryKey.getName(), model);
            StringBuilder value = new StringBuilder("createPrimaryKey(");
            boolean first = true;
            for (String column : primaryKey.getColumns()) {
                if (!first) {
                    value.append(", ");
                }
                value.append(this.namingStrategy.getPropertyName(column, model));
                first = false;
            }
            value.append(")");
            ClassType type = new ClassType(PrimaryKey.class, new Type[]{model});
            writer.publicFinal((Type)type, fieldName, value.toString());
        }
    }

    protected void serializeForeignKeys(EntityType model, CodeWriter writer, Collection<? extends KeyData> foreignKeys, boolean inverse) throws IOException {
        for (KeyData keyData : foreignKeys) {
            String fieldName = inverse ? this.namingStrategy.getPropertyNameForInverseForeignKey(keyData.getName(), model) : this.namingStrategy.getPropertyNameForForeignKey(keyData.getName(), model);
            StringBuilder value = new StringBuilder();
            if (inverse) {
                value.append("createInvForeignKey(");
            } else {
                value.append("createForeignKey(");
            }
            if (keyData.getForeignColumns().size() == 1) {
                value.append(this.namingStrategy.getPropertyName((String)keyData.getForeignColumns().get(0), model));
                value.append(", \"" + (String)keyData.getParentColumns().get(0) + "\"");
            } else {
                StringBuilder local = new StringBuilder();
                StringBuilder foreign = new StringBuilder();
                for (int i = 0; i < keyData.getForeignColumns().size(); ++i) {
                    if (i > 0) {
                        local.append(", ");
                        foreign.append(", ");
                    }
                    local.append(this.namingStrategy.getPropertyName((String)keyData.getForeignColumns().get(i), model));
                    foreign.append("\"" + (String)keyData.getParentColumns().get(i) + "\"");
                }
                value.append("Arrays.asList(" + local + "), Arrays.asList(" + foreign + ")");
            }
            value.append(")");
            ClassType type = new ClassType(ForeignKey.class, new Type[]{keyData.getType()});
            writer.publicFinal((Type)type, fieldName, value.toString());
        }
    }

    protected void serializeIndexs(EntityType model, CodeWriter writer, Collection<IndexData> indexs) throws IOException {
        for (IndexData index : indexs) {
            String fieldName = this.namingStrategy.getPropertyNameForPrimaryKey(index.getName(), model);
            StringBuilder value = new StringBuilder("createIndex(");
            value.append(index.isUnique()).append(", ");
            if (index.getColumns().size() == 1) {
                IndexColumn column = index.getColumns().get(0);
                value.append(this.namingStrategy.getPropertyName(column.getColumnName(), model));
                value.append(", " + column.isDesc());
            } else {
                StringBuilder local = new StringBuilder();
                StringBuilder desc = new StringBuilder();
                for (int i = 0; i < index.getColumns().size(); ++i) {
                    if (i > 0) {
                        local.append(", ");
                        desc.append(", ");
                    }
                    IndexColumn column = index.getColumns().get(i);
                    local.append(this.namingStrategy.getPropertyName(column.getColumnName(), model));
                    desc.append(column.isDesc());
                }
                value.append("Arrays.asList(" + local + "), Arrays.asList(" + desc + ")");
            }
            value.append(")");
            ClassType type = new ClassType(Index.class, new Type[]{index.getType()});
            writer.publicFinal((Type)type, fieldName, value.toString());
        }
    }

    static {
        try {
            for (Field field : java.sql.Types.class.getDeclaredFields()) {
                if (!field.getType().equals(Integer.TYPE)) continue;
                typeConstants.put(field.getInt(null), field.getName());
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

