/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.codegen.core;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.core.util.BeanUtils;
import com.querydsl.sql.ColumnMetadata;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.apexes.codegen.core.CodegenUtils;
import net.apexes.codegen.core.EntityModel;
import net.apexes.codegen.core.SuperType;

public class OrmliteEntityBeanSerializer {
    private static final Function<Property, Parameter> propertyToParameter = new Function<Property, Parameter>(){

        public Parameter apply(Property input) {
            return new Parameter(input.getName(), input.getType());
        }
    };
    private final boolean propertyAnnotations;
    private final List<Type> interfaces = Lists.newArrayList();
    private final String javadocSuffix;
    private boolean addToString;
    private boolean addFullConstructor;
    private Class<?> daoClass = null;

    public OrmliteEntityBeanSerializer() {
        this(true, " is a ORMLite bean type");
    }

    public OrmliteEntityBeanSerializer(String javadocSuffix) {
        this(true, javadocSuffix);
    }

    public OrmliteEntityBeanSerializer(boolean propertyAnnotations) {
        this(propertyAnnotations, " is a ORMLite bean type");
    }

    public OrmliteEntityBeanSerializer(boolean propertyAnnotations, String javadocSuffix) {
        this.propertyAnnotations = propertyAnnotations;
        this.javadocSuffix = javadocSuffix;
    }

    public void serialize(EntityModel model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        ArrayList<Type> interfaceList = new ArrayList<Type>();
        interfaceList.addAll(this.interfaces);
        interfaceList.addAll(model.getInterfaces());
        Set<String> importedClasses = this.getAnnotationTypes(model);
        for (Type iface : interfaceList) {
            importedClasses.add(iface.getFullName());
        }
        if (model.hasLists()) {
            importedClasses.add(List.class.getName());
        }
        if (model.hasCollections()) {
            importedClasses.add(Collection.class.getName());
        }
        if (model.hasSets()) {
            importedClasses.add(Set.class.getName());
        }
        if (model.hasMaps()) {
            importedClasses.add(Map.class.getName());
        }
        if (this.addToString && model.hasArrays()) {
            importedClasses.add(Arrays.class.getName());
        }
        if (this.daoClass != null) {
            importedClasses.add(this.daoClass.getName());
        }
        if (!importedClasses.isEmpty()) {
            writer.importClasses(importedClasses.toArray(new String[importedClasses.size()]));
        }
        writer.importPackages(new String[]{DatabaseField.class.getPackage().getName(), DatabaseTable.class.getPackage().getName()});
        writer.javadoc(new String[]{simpleName + this.javadocSuffix + ". Corresponds to the database table \"" + model.getData().get("table") + "\""});
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        StringBuilder sb = new StringBuilder("@DatabaseTable(tableName = \"");
        sb.append((String)model.getData().get("table"));
        sb.append("\"");
        if (this.daoClass != null) {
            sb.append(", daoClass = ");
            sb.append(this.daoClass.getSimpleName());
            sb.append(".class");
        }
        sb.append(")");
        writer.line(new String[]{sb.toString()});
        Type superType = null;
        if (model.getSuperType() != null) {
            superType = model.getSuperType().getType();
        }
        if (!interfaceList.isEmpty()) {
            Type[] ifaces = interfaceList.toArray(new Type[interfaceList.size()]);
            writer.beginClass((Type)model, superType, ifaces);
        } else {
            writer.beginClass((Type)model, superType, new Type[0]);
        }
        this.bodyStart(model, writer);
        if (this.addFullConstructor) {
            this.addFullConstructor(model, writer);
        }
        Set<Property> properties = CodegenUtils.getProperties(model);
        this.serializeProperties(model, properties, writer);
        if (this.addToString) {
            this.addToString(properties, writer);
        }
        this.bodyEnd(model, writer);
        writer.end();
    }

    protected void serializeProperties(EntityModel model, Set<Property> properties, CodeWriter writer) throws IOException {
        writer.javadoc(new String[]{"The columns of table \"" + model.getData().get("table") + "\""});
        SimpleType type = new SimpleType("$");
        SuperType supertype = model.getSuperType();
        if (supertype == null) {
            writer.beginInterface((Type)type, new Type[0]);
        } else {
            SimpleType interfaceType = new SimpleType(TypeCategory.ENTITY, supertype.getType().getFullName() + ".$", supertype.getType().getPackageName(), "$", false, false, new Type[0]);
            writer.beginInterface((Type)type, new Type[]{interfaceType});
        }
        for (Property property : properties) {
            ColumnMetadata metadata = (ColumnMetadata)property.getData().get("COLUMN");
            String columnName = metadata.getName();
            writer.javadoc(new String[]{columnName});
            writer.publicStaticFinal((Type)Types.STRING, property.getEscapedName(), "\"" + (String)columnName + "\"");
        }
        writer.end();
        StringBuilder sb = new StringBuilder();
        for (Property property : properties) {
            if (this.propertyAnnotations) {
                for (Annotation annotation : property.getAnnotations()) {
                    writer.annotation(annotation);
                }
            }
            sb.setLength(0);
            sb.append(property.getEscapedName());
            switch (property.getType().getCategory()) {
                case DATE: 
                case DATETIME: 
                case TIME: {
                    sb.append(", dataType = DataType.DATE");
                    break;
                }
            }
            ColumnMetadata metadata = (ColumnMetadata)property.getData().get("COLUMN");
            if (!metadata.isNullable()) {
                sb.append(", canBeNull = false");
            }
            writer.line(new String[]{"@DatabaseField(columnName = $.", sb.toString(), ")"});
            writer.privateField(property.getType(), property.getEscapedName());
        }
        for (Property property : properties) {
            String propertyName = property.getEscapedName();
            writer.beginPublicMethod(property.getType(), "get" + BeanUtils.capitalize((String)propertyName), new Parameter[0]);
            writer.line(new String[]{"return ", propertyName, ";"});
            writer.end();
            Parameter parameter = new Parameter(propertyName, property.getType());
            writer.beginPublicMethod((Type)Types.VOID, "set" + BeanUtils.capitalize((String)propertyName), new Parameter[]{parameter});
            writer.line(new String[]{"this.", propertyName, " = ", propertyName, ";"});
            writer.end();
        }
    }

    protected void addFullConstructor(EntityModel model, CodeWriter writer) throws IOException {
        writer.beginConstructor(new Parameter[0]);
        writer.end();
        writer.beginConstructor((Collection)model.getProperties(), propertyToParameter);
        for (Property property : model.getProperties()) {
            writer.line(new String[]{"this.", property.getEscapedName(), " = ", property.getEscapedName(), ";"});
        }
        writer.end();
    }

    protected void addToString(Set<Property> properties, CodeWriter writer) throws IOException {
        if (!properties.isEmpty()) {
            writer.line(new String[]{"@Override"});
            writer.beginPublicMethod((Type)Types.STRING, "toString", new Parameter[0]);
            writer.line(new String[]{"StringBuilder sb = new StringBuilder();"});
            writer.line(new String[]{"sb.append(super.toString());"});
            for (Property property : properties) {
                String propertyName = property.getEscapedName();
                writer.line(new String[]{"sb.append(\",", propertyName, "=\").append(", propertyName, ");"});
            }
            writer.line(new String[]{"return sb.toString();"});
            writer.end();
        }
    }

    protected void bodyStart(EntityModel model, CodeWriter writer) throws IOException {
        Class superClass;
        SuperType supertype = model.getSuperType();
        if (supertype != null && Serializable.class.isAssignableFrom(superClass = supertype.getType().getJavaClass())) {
            writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", "1L");
        }
    }

    protected void bodyEnd(EntityModel model, CodeWriter writer) throws IOException {
    }

    private Set<String> getAnnotationTypes(EntityModel model) {
        TreeSet<String> imports = new TreeSet<String>();
        for (Annotation annotation : model.getAnnotations()) {
            imports.add(annotation.annotationType().getName());
        }
        if (this.propertyAnnotations) {
            for (Property property : model.getProperties()) {
                for (Annotation annotation : property.getAnnotations()) {
                    imports.add(annotation.annotationType().getName());
                }
            }
        }
        return imports;
    }

    public void addInterface(Class<?> iface) {
        this.interfaces.add((Type)new ClassType(iface, new Type[0]));
    }

    public void addInterface(Type type) {
        this.interfaces.add(type);
    }

    public void setAddToString(boolean addToString) {
        this.addToString = addToString;
    }

    public void setAddFullConstructor(boolean addFullConstructor) {
        this.addFullConstructor = addFullConstructor;
    }

    public void setDaoClass(Class<?> daoClass) {
        this.daoClass = daoClass;
    }
}

